/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class InjectionUtils {
    private static final Key<Boolean> INJECT_LANGUAGE_ACTION_ENABLED_FOR_HOST = Key.create((String)"inject language action enabled for host");
    private static final Key<Boolean> INSPECT_INJECTED_FILES = Key.create((String)"run inspections for files injected into this PSI file");
    private static final Key<Boolean> COLLECT_LINE_MARKERS_FOR_INJECTED_FILES = Key.create((String)"collect line markers for files injected into this PSI file");
    private static final Key<Boolean> DO_POSTPROCESS_FORMATTING_ONLY_FOR_INJECTED_FRAGMENTS = Key.create((String)"create reformatting actions only for PSI elements injected into this host");

    public static void enableInjectLanguageAction(@NotNull PsiElement host, boolean enabled) {
        if (host == null) {
            InjectionUtils.$$$reportNull$$$0(0);
        }
        host.putUserData(INJECT_LANGUAGE_ACTION_ENABLED_FOR_HOST, enabled);
    }

    public static boolean isInjectLanguageActionEnabled(@NotNull PsiElement host) {
        if (host == null) {
            InjectionUtils.$$$reportNull$$$0(1);
        }
        return !Boolean.FALSE.equals(host.getUserData(INJECT_LANGUAGE_ACTION_ENABLED_FOR_HOST));
    }

    public static void setInspectInjectedFiles(@NotNull PsiFile topLevelFile, boolean enabled) {
        if (topLevelFile == null) {
            InjectionUtils.$$$reportNull$$$0(2);
        }
        topLevelFile.putUserData(INSPECT_INJECTED_FILES, enabled);
    }

    public static boolean shouldInspectInjectedFiles(@NotNull PsiFile file) {
        if (file == null) {
            InjectionUtils.$$$reportNull$$$0(3);
        }
        return !Boolean.FALSE.equals(file.getUserData(INSPECT_INJECTED_FILES));
    }

    public static void setCollectLineMarkersForInjectedFiles(@NotNull PsiFile topLevelFile, boolean enabled) {
        if (topLevelFile == null) {
            InjectionUtils.$$$reportNull$$$0(4);
        }
        topLevelFile.putUserData(COLLECT_LINE_MARKERS_FOR_INJECTED_FILES, enabled);
    }

    public static boolean shouldCollectLineMarkersForInjectedFiles(@NotNull PsiFile file) {
        if (file == null) {
            InjectionUtils.$$$reportNull$$$0(5);
        }
        return !Boolean.FALSE.equals(file.getUserData(COLLECT_LINE_MARKERS_FOR_INJECTED_FILES));
    }

    public static void setFormatOnlyInjectedCode(@NotNull FileViewProvider topLevelViewProvider, boolean enabled) {
        if (topLevelViewProvider == null) {
            InjectionUtils.$$$reportNull$$$0(6);
        }
        topLevelViewProvider.putUserData(DO_POSTPROCESS_FORMATTING_ONLY_FOR_INJECTED_FRAGMENTS, enabled);
    }

    public static boolean shouldFormatOnlyInjectedCode(@NotNull FileViewProvider topLevelViewProvider) {
        if (topLevelViewProvider == null) {
            InjectionUtils.$$$reportNull$$$0(7);
        }
        return Boolean.TRUE.equals(topLevelViewProvider.getUserData(DO_POSTPROCESS_FORMATTING_ONLY_FOR_INJECTED_FRAGMENTS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelViewProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/InjectionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "enableInjectLanguageAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectLanguageActionEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setInspectInjectedFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInspectInjectedFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setCollectLineMarkersForInjectedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCollectLineMarkersForInjectedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setFormatOnlyInjectedCode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldFormatOnlyInjectedCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

