/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.connection.EventLogSettingsClient;
import com.jetbrains.fus.reporting.FusHttpClient;
import com.jetbrains.fus.reporting.FusJsonSerializer;
import com.jetbrains.fus.reporting.configuration.ConfigurationClient;
import com.jetbrains.fus.reporting.configuration.ConfigurationClientFactory;
import com.jetbrains.fus.reporting.configuration.RegionCode;
import com.jetbrains.fus.reporting.jvm.JvmHttpClient;
import com.jetbrains.fus.reporting.jvm.ProxyInfo;
import com.jetbrains.fus.reporting.jvm.ProxyProvider;
import com.jetbrains.fus.reporting.model.serialization.SerializationException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsClient;", "Lcom/intellij/internal/statistic/eventLog/connection/EventLogSettingsClient;", "recorderId", "", "applicationInfo", "Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "cacheTimeoutMs", "", "<init>", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;J)V", "getRecorderId", "()Ljava/lang/String;", "getApplicationInfo", "()Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "configurationClient", "Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "getConfigurationClient", "()Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "setConfigurationClient", "(Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;)V", "Companion", "FusJacksonSerializer", "CustomPrettyPrinter", "intellij.platform.statistics.uploader"})
@ApiStatus.Internal
public class EventLogUploadSettingsClient
extends EventLogSettingsClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private final EventLogApplicationInfo applicationInfo;
    @NotNull
    private ConfigurationClient configurationClient;
    @NotNull
    public static final String chinaRegion = "china";

    public EventLogUploadSettingsClient(@NotNull String recorderId, @NotNull EventLogApplicationInfo applicationInfo, long cacheTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)applicationInfo, (String)"applicationInfo");
        this.recorderId = recorderId;
        this.applicationInfo = applicationInfo;
        ConfigurationClientFactory.Companion companion = ConfigurationClientFactory.Companion;
        String string = this.getRecorderId();
        String string2 = this.getApplicationInfo().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProductCode(...)");
        String string3 = string2;
        String string4 = this.getApplicationInfo().getProductVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProductVersion(...)");
        String string5 = string4;
        boolean bl = this.getApplicationInfo().isTestConfig();
        ProxyProvider proxyProvider = arg_0 -> EventLogUploadSettingsClient.configurationClient$lambda$0(this, arg_0);
        Object object = this.getApplicationInfo().getConnectionSettings().provideUserAgent();
        JvmHttpClient jvmHttpClient = new JvmHttpClient(() -> EventLogUploadSettingsClient.configurationClient$lambda$1(this), proxyProvider, (String)object, () -> EventLogUploadSettingsClient.configurationClient$lambda$2(this), null, 16, null);
        proxyProvider = Intrinsics.areEqual((Object)this.getApplicationInfo().getRegionalCode(), (Object)chinaRegion) ? RegionCode.CN : RegionCode.ALL;
        object = new FusJacksonSerializer();
        this.configurationClient = companion.create(string, string3, string5, bl, (FusHttpClient)jvmHttpClient, (RegionCode)proxyProvider, cacheTimeoutMs, (FusJsonSerializer)object);
    }

    public /* synthetic */ EventLogUploadSettingsClient(String string, EventLogApplicationInfo eventLogApplicationInfo, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = TimeUnit.MINUTES.toMillis(10L);
        }
        this(string, eventLogApplicationInfo, l);
    }

    @Override
    @NotNull
    public String getRecorderId() {
        return this.recorderId;
    }

    @Override
    @NotNull
    public EventLogApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @Override
    @NotNull
    public ConfigurationClient getConfigurationClient() {
        return this.configurationClient;
    }

    public void setConfigurationClient(@NotNull ConfigurationClient configurationClient) {
        Intrinsics.checkNotNullParameter((Object)configurationClient, (String)"<set-?>");
        this.configurationClient = configurationClient;
    }

    private static final ProxyInfo configurationClient$lambda$0(EventLogUploadSettingsClient this$0, String configurationUrl) {
        Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
        return new ProxyInfo(this$0.getApplicationInfo().getConnectionSettings().provideProxy(configurationUrl).getProxy(), null, 2, null);
    }

    private static final SSLContext configurationClient$lambda$1(EventLogUploadSettingsClient this$0) {
        return this$0.getApplicationInfo().getConnectionSettings().provideSSLContext();
    }

    private static final Map configurationClient$lambda$2(EventLogUploadSettingsClient this$0) {
        return this$0.getApplicationInfo().getConnectionSettings().provideExtraHeaders();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsClient$Companion;", "", "<init>", "()V", "chinaRegion", "", "intellij.platform.statistics.uploader"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0001H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsClient$CustomPrettyPrinter;", "Lcom/fasterxml/jackson/core/util/DefaultPrettyPrinter;", "<init>", "()V", "base", "(Lcom/fasterxml/jackson/core/util/DefaultPrettyPrinter;)V", "writeObjectFieldValueSeparator", "", "g", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeEndArray", "nrOfValues", "", "writeEndObject", "nrOfEntries", "createInstance", "intellij.platform.statistics.uploader"})
    private static final class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        public CustomPrettyPrinter() {
            this._objectIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
            this._arrayIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
        }

        public CustomPrettyPrinter(@Nullable DefaultPrettyPrinter base) {
            super(base);
            this._objectIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
            this._arrayIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
        }

        public void writeObjectFieldValueSeparator(@NotNull JsonGenerator g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.writeRaw(": ");
        }

        public void writeEndArray(@NotNull JsonGenerator g, int nrOfValues) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!this._arrayIndenter.isInline()) {
                this._nesting += -1;
            }
            if (nrOfValues > 0) {
                this._arrayIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw(']');
        }

        public void writeEndObject(@NotNull JsonGenerator g, int nrOfEntries) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!this._objectIndenter.isInline()) {
                this._nesting += -1;
            }
            if (nrOfEntries > 0) {
                this._objectIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw('}');
        }

        @NotNull
        public DefaultPrettyPrinter createInstance() {
            return new CustomPrettyPrinter(this);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J)\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/eventLog/connection/EventLogUploadSettingsClient$FusJacksonSerializer;", "Lcom/jetbrains/fus/reporting/FusJsonSerializer;", "<init>", "()V", "SERIALIZATION_MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "getSERIALIZATION_MAPPER", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "SERIALIZATION_MAPPER$delegate", "Lkotlin/Lazy;", "DESERIALIZATION_MAPPER", "getDESERIALIZATION_MAPPER", "DESERIALIZATION_MAPPER$delegate", "toJson", "", "data", "", "fromJson", "T", "json", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "intellij.platform.statistics.uploader"})
    public static final class FusJacksonSerializer
    implements FusJsonSerializer {
        @NotNull
        private final Lazy SERIALIZATION_MAPPER$delegate = LazyKt.lazy(FusJacksonSerializer::SERIALIZATION_MAPPER_delegate$lambda$0);
        @NotNull
        private final Lazy DESERIALIZATION_MAPPER$delegate = LazyKt.lazy(FusJacksonSerializer::DESERIALIZATION_MAPPER_delegate$lambda$0);

        private final JsonMapper getSERIALIZATION_MAPPER() {
            Lazy lazy = this.SERIALIZATION_MAPPER$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (JsonMapper)object;
        }

        private final JsonMapper getDESERIALIZATION_MAPPER() {
            Lazy lazy = this.DESERIALIZATION_MAPPER$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (JsonMapper)object;
        }

        @NotNull
        public String toJson(@NotNull Object data) {
            String string;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            try {
                string = this.getSERIALIZATION_MAPPER().writerWithDefaultPrettyPrinter().writeValueAsString(data);
                Intrinsics.checkNotNull((Object)string);
            }
            catch (Exception e) {
                throw new SerializationException((Throwable)e);
            }
            return string;
        }

        public <T> T fromJson(@NotNull String json, @NotNull Class<T> clazz) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            try {
                object = this.getDESERIALIZATION_MAPPER().readValue(json, clazz);
            }
            catch (Exception e) {
                throw new SerializationException((Throwable)e);
            }
            return (T)object;
        }

        private static final JsonMapper SERIALIZATION_MAPPER_delegate$lambda$0() {
            MapperFeature[] mapperFeatureArray = new MapperFeature[]{MapperFeature.REQUIRE_SETTERS_FOR_GETTERS};
            return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(mapperFeatureArray)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).defaultPrettyPrinter((PrettyPrinter)new CustomPrettyPrinter())).build();
        }

        private static final JsonMapper DESERIALIZATION_MAPPER_delegate$lambda$0() {
            DeserializationFeature[] deserializationFeatureArray = new DeserializationFeature[]{DeserializationFeature.USE_LONG_FOR_INTS};
            JsonMapper.Builder builder = (JsonMapper.Builder)JsonMapper.builder().enable(deserializationFeatureArray);
            deserializationFeatureArray = new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION};
            return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)builder.enable((JsonParser.Feature[])deserializationFeatureArray)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
        }
    }
}

