/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vcs.changes.ui.RepositoryChangesBrowserNodeBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.CheckboxIcon;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerFactory;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0002H\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0004J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/RepositoryChangesBrowserNodeBase;", "Lcom/intellij/dvcs/repo/Repository;", "Lcom/intellij/vcs/branch/BranchData;", "repository", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "<init>", "(Lcom/intellij/dvcs/repo/Repository;Lcom/intellij/vcs/log/ui/VcsLogColorManager;)V", "getIcon", "Ljavax/swing/Icon;", "getCurrentBranch", "getBranchText", "", "branch", "getBranchTooltipText", "compareUserObjects", "", "o2", "getTextPresentation", "getNodeFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "intellij.platform.vcs.dvcs.impl"})
public class RepositoryChangesBrowserNode
extends RepositoryChangesBrowserNodeBase<Repository, BranchData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogColorManager colorManager;

    public RepositoryChangesBrowserNode(@NotNull Repository repository, @NotNull VcsLogColorManager colorManager) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        super((Object)repository);
        this.colorManager = colorManager;
    }

    public /* synthetic */ RepositoryChangesBrowserNode(Repository repository, VcsLogColorManager vcsLogColorManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            vcsLogColorManager = Companion.getColorManager(project);
        }
        this(repository, vcsLogColorManager);
    }

    @NotNull
    protected Icon getIcon() {
        Color color = this.colorManager.getRootColor(((Repository)this.getUserObject()).getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getRootColor(...)");
        return (Icon)CheckboxIcon.createAndScale((Color)color);
    }

    @Nullable
    protected final BranchData getCurrentBranch(@NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        return CurrentBranchComponent.Companion.getCurrentBranch(project, virtualFile);
    }

    @NotNull
    protected final String getBranchText(@NotNull BranchData branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return BranchPresentation.INSTANCE.getPresentableText(branch);
    }

    @NotNull
    protected final String getBranchTooltipText(@NotNull BranchData branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        String string = BranchPresentation.INSTANCE.getSingleTooltip(branch);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int compareUserObjects(@NotNull Repository o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return ChangesBrowserNode.compareFileNames((String)DvcsUtil.getShortRepositoryName((Repository)this.getUserObject()), (String)DvcsUtil.getShortRepositoryName(o2));
    }

    @NotNull
    public String getTextPresentation() {
        String string = DvcsUtil.getShortRepositoryName((Repository)this.getUserObject());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortRepositoryName(...)");
        return string;
    }

    @NotNull
    public FilePath getNodeFilePath() {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)((Repository)this.getUserObject()).getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode$Companion;", "", "<init>", "()V", "getColorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VcsLogColorManager getColorManager(@NotNull Project project) {
            VcsLogColorManager colorManager;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(project).getLogManager();
            Object object = colorManager = vcsLogManager != null ? vcsLogManager.getColorManager() : null;
            if (colorManager != null) {
                return colorManager;
            }
            Set roots = VcsLogManager.Companion.findLogProviders((Collection)ArraysKt.asList((Object[])ProjectLevelVcsManager.Companion.getInstance(project).getAllVcsRoots()), project).keySet();
            return VcsLogColorManagerFactory.create(roots);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

