/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.library.KlibElementWithSize;
import org.jetbrains.kotlin.library.KlibSizeInfoKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0004*\u00020\u0005H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\u000b*\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0002\"\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"isWindows", "", "()Z", "entries", "", "Lorg/jetbrains/kotlin/konan/file/File;", "getEntries", "(Lorg/jetbrains/kotlin/konan/file/File;)Ljava/util/List;", "buildElement", "Lorg/jetbrains/kotlin/library/KlibElementWithSize;", "name", "", "entry", "buildIrElement", "loadSizeInfo", "klibFile", "collectTopLevelElements", "cumulativeSize", "", "normalizeEntryName", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKlibSizeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibSizeInfo.kt\norg/jetbrains/kotlin/library/KlibSizeInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1056#2:150\n1056#2:151\n1563#2:152\n1634#2,2:153\n1636#2:156\n1634#2,3:157\n1056#2:160\n1#3:155\n*S KotlinDebug\n*F\n+ 1 KlibSizeInfo.kt\norg/jetbrains/kotlin/library/KlibSizeInfoKt\n*L\n90#1:150\n91#1:151\n94#1:152\n94#1:153,2\n94#1:156\n124#1:157,3\n141#1:160\n*E\n"})
public final class KlibSizeInfoKt {
    @Nullable
    public static final KlibElementWithSize loadSizeInfo(@NotNull File klibFile) {
        Intrinsics.checkNotNullParameter((Object)klibFile, (String)"klibFile");
        File libraryFile = klibFile.getAbsoluteFile();
        return libraryFile.isFile() ? new KlibElementWithSize("KLIB file cumulative size", (List)ZipUtilKt.withZipFileSystem(libraryFile, loadSizeInfo.1.INSTANCE)) : (!libraryFile.isDirectory() ? null : new KlibElementWithSize("KLIB directory cumulative size", KlibSizeInfoKt.collectTopLevelElements(libraryFile)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KlibElementWithSize> collectTopLevelElements(File $this$collectTopLevelElements) {
        void $this$mapTo$iv$iv;
        List list;
        List list2;
        List list3;
        Object defaultEntry = null;
        ArrayList otherTopLevelEntries = new ArrayList();
        for (File file : KlibSizeInfoKt.getEntries($this$collectTopLevelElements)) {
            if (Intrinsics.areEqual((Object)KlibSizeInfoKt.normalizeEntryName(file.getName()), (Object)"default") && file.isDirectory()) {
                defaultEntry = file;
                continue;
            }
            ((Collection)otherTopLevelEntries).add(file);
        }
        List $this$collectTopLevelElements_u24lambda_u241 = list3 = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-KlibSizeInfoKt$collectTopLevelElements$topLevelEntries$232 = false;
        Collection collection = $this$collectTopLevelElements_u24lambda_u241;
        Object object = defaultEntry;
        if (object != null && (object = KlibSizeInfoKt.getEntries(object)) != null) {
            Iterable $this$sortedBy$iv = (Iterable)object;
            boolean $i$f$sortedBy = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File p0 = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getName());
                    p0 = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getName())));
                }
            });
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = $this$collectTopLevelElements_u24lambda_u241;
        Iterable $this$sortedBy$iv = otherTopLevelEntries;
        boolean $i$f$sortedBy22 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File p0 = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getName());
                p0 = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getName())));
            }
        });
        CollectionsKt.addAll((Collection)collection, (Iterable)$this$sortedBy$iv);
        List topLevelEntries = CollectionsKt.build((List)list3);
        Iterable iterable2 = topLevelEntries;
        boolean $i$f$map = false;
        Iterable $i$a$-buildList-KlibSizeInfoKt$collectTopLevelElements$topLevelEntries$232 = iterable2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KlibElementWithSize klibElementWithSize;
            void topLevelEntry;
            File $i$f$sortedBy22 = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            switch (KlibSizeInfoKt.normalizeEntryName(topLevelEntry.getName())) {
                case "ir": {
                    klibElementWithSize = KlibSizeInfoKt.buildIrElement("IR (main)", (File)topLevelEntry);
                    break;
                }
                case "ir_inlinable_functions": {
                    klibElementWithSize = KlibSizeInfoKt.buildIrElement("IR (inlinable functions)", (File)topLevelEntry);
                    break;
                }
                case "linkdata": {
                    klibElementWithSize = KlibSizeInfoKt.buildElement("Metadata", (File)topLevelEntry);
                    break;
                }
                case "targets": {
                    klibElementWithSize = KlibSizeInfoKt.buildElement("Native-specific binary data", (File)topLevelEntry);
                    break;
                }
                case "manifest": {
                    klibElementWithSize = KlibSizeInfoKt.buildElement("Manifest file", (File)topLevelEntry);
                    break;
                }
                default: {
                    String string;
                    String topLevelEntryName;
                    String string2 = topLevelEntryName;
                    if (((CharSequence)string2).length() > 0) {
                        void it;
                        char c = string2.charAt(0);
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl2 = false;
                        StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase((char)it) ? CharsKt.titlecase((char)it) : String.valueOf((char)it)));
                        String string3 = string2;
                        int n = 1;
                        String string4 = string3.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        string = stringBuilder2.append(string4).toString();
                    } else {
                        string = string2;
                    }
                    klibElementWithSize = KlibSizeInfoKt.buildElement(string, (File)topLevelEntry);
                }
            }
            collection2.add(klibElementWithSize);
        }
        return (List)destination$iv$iv;
    }

    private static final List<File> getEntries(File $this$entries) {
        return $this$entries.getListFiles();
    }

    /*
     * WARNING - void declaration
     */
    private static final long cumulativeSize(File $this$cumulativeSize) {
        long l;
        if ($this$cumulativeSize.isFile()) {
            l = $this$cumulativeSize.getSize();
        } else if ($this$cumulativeSize.isDirectory()) {
            Iterable iterable = KlibSizeInfoKt.getEntries($this$cumulativeSize);
            long l2 = 0L;
            for (Object t : iterable) {
                void it;
                File file = (File)t;
                long l3 = l2;
                boolean bl = false;
                long l4 = KlibSizeInfoKt.cumulativeSize((File)it);
                l2 = l3 + l4;
            }
            l = l2;
        } else {
            l = 0L;
        }
        return l;
    }

    private static final KlibElementWithSize buildElement(String name2, File entry) {
        return new KlibElementWithSize(name2, KlibSizeInfoKt.cumulativeSize(entry));
    }

    /*
     * WARNING - void declaration
     */
    private static final KlibElementWithSize buildIrElement(String name2, File entry) {
        ArrayList nestedElements = new ArrayList();
        Iterable $this$mapTo$iv = KlibSizeInfoKt.getEntries(entry);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string;
            void childEntry;
            File file = (File)item$iv;
            Collection collection = nestedElements;
            boolean bl = false;
            switch (KlibSizeInfoKt.normalizeEntryName(childEntry.getName())) {
                case "files.knf": {
                    string = "IR files";
                    break;
                }
                case "fileEntries.knf": {
                    string = "IR file entries";
                    break;
                }
                case "irDeclarations.knd": {
                    string = "IR declarations";
                    break;
                }
                case "bodies.knb": {
                    string = "IR bodies";
                    break;
                }
                case "types.knt": {
                    string = "IR types";
                    break;
                }
                case "signatures.knt": {
                    string = "IR signatures";
                    break;
                }
                case "debugInfo.knd": {
                    string = "IR signatures (debug info)";
                    break;
                }
                case "strings.knt": {
                    string = "IR strings";
                    break;
                }
                default: {
                    String childName;
                    string = childName;
                }
            }
            String prettyName = string;
            collection.add(KlibSizeInfoKt.buildElement(prettyName, (File)childEntry));
        }
        Iterable $this$sortedBy$iv = nestedElements;
        boolean $i$f$sortedBy = false;
        return new KlibElementWithSize(name2, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KlibElementWithSize it = (KlibElementWithSize)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KlibElementWithSize)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final String normalizeEntryName(String $this$normalizeEntryName) {
        String string;
        if (KlibSizeInfoKt.isWindows()) {
            String string2;
            Object object = $this$normalizeEntryName;
            if (((CharSequence)object).length() > 0) {
                void it;
                char c = ((String)object).charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string3 = String.valueOf((char)it);
                Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                Object object2 = object;
                int n = 1;
                String string5 = ((String)object2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                string2 = stringBuilder2.append(string5).toString();
            } else {
                string2 = object;
            }
            object = new char[1];
            object[0] = 47;
            string = StringsKt.trimEnd((String)string2, (char[])object);
        } else {
            string = $this$normalizeEntryName;
        }
        return string;
    }

    private static final boolean isWindows() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        return StringsKt.startsWith((String)string, (String)"Windows", (boolean)true);
    }

    public static final /* synthetic */ List access$collectTopLevelElements(File $receiver) {
        return KlibSizeInfoKt.collectTopLevelElements($receiver);
    }
}

