/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.loader;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.impl.KlibImpl;
import org.jetbrains.kotlin.library.loader.KlibLibraryProvider;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;
import org.jetbrains.kotlin.library.loader.KlibManifestTransformer;
import org.jetbrains.kotlin.library.loader.KlibPlatformChecker;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001#B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl;", "", "libraryProviders", "", "Lorg/jetbrains/kotlin/library/loader/KlibLibraryProvider;", "platformChecker", "Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "maxPermittedAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "zipFileSystemAccessor", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "manifestTransformer", "Lorg/jetbrains/kotlin/library/loader/KlibManifestTransformer;", "(Ljava/util/List;Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;Lorg/jetbrains/kotlin/library/loader/KlibManifestTransformer;)V", "problematicLibraries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblematicLibrary;", "Lkotlin/collections/ArrayList;", "visitedCanonicalPaths", "Ljava/util/LinkedHashMap;", "Ljava/nio/file/Path;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus;", "Lkotlin/collections/LinkedHashMap;", "visitedRawPaths", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "loadLibraries", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult;", "loadLibrariesSuggestedByProvider", "", "libraryProvider", "loadSingleLibrary", "rawPath", "validPath", "LibraryStatus", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKlibLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibLoader.kt\norg/jetbrains/kotlin/library/loader/KlibLoaderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,295:1\n1869#2,2:296\n1869#2:298\n1869#2,2:299\n1870#2:301\n1869#2,2:302\n1869#2,2:304\n*S KotlinDebug\n*F\n+ 1 KlibLoader.kt\norg/jetbrains/kotlin/library/loader/KlibLoaderImpl\n*L\n165#1:296,2\n169#1:298\n183#1:299,2\n169#1:301\n196#1:302,2\n202#1:304,2\n*E\n"})
final class KlibLoaderImpl {
    @NotNull
    private final List<KlibLibraryProvider> libraryProviders;
    @Nullable
    private final KlibPlatformChecker platformChecker;
    @Nullable
    private final KotlinAbiVersion maxPermittedAbiVersion;
    @NotNull
    private final ZipFileSystemAccessor zipFileSystemAccessor;
    @Nullable
    private final KlibManifestTransformer manifestTransformer;
    @NotNull
    private final HashSet<String> visitedRawPaths;
    @NotNull
    private final LinkedHashMap<Path, LibraryStatus> visitedCanonicalPaths;
    @NotNull
    private final ArrayList<KlibLoaderResult.ProblematicLibrary> problematicLibraries;

    public KlibLoaderImpl(@NotNull List<? extends KlibLibraryProvider> libraryProviders, @Nullable KlibPlatformChecker platformChecker, @Nullable KotlinAbiVersion maxPermittedAbiVersion, @NotNull ZipFileSystemAccessor zipFileSystemAccessor, @Nullable KlibManifestTransformer manifestTransformer) {
        Intrinsics.checkNotNullParameter(libraryProviders, (String)"libraryProviders");
        Intrinsics.checkNotNullParameter((Object)zipFileSystemAccessor, (String)"zipFileSystemAccessor");
        this.libraryProviders = libraryProviders;
        this.platformChecker = platformChecker;
        this.maxPermittedAbiVersion = maxPermittedAbiVersion;
        this.zipFileSystemAccessor = zipFileSystemAccessor;
        this.manifestTransformer = manifestTransformer;
        this.visitedRawPaths = new HashSet();
        this.visitedCanonicalPaths = new LinkedHashMap();
        this.problematicLibraries = new ArrayList();
    }

    @NotNull
    public final KlibLoaderResult loadLibraries() {
        Iterable $this$forEach$iv = this.libraryProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KlibLibraryProvider libraryProvider = (KlibLibraryProvider)element$iv;
            boolean bl = false;
            this.loadLibrariesSuggestedByProvider(libraryProvider);
        }
        ArrayList<KotlinLibrary> loadedLibrariesStdlibFirst = new ArrayList<KotlinLibrary>();
        Collection<LibraryStatus> collection = this.visitedCanonicalPaths.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"visitedCanonicalPaths.values");
        Iterable $this$forEach$iv2 = collection;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            LibraryStatus status = (LibraryStatus)element$iv;
            boolean bl = false;
            if (!(status instanceof LibraryStatus.SuccessfullyLoaded)) continue;
            KotlinLibrary library = ((LibraryStatus.SuccessfullyLoaded)status).getLibrary();
            if (KotlinLibraryKt.isAnyPlatformStdlib(library)) {
                loadedLibrariesStdlibFirst.add(0, library);
            } else {
                loadedLibrariesStdlibFirst.add(library);
            }
            Iterable $this$forEach$iv3 = ((LibraryStatus.SuccessfullyLoaded)status).getSuggestedByProviders();
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                KlibLibraryProvider libraryProvider = (KlibLibraryProvider)element$iv2;
                boolean bl2 = false;
                libraryProvider.postProcessLoadedLibrary(library);
            }
        }
        return new KlibLoaderResult((List<? extends KotlinLibrary>)loadedLibrariesStdlibFirst, (List<KlibLoaderResult.ProblematicLibrary>)this.problematicLibraries);
    }

    private final void loadLibrariesSuggestedByProvider(KlibLibraryProvider libraryProvider) {
        String rawPath;
        ArrayList rawPathsToProcess = new ArrayList();
        Iterable $this$forEach$iv = libraryProvider.getLibraryPaths();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            rawPath = (String)element$iv;
            boolean bl = false;
            if (!this.visitedRawPaths.add(rawPath)) continue;
            ((Collection)rawPathsToProcess).add(rawPath);
        }
        $this$forEach$iv = rawPathsToProcess;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path canonicalPath2;
            Path validPath;
            block13: {
                block12: {
                    Path path;
                    rawPath = (String)element$iv;
                    boolean bl = false;
                    if (((CharSequence)rawPath).length() == 0) {
                        path = null;
                    } else {
                        Path path2;
                        try {
                            path2 = Paths.get(rawPath, new String[0]);
                        }
                        catch (InvalidPathException _) {
                            path2 = null;
                        }
                        path = validPath = path2;
                    }
                    if (validPath == null) break block12;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(validPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block13;
                }
                ((Collection)this.problematicLibraries).add(new KlibLoaderResult.ProblematicLibrary(rawPath, KlibLoaderResult.ProblemCase.LibraryNotFound.INSTANCE));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)validPath.toRealPath(new LinkOption[0]), (String)"validPath.toRealPath()");
            LibraryStatus alreadyVisitedStatus = this.visitedCanonicalPaths.get(canonicalPath2);
            if (alreadyVisitedStatus instanceof LibraryStatus.SuccessfullyLoaded) {
                ((Collection)((LibraryStatus.SuccessfullyLoaded)alreadyVisitedStatus).getSuggestedByProviders()).add(libraryProvider);
                continue;
            }
            if (alreadyVisitedStatus instanceof LibraryStatus.FailedToLoad || alreadyVisitedStatus != null) continue;
            LibraryStatus visitedStatus = this.loadSingleLibrary(rawPath, validPath);
            ((Map)this.visitedCanonicalPaths).put(canonicalPath2, visitedStatus);
            LibraryStatus libraryStatus = visitedStatus;
            if (libraryStatus instanceof LibraryStatus.SuccessfullyLoaded) {
                ((Collection)((LibraryStatus.SuccessfullyLoaded)visitedStatus).getSuggestedByProviders()).add(libraryProvider);
                continue;
            }
            if (!(libraryStatus instanceof LibraryStatus.FailedToLoad)) continue;
            ((Collection)this.problematicLibraries).add(((LibraryStatus.FailedToLoad)visitedStatus).getProblem());
        }
    }

    private final LibraryStatus loadSingleLibrary(String rawPath, Path validPath) {
        KotlinAbiVersion libraryAbiVersion;
        KlibLoaderResult.ProblemCase.PlatformCheckMismatch platformCheckMismatch;
        Object object;
        try {
            object = new KlibImpl(new File(validPath), this.zipFileSystemAccessor, this.manifestTransformer);
        }
        catch (Exception _) {
            return new LibraryStatus.FailedToLoad(new KlibLoaderResult.ProblematicLibrary(rawPath, KlibLoaderResult.ProblemCase.InvalidLibraryFormat.INSTANCE));
        }
        KlibImpl library = object;
        object = this.platformChecker;
        if (object != null && (platformCheckMismatch = object.check(library)) != null) {
            KlibLoaderResult.ProblemCase.PlatformCheckMismatch platformCheckMismatch2 = platformCheckMismatch;
            boolean bl = false;
            return new LibraryStatus.FailedToLoad(new KlibLoaderResult.ProblematicLibrary(rawPath, platformCheckMismatch2));
        }
        if (!(this.maxPermittedAbiVersion == null || (libraryAbiVersion = library.getVersions().getAbiVersion()) != null && libraryAbiVersion.isAtMost(this.maxPermittedAbiVersion))) {
            return new LibraryStatus.FailedToLoad(new KlibLoaderResult.ProblematicLibrary(rawPath, new KlibLoaderResult.ProblemCase.IncompatibleAbiVersion(library.getVersions(), null, this.maxPermittedAbiVersion)));
        }
        return new LibraryStatus.SuccessfullyLoaded(library, null, 2, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus;", "", "FailedToLoad", "SuccessfullyLoaded", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus$FailedToLoad;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus$SuccessfullyLoaded;", "kotlin-util-klib"})
    private static interface LibraryStatus {

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus$FailedToLoad;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus;", "problem", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblematicLibrary;", "(Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblematicLibrary;)V", "getProblem", "()Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblematicLibrary;", "kotlin-util-klib"})
        public static final class FailedToLoad
        implements LibraryStatus {
            @NotNull
            private final KlibLoaderResult.ProblematicLibrary problem;

            public FailedToLoad(@NotNull KlibLoaderResult.ProblematicLibrary problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                this.problem = problem;
            }

            @NotNull
            public final KlibLoaderResult.ProblematicLibrary getProblem() {
                return this.problem;
            }
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus$SuccessfullyLoaded;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderImpl$LibraryStatus;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "suggestedByProviders", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/library/loader/KlibLibraryProvider;", "Lkotlin/collections/LinkedHashSet;", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Ljava/util/LinkedHashSet;)V", "getLibrary", "()Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getSuggestedByProviders", "()Ljava/util/LinkedHashSet;", "kotlin-util-klib"})
        public static final class SuccessfullyLoaded
        implements LibraryStatus {
            @NotNull
            private final KotlinLibrary library;
            @NotNull
            private final LinkedHashSet<KlibLibraryProvider> suggestedByProviders;

            public SuccessfullyLoaded(@NotNull KotlinLibrary library, @NotNull LinkedHashSet<KlibLibraryProvider> suggestedByProviders) {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                Intrinsics.checkNotNullParameter(suggestedByProviders, (String)"suggestedByProviders");
                this.library = library;
                this.suggestedByProviders = suggestedByProviders;
            }

            public /* synthetic */ SuccessfullyLoaded(KotlinLibrary kotlinLibrary, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    linkedHashSet = new LinkedHashSet<KlibLibraryProvider>();
                }
                this(kotlinLibrary, linkedHashSet);
            }

            @NotNull
            public final KotlinLibrary getLibrary() {
                return this.library;
            }

            @NotNull
            public final LinkedHashSet<KlibLibraryProvider> getSuggestedByProviders() {
                return this.suggestedByProviders;
            }
        }
    }
}

