/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.resolve.calls.inference.components.AbstractVariableReadinessCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemMarker;
import org.jetbrains.kotlin.resolve.calls.inference.components.LegacyVariableReadinessCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDependencyInformationProvider;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.IncorporationConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@DefaultImplementation(impl=DefaultForK1DependencyInjection.class)
@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b'\u0018\u00002\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JE\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eR\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0019JG\u0010\u001a\u001a\u0004\u0018\u00010\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00ca\u0001\f\b!\u0012\b\b\"\u0012\u0004\b\t0#\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "variableReadinessCalculator", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/AbstractVariableReadinessCalculator;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/inference/components/AbstractVariableReadinessCalculator;)V", "findFirstVariableForFixation", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "c", "allTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "postponedKtPrimitives", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "topLevelType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;)Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "typeVariableHasProperConstraint", "", "typeVariable", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;)Z", "findTypeVariableForFixation", "postponedArguments", "DefaultForK1DependencyInjection", "Default", "Context", "VariableForFixation", "resolution.common", "Lorg/jetbrains/kotlin/container/DefaultImplementation;", "impl", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$DefaultForK1DependencyInjection;"})
@SourceDebugExtension(value={"SMAP\nVariableFixationFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableFixationFinder.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,412:1\n1#2:413\n*E\n"})
public abstract class VariableFixationFinder {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final AbstractVariableReadinessCalculator<?> variableReadinessCalculator;

    public VariableFixationFinder(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull AbstractVariableReadinessCalculator<?> variableReadinessCalculator) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(variableReadinessCalculator, (String)"variableReadinessCalculator");
        this.languageVersionSettings = languageVersionSettings;
        this.variableReadinessCalculator = variableReadinessCalculator;
    }

    @Nullable
    public final VariableForFixation findFirstVariableForFixation(@NotNull Context c, @NotNull List<? extends TypeConstructorMarker> allTypeVariables, @NotNull List<? extends PostponedResolvedAtomMarker> postponedKtPrimitives, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull KotlinTypeMarker topLevelType) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter(allTypeVariables, (String)"allTypeVariables");
        Intrinsics.checkNotNullParameter(postponedKtPrimitives, (String)"postponedKtPrimitives");
        Intrinsics.checkNotNullParameter((Object)((Object)completionMode), (String)"completionMode");
        Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
        return this.findTypeVariableForFixation(c, allTypeVariables, postponedKtPrimitives, completionMode, topLevelType);
    }

    public final boolean typeVariableHasProperConstraint(@NotNull Context c, @NotNull TypeConstructorMarker typeVariable) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
        TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider(c.getNotFixedTypeVariables(), CollectionsKt.emptyList(), null, c, this.languageVersionSettings);
        return this.variableReadinessCalculator.typeVariableHasProperConstraint(c, typeVariable, dependencyProvider);
    }

    private final VariableForFixation findTypeVariableForFixation(Context c, List<? extends TypeConstructorMarker> allTypeVariables, List<? extends PostponedResolvedAtomMarker> postponedArguments, ConstraintSystemCompletionMode completionMode, KotlinTypeMarker topLevelType) {
        KotlinTypeMarker kotlinTypeMarker;
        if (allTypeVariables.isEmpty()) {
            return null;
        }
        KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker = topLevelType;
        List<? extends PostponedResolvedAtomMarker> list = postponedArguments;
        Map<TypeConstructorMarker, VariableWithConstraints> map = c.getNotFixedTypeVariables();
        boolean bl = false;
        boolean bl2 = completionMode == ConstraintSystemCompletionMode.PARTIAL;
        LanguageVersionSettings languageVersionSettings = this.languageVersionSettings;
        Context context = c;
        KotlinTypeMarker kotlinTypeMarker3 = bl2 ? kotlinTypeMarker : null;
        List<? extends PostponedResolvedAtomMarker> list2 = list;
        Map<TypeConstructorMarker, VariableWithConstraints> map2 = map;
        TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider(map2, list2, kotlinTypeMarker3, context, languageVersionSettings);
        TypeConstructorMarker typeConstructorMarker = this.variableReadinessCalculator.chooseBestTypeVariableCandidateWithLogging(c, allTypeVariables, dependencyProvider);
        if (typeConstructorMarker == null) {
            return null;
        }
        TypeConstructorMarker candidate2 = typeConstructorMarker;
        return this.variableReadinessCalculator.prepareVariableForFixation(c, candidate2, dependencyProvider);
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH&R\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010RD\u0010\u0011\u001a4\u00120\u0012.\u0012\u0004\u0012\u00020\u0014\u0012$\u0012\"\u0012\u001a\u0012\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u00130\u0015j\u0002`\u00170\rj\u0002`\u00180\u00130\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\u001e\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006(\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemMarker;", "notFixedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getNotFixedTypeVariables", "()Ljava/util/Map;", "fixedTypeVariables", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "getFixedTypeVariables", "postponedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "getPostponedTypeVariables", "()Ljava/util/List;", "constraintsFromAllForkPoints", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/IncorporationConstraintPosition;", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ForkPointBranchDescription;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ForkPointData;", "getConstraintsFromAllForkPoints", "allTypeVariables", "getAllTypeVariables", "outerSystemVariablesPrefixSize", "", "getOuterSystemVariablesPrefixSize", "()I", "outerTypeVariables", "getOuterTypeVariables", "()Ljava/util/Set;", "typeVariablesThatAreCountedAsProperTypes", "getTypeVariablesThatAreCountedAsProperTypes", "isReified", "", "variable", "resolution.common"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext,
    ConstraintSystemMarker {
        @NotNull
        public Map<TypeConstructorMarker, VariableWithConstraints> getNotFixedTypeVariables();

        @NotNull
        public Map<TypeConstructorMarker, KotlinTypeMarker> getFixedTypeVariables();

        @NotNull
        public List<TypeVariableMarker> getPostponedTypeVariables();

        @NotNull
        public List<Pair<IncorporationConstraintPosition, List<Set<Pair<TypeVariableMarker, Constraint>>>>> getConstraintsFromAllForkPoints();

        @NotNull
        public Map<TypeConstructorMarker, TypeVariableMarker> getAllTypeVariables();

        public int getOuterSystemVariablesPrefixSize();

        @Nullable
        default public Set<TypeConstructorMarker> getOuterTypeVariables() {
            return this.getOuterSystemVariablesPrefixSize() > 0 ? CollectionsKt.toSet((Iterable)CollectionsKt.take((Iterable)this.getAllTypeVariables().keySet(), (int)this.getOuterSystemVariablesPrefixSize())) : null;
        }

        @Nullable
        public Set<TypeConstructorMarker> getTypeVariablesThatAreCountedAsProperTypes();

        public boolean isReified(@NotNull TypeVariableMarker var1);
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Default;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "variableReadinessCalculator", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/AbstractVariableReadinessCalculator;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/inference/components/AbstractVariableReadinessCalculator;)V", "resolution.common"})
    public static final class Default
    extends VariableFixationFinder {
        public Default(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull AbstractVariableReadinessCalculator<?> variableReadinessCalculator) {
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter(variableReadinessCalculator, (String)"variableReadinessCalculator");
            super(languageVersionSettings, variableReadinessCalculator);
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$DefaultForK1DependencyInjection;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "legacyVariableReadinessCalculator", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/LegacyVariableReadinessCalculator;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/inference/components/LegacyVariableReadinessCalculator;)V", "resolution.common"})
    public static final class DefaultForK1DependencyInjection
    extends VariableFixationFinder {
        public DefaultForK1DependencyInjection(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull LegacyVariableReadinessCalculator legacyVariableReadinessCalculator) {
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)legacyVariableReadinessCalculator, (String)"legacyVariableReadinessCalculator");
            super(languageVersionSettings, legacyVariableReadinessCalculator);
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "", "variable", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "hasProperConstraint", "", "hasDependencyOnOuterTypeVariable", "<init>", "(Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;ZZ)V", "getVariable", "()Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "isReady", "()Z", "resolution.common"})
    public static final class VariableForFixation {
        @NotNull
        private final TypeConstructorMarker variable;
        private final boolean hasProperConstraint;
        private final boolean hasDependencyOnOuterTypeVariable;

        public VariableForFixation(@NotNull TypeConstructorMarker variable, boolean hasProperConstraint, boolean hasDependencyOnOuterTypeVariable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.variable = variable;
            this.hasProperConstraint = hasProperConstraint;
            this.hasDependencyOnOuterTypeVariable = hasDependencyOnOuterTypeVariable;
        }

        public /* synthetic */ VariableForFixation(TypeConstructorMarker typeConstructorMarker, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(typeConstructorMarker, bl, bl2);
        }

        @NotNull
        public final TypeConstructorMarker getVariable() {
            return this.variable;
        }

        public final boolean isReady() {
            return this.hasProperConstraint && !this.hasDependencyOnOuterTypeVariable;
        }
    }
}

