/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.workingTrees;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import git4idea.GitReference;
import git4idea.GitStandardLocalBranch;
import git4idea.GitWorkingTree;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJE\u0010\t\u001a\u0004\u0018\u00010\n\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\u00102\u0006\u0010\u000f\u001a\u00020\b2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00130\u0012\u00a2\u0006\u0002\u0010\u0014R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/git/workingTrees/GitWorkingTreesUtil;", "", "<init>", "()V", "TOOLWINDOW_TAB_ID", "", "Lorg/jetbrains/annotations/NonNls;", "isWorkingTreesFeatureEnabled", "", "getWorkingTreeWithRef", "Lgit4idea/GitWorkingTree;", "reference", "Lgit4idea/GitReference;", "repository", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "skipCurrentWorkingTree", "T", "workingTrees", "Lkotlin/Function1;", "", "(Lgit4idea/GitReference;Ljava/lang/Object;ZLkotlin/jvm/functions/Function1;)Lgit4idea/GitWorkingTree;", "intellij.vcs.git.shared"})
@ApiStatus.Internal
public final class GitWorkingTreesUtil {
    @NotNull
    public static final GitWorkingTreesUtil INSTANCE = new GitWorkingTreesUtil();
    @NotNull
    public static final String TOOLWINDOW_TAB_ID = "Working Trees";

    private GitWorkingTreesUtil() {
    }

    public final boolean isWorkingTreesFeatureEnabled() {
        return Registry.Companion.is("git.enable.working.trees.feature", false);
    }

    @Nullable
    public final GitWorkingTree getWorkingTreeWithRef(@NotNull GitReference reference, @NotNull GitRepositoryModel repository2, boolean skipCurrentWorkingTree) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        return this.getWorkingTreeWithRef(reference, repository2, skipCurrentWorkingTree, arg_0 -> GitWorkingTreesUtil.getWorkingTreeWithRef$lambda$0(repository2, arg_0));
    }

    @Nullable
    public final <T> GitWorkingTree getWorkingTreeWithRef(@NotNull GitReference reference, T repository2, boolean skipCurrentWorkingTree, @NotNull Function1<? super T, ? extends Collection<GitWorkingTree>> workingTrees) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter(workingTrees, (String)"workingTrees");
            if (!this.isWorkingTreesFeatureEnabled() || !(reference instanceof GitStandardLocalBranch)) {
                return null;
            }
            Collection workingTrees2 = (Collection)workingTrees.invoke(repository2);
            Iterable iterable = workingTrees2;
            for (Object t : iterable) {
                GitWorkingTree it = (GitWorkingTree)t;
                boolean bl = false;
                if (!((!skipCurrentWorkingTree || !it.isCurrent()) && Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)reference))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Collection getWorkingTreeWithRef$lambda$0(GitRepositoryModel $repository, GitRepositoryModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $repository.getState().getWorkingTrees();
    }
}

