/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitBranch;
import git4idea.GitOperationsCollector;
import git4idea.GitUtil;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import git4idea.merge.GitMergeOption;
import git4idea.repo.GitRepository;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitMerge
extends GitMergeAction<GitMergeOption> {
    GitMerge() {
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.message("merge.action.name", new Object[0]);
        if (string == null) {
            GitMerge.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected GitMergeAction.DialogState<GitMergeOption> displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        GitMergeDialog dialog2;
        if (project == null) {
            GitMerge.$$$reportNull$$$0(1);
        }
        if (gitRoots == null) {
            GitMerge.$$$reportNull$$$0(2);
        }
        if (defaultRoot == null) {
            GitMerge.$$$reportNull$$$0(3);
        }
        if (!(dialog2 = new GitMergeDialog(project, defaultRoot, gitRoots)).showAndGet()) {
            return null;
        }
        GitRepository repository2 = dialog2.getSelectedRepository();
        GitOperationsCollector.logMergeFromDialog(project, repository2, dialog2.getSelectedBranch(), dialog2.getSelectedOptions());
        return new GitMergeAction.DialogState<GitMergeOption>(dialog2.getSelectedRoot(), GitBundle.message("merging.title", dialog2.getSelectedRoot().getPath()), this.getHandlerProvider(project, dialog2), dialog2.getSelectedBranch(), dialog2.shouldCommitAfterMerge(), dialog2.getSelectedOptions());
    }

    @Override
    protected String getNotificationErrorDisplayId() {
        return "git.merge.failed";
    }

    @NotNull
    Supplier<GitLineHandler> getHandlerProvider(Project project, GitMergeDialog dialog2) {
        VirtualFile root = dialog2.getSelectedRoot();
        Set<GitMergeOption> selectedOptions = dialog2.getSelectedOptions();
        String commitMsg = dialog2.getCommitMessage().trim();
        GitBranch selectedBranch = dialog2.getSelectedBranch();
        Supplier<GitLineHandler> supplier = () -> {
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.MERGE);
            for (GitMergeOption option : selectedOptions) {
                if (option == GitMergeOption.COMMIT_MESSAGE) {
                    if (commitMsg.isEmpty()) continue;
                    h.addParameters(option.getOption(), commitMsg);
                    continue;
                }
                h.addParameters(option.getOption());
            }
            h.addParameters(selectedBranch.getName());
            return h;
        };
        if (supplier == null) {
            GitMerge.$$$reportNull$$$0(4);
        }
        return supplier;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitMerge.$$$reportNull$$$0(5);
        }
        super.update(e);
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project != null && !GitUtil.getRepositoriesInStates(project, Repository.State.MERGING).isEmpty()) {
            presentation.setEnabledAndVisible(false);
        } else if (project != null && GitUtil.getRepositoriesInStates(project, Repository.State.NORMAL, Repository.State.DETACHED).isEmpty()) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
        } else {
            presentation.setEnabledAndVisible(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitMerge";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitMerge";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "displayDialog";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

