/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.addCommit;

import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.progress.ProgressReporter;
import com.intellij.platform.util.progress.StepsKt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.DialogManager;
import git4idea.GitRemoteBranch;
import git4idea.actions.addCommit.GitAddCommitToRemoteBranchOperationKt;
import git4idea.commands.Git;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSpec;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.inMemory.GitObjectRepository;
import git4idea.inMemory.GitObjectRepositoryExtensionsKt;
import git4idea.inMemory.MergeConflictException;
import git4idea.inMemory.objects.GitObject;
import git4idea.inMemory.objects.Oid;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTarget;
import git4idea.push.GitPushTargetType;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/actions/addCommit/GitAddCommitToRemoteBranchOperation;", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "commits", "", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "remoteBranch", "Lgit4idea/GitRemoteBranch;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepository;Ljava/util/List;Lgit4idea/GitRemoteBranch;Lkotlinx/coroutines/CoroutineScope;)V", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchRemoteBranch", "cherryPickCommitsInMemory", "Lgit4idea/inMemory/objects/Oid;", "showPushDialog", "newOid", "handleMergeConflict", "e", "Lgit4idea/inMemory/MergeConflictException;", "handleError", "Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
public final class GitAddCommitToRemoteBranchOperation {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final List<VcsFullCommitDetails> commits;
    @NotNull
    private final GitRemoteBranch remoteBranch;
    @NotNull
    private final CoroutineScope cs;

    public GitAddCommitToRemoteBranchOperation(@NotNull Project project, @NotNull GitRepository repository2, @NotNull List<? extends VcsFullCommitDetails> commits, @NotNull GitRemoteBranch remoteBranch, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)remoteBranch, (String)"remoteBranch");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.repository = repository2;
        this.commits = commits;
        this.remoteBranch = remoteBranch;
        this.cs = cs;
    }

    @Nullable
    public final Object execute(@NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{Boxing.boxInt((int)this.commits.size()), this.remoteBranch.getNameForRemoteOperations()};
        String string = GitBundle.message("progress.title.adding.commits.to.remote.branch", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object object = TasksKt.withBackgroundProgress((Project)this.project, (String)string, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, null){
            int label;
            final /* synthetic */ GitAddCommitToRemoteBranchOperation this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = StepsKt.reportProgressScope((int)2, (Function3)((Function3)new Function3<CoroutineScope, ProgressReporter, Continuation<? super Object>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ GitAddCommitToRemoteBranchOperation this$0;
                            {
                                this.this$0 = $receiver;
                                super(3, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (ProgressReporter)this.L$0;
                                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = reporter;
                                        this.label = 1;
                                        v0 = reporter.indeterminateStep(GitBundle.message("progress.text.fetching.remote.branch", new Object[0]), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ GitAddCommitToRemoteBranchOperation this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        GitAddCommitToRemoteBranchOperation.access$fetchRemoteBranch(this.this$0);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, (Continuation)this);
                                        ** if (v0 != var5_3) goto lbl13
lbl12:
                                        // 1 sources

                                        return var5_3;
lbl13:
                                        // 1 sources

                                        ** GOTO lbl19
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl19:
                                        // 2 sources

                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)reporter);
                                        this.label = 2;
                                        v1 = reporter.itemStep(GitBundle.message("progress.text.cherry.picking.commits", new Object[0]), (Function2)new Function2<CoroutineScope, Continuation<? super Oid>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ GitAddCommitToRemoteBranchOperation this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        return GitAddCommitToRemoteBranchOperation.access$cherryPickCommitsInMemory(this.this$0);
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Oid> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, (Continuation)this);
                                        ** if (v1 != var5_3) goto lbl24
lbl23:
                                        // 1 sources

                                        return var5_3;
lbl24:
                                        // 1 sources

                                        ** GOTO lbl30
                                    }
                                    case 2: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl30:
                                            // 2 sources

                                            newRemoteBranchOid = (Oid)v1;
                                            var3_4 = BuildersKt.launch$default((CoroutineScope)GitAddCommitToRemoteBranchOperation.access$getCs$p(this.this$0), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, newRemoteBranchOid, null){
                                                int label;
                                                final /* synthetic */ GitAddCommitToRemoteBranchOperation this$0;
                                                final /* synthetic */ Oid $newRemoteBranchOid;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$newRemoteBranchOid = $newRemoteBranchOid;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            GitAddCommitToRemoteBranchOperation.access$showPushDialog(this.this$0, this.$newRemoteBranchOid);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)2, null);
                                        }
                                        catch (MergeConflictException e) {
                                            GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().info("Merge conflict while adding commits to remote branch", (Throwable)e);
                                            GitAddCommitToRemoteBranchOperation.access$handleMergeConflict(this.this$0, e);
                                            var3_4 = Unit.INSTANCE;
                                        }
                                        catch (VcsException e) {
                                            GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().warn("Failed to add commits to remote branch", (Throwable)e);
                                            GitAddCommitToRemoteBranchOperation.access$handleError(this.this$0, e);
                                            var3_4 = Unit.INSTANCE;
                                        }
                                        catch (Exception e) {
                                            LoggerKt.rethrowControlFlowException((Throwable)e);
                                            GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().warn("Unexpected error while adding commits to remote branch", (Throwable)e);
                                            GitAddCommitToRemoteBranchOperation.access$handleError(this.this$0, new VcsException((Throwable)e));
                                            var3_4 = Unit.INSTANCE;
                                        }
                                        return var3_4;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(CoroutineScope p1, ProgressReporter p2, Continuation<Object> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void fetchRemoteBranch() {
        GitRemote remote = this.remoteBranch.getRemote();
        String branchName = this.remoteBranch.getNameForRemoteOperations();
        GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().info("Fetching remote branch " + remote + "/" + branchName);
        GitFetchSpec fetchSpec = new GitFetchSpec(this.repository, remote, "refs/heads/" + branchName + ":refs/remotes/" + remote.getName() + "/" + branchName, false, false, null, 32, null);
        GitFetchResult gitFetchResult = GitFetchSupport.fetchSupport(this.project).fetch(CollectionsKt.listOf((Object)fetchSpec));
        Intrinsics.checkNotNullExpressionValue((Object)gitFetchResult, (String)"fetch(...)");
        GitFetchResult result2 = gitFetchResult;
        result2.throwExceptionIfFailed();
        this.repository.update();
        GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().info("Successfully fetched remote branch " + remote + "/" + branchName);
    }

    private final Oid cherryPickCommitsInMemory() {
        GitObjectRepository objectRepo = new GitObjectRepository(this.repository);
        GitRemote remote = this.remoteBranch.getRemote();
        String branchName = this.remoteBranch.getNameForRemoteOperations();
        String remoteBranchRef = "refs/remotes/" + remote.getName() + "/" + branchName;
        Hash hash = Git.getInstance().resolveReference(this.repository, remoteBranchRef);
        if (hash == null) {
            Object[] objectArray = new Object[]{remoteBranchRef};
            throw new VcsException(GitBundle.message("error.cannot.resolve.reference", objectArray));
        }
        Hash remoteTipHash = hash;
        GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().info("Remote branch tip: " + remoteTipHash);
        String string = remoteTipHash.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        GitObject.Commit currentBase = objectRepo.findCommit(Oid.Companion.fromHex(string));
        for (VcsFullCommitDetails commitDetails : this.commits) {
            String string2 = ((Hash)commitDetails.getId()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            Oid commitOid = Oid.Companion.fromHex(string2);
            GitObject.Commit commit = objectRepo.findCommit(commitOid);
            GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().info("Cherry-picking commit " + commit.getOid() + " onto " + currentBase.getOid());
            Oid newCommitOid = GitObjectRepositoryExtensionsKt.rebaseCommit(objectRepo, commit, currentBase);
            currentBase = objectRepo.findCommit(newCommitOid);
            GitAddCommitToRemoteBranchOperationKt.access$getLOG$p().info("Created new commit: " + currentBase.getOid());
        }
        return currentBase.getOid();
    }

    private final void showPushDialog(Oid newOid) {
        GitPushSource gitPushSource = GitPushSource.createDetached(newOid.hex());
        Intrinsics.checkNotNullExpressionValue((Object)gitPushSource, (String)"createDetached(...)");
        GitPushSource pushSource = gitPushSource;
        VcsPushDialog dialog2 = new VcsPushDialog(this.project, (Collection)CollectionsKt.listOf((Object)this.repository), CollectionsKt.listOf((Object)this.repository), (Repository)this.repository, (PushSource)pushSource, (PushTarget)new GitPushTarget(this.remoteBranch, false, GitPushTargetType.CUSTOM));
        DialogManager.show((DialogWrapper)dialog2);
    }

    private final void handleMergeConflict(MergeConflictException e) {
        Object[] objectArray = new Object[]{this.remoteBranch.getNameForLocalOperations(), e.getDescription()};
        VcsNotifier.getInstance((Project)this.project).notifyError("git.add.commit.to.remote.branch.conflict", GitBundle.message("notification.title.add.to.remote.branch.conflict", new Object[0]), GitBundle.message("notification.content.add.to.remote.branch.conflict", objectArray));
    }

    private final void handleError(VcsException e) {
        VcsNotifier.getInstance((Project)this.project).notifyError("git.add.commit.to.remote.branch.failed", GitBundle.message("notification.title.add.to.remote.branch.failed", new Object[0]), e.getMessage());
    }

    public static final /* synthetic */ void access$fetchRemoteBranch(GitAddCommitToRemoteBranchOperation $this) {
        $this.fetchRemoteBranch();
    }

    public static final /* synthetic */ Oid access$cherryPickCommitsInMemory(GitAddCommitToRemoteBranchOperation $this) {
        return $this.cherryPickCommitsInMemory();
    }

    public static final /* synthetic */ CoroutineScope access$getCs$p(GitAddCommitToRemoteBranchOperation $this) {
        return $this.cs;
    }

    public static final /* synthetic */ void access$showPushDialog(GitAddCommitToRemoteBranchOperation $this, Oid newOid) {
        $this.showPushDialog(newOid);
    }

    public static final /* synthetic */ void access$handleMergeConflict(GitAddCommitToRemoteBranchOperation $this, MergeConflictException e) {
        $this.handleMergeConflict(e);
    }

    public static final /* synthetic */ void access$handleError(GitAddCommitToRemoteBranchOperation $this, VcsException e) {
        $this.handleError(e);
    }
}

