/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.ref;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.actions.ref.GitCheckoutActionKt;
import git4idea.actions.ref.GitSingleRefAction;
import git4idea.branch.GitBrancher;
import git4idea.i18n.GitBundle;
import git4idea.remote.hosting.GitRemoteBranchesUtil;
import git4idea.repo.GitRepository;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lgit4idea/actions/ref/GitCheckoutAction;", "Lgit4idea/actions/ref/GitSingleRefAction;", "Lgit4idea/GitReference;", "<init>", "()V", "isEnabledForRef", "", "ref", "repositories", "", "Lgit4idea/repo/GitRepository;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "reference", "intellij.vcs.git"})
public final class GitCheckoutAction
extends GitSingleRefAction<GitReference> {
    public GitCheckoutAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.checkout", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(supplier);
    }

    @Override
    protected boolean isEnabledForRef(@NotNull GitReference ref, @NotNull List<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        if (!(ref instanceof GitBranch) && !(ref instanceof GitTag)) {
            return false;
        }
        if (GitSingleRefAction.Companion.isCurrentRefInAnyRepoOrWorkingTree$intellij_vcs_git(ref, repositories, true)) {
            return false;
        }
        return GitSingleRefAction.Companion.isCurrentRefInAnyRepo$intellij_vcs_git(ref, repositories) ? GitCheckoutActionKt.access$diverged(repositories) : true;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitReference reference) {
        String refToCheckout;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        String string = refToCheckout = reference instanceof GitBranch ? reference.getName() : reference.getFullName();
        if (reference instanceof GitRemoteBranch) {
            GitRemoteBranchesUtil.checkoutRemoteBranch(project, repositories, refToCheckout);
        } else {
            GitBrancher.getInstance(project).checkout(refToCheckout, false, repositories, null);
        }
    }
}

