/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.workingTree;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.git.actions.GitSingleRefActions;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.actions.branch.GitBranchActionsDataKeys;
import git4idea.actions.workingTree.GitCreateWorkingTreeService;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.workingTrees.GitWorkingTreesNewBadgeUtil;
import git4idea.workingTrees.GitWorkingTreesService;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lgit4idea/actions/workingTree/GitCreateWorkingTreeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "computeIcon", "Ljavax/swing/Icon;", "actionPerformed", "getBranchFromContext", "Lgit4idea/GitBranch;", "repository", "Lgit4idea/repo/GitRepository;", "explicitRefFromCtx", "Lgit4idea/GitReference;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCreateWorkingTreeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCreateWorkingTreeAction.kt\ngit4idea/actions/workingTree/GitCreateWorkingTreeAction\n+ 2 Uitil.kt\nfleet/util/UitilKt\n*L\n1#1,81:1\n57#2:82\n*S KotlinDebug\n*F\n+ 1 GitCreateWorkingTreeAction.kt\ngit4idea/actions/workingTree/GitCreateWorkingTreeAction\n*L\n79#1:82\n*E\n"})
public final class GitCreateWorkingTreeAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        GitRepository singleRepository = GitWorkingTreesService.Companion.getRepoForWorkingTreesSupport(project);
        if (singleRepository == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitReference explicitRefFromCtx = (GitReference)e.getData(GitSingleRefActions.SELECTED_REF_DATA_KEY);
        if (explicitRefFromCtx != null && !(explicitRefFromCtx instanceof GitBranch)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        GitWorkingTreesNewBadgeUtil.INSTANCE.addLabelNewIfNeeded(presentation);
        e.getPresentation().setIcon(this.computeIcon(e));
        GitBranch localBranchFromContext = this.getBranchFromContext(e, singleRepository, explicitRefFromCtx);
        if (localBranchFromContext == null) {
            e.getPresentation().setText(GitBundle.message("action.Git.CreateNewWorkingTree.text", new Object[0]));
            e.getPresentation().setDescription(GitBundle.message("action.Git.CreateNewWorkingTree.description", new Object[0]));
        } else {
            String branchName = localBranchFromContext.getName();
            Object[] objectArray = new Object[]{branchName};
            e.getPresentation().setText(GitBundle.message("action.Git.CreateNewWorkingTree.from.branch.text", objectArray));
            objectArray = new Object[]{branchName};
            e.getPresentation().setDescription(GitBundle.message("action.Git.CreateNewWorkingTree.from.branch.description", objectArray));
        }
    }

    private final Icon computeIcon(AnActionEvent e) {
        return Intrinsics.areEqual((Object)e.getPlace(), (Object)"GitWorkingTreeToolWindowTabToolbar") ? AllIcons.General.Add : null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GitWorkingTreesNewBadgeUtil.INSTANCE.workingTreesFeatureWasUsed();
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        GitRepository gitRepository = GitWorkingTreesService.Companion.getRepoForWorkingTreesSupport(project2);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository2 = gitRepository;
        GitBranch branchFromContext = GitCreateWorkingTreeAction.getBranchFromContext$default(this, e, repository2, null, 4, null);
        GitCreateWorkingTreeService gitCreateWorkingTreeService = GitCreateWorkingTreeService.Companion.getInstance();
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        gitCreateWorkingTreeService.collectDataAndCreateWorkingTree$intellij_vcs_git(repository2, branchFromContext, string);
    }

    private final GitBranch getBranchFromContext(AnActionEvent e, GitRepository repository2, GitReference explicitRefFromCtx) {
        GitReference ref;
        GitReference gitReference = explicitRefFromCtx;
        if (gitReference == null) {
            if (Intrinsics.areEqual((Object)e.getData(GitBranchActionsDataKeys.USE_CURRENT_BRANCH), (Object)true)) {
                GitRepository gitRepository = repository2;
                gitReference = gitRepository != null ? gitRepository.getCurrentBranch() : null;
            } else {
                gitReference = null;
            }
        }
        GitReference $this$safeAs$iv = ref = gitReference;
        boolean $i$f$safeAs = false;
        GitReference gitReference2 = $this$safeAs$iv;
        if (!(gitReference2 instanceof GitBranch)) {
            gitReference2 = null;
        }
        return (GitBranch)gitReference2;
    }

    static /* synthetic */ GitBranch getBranchFromContext$default(GitCreateWorkingTreeAction gitCreateWorkingTreeAction, AnActionEvent anActionEvent, GitRepository gitRepository, GitReference gitReference, int n, Object object) {
        if ((n & 4) != 0) {
            gitReference = (GitReference)anActionEvent.getData(GitSingleRefActions.SELECTED_REF_DATA_KEY);
        }
        return gitCreateWorkingTreeAction.getBranchFromContext(anActionEvent, gitRepository, gitReference);
    }
}

