/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.PostCommitChangeConverter;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/checkin/GitPostCommitChangeConverter;", "Lcom/intellij/openapi/vcs/checkin/PostCommitChangeConverter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "collectChangesAfterCommit", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "loadChangesFromCommit", "repo", "Lgit4idea/repo/GitRepository;", "hash", "Lcom/intellij/vcs/log/Hash;", "areConsequentCommits", "", "commitContexts", "isFailureUpToDate", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPostCommitChangeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n1586#2:94\n1661#2,3:95\n1786#2,3:98\n1807#2,3:101\n1807#2,3:105\n13#3:104\n*S KotlinDebug\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter\n*L\n44#1:94\n44#1:95,3\n45#1:98,3\n46#1:101,3\n66#1:105,3\n55#1:104\n*E\n"})
public final class GitPostCommitChangeConverter
implements PostCommitChangeConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<Map<GitRepository, Hash>> GIT_POST_COMMIT_HASHES_KEY;
    @NotNull
    private static final ReadWriteProperty<? super CommitContext, Map<GitRepository, Hash>> postCommitHashes$delegate;

    public GitPostCommitChangeConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public List<Change> collectChangesAfterCommit(@NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        Map map2 = GitPostCommitChangeConverter.Companion.getPostCommitHashes(commitContext);
        if (map2 == null) {
            return CollectionsKt.emptyList();
        }
        Map hashes = map2;
        List result2 = new ArrayList();
        for (Map.Entry entry : hashes.entrySet()) {
            GitRepository repo = (GitRepository)entry.getKey();
            Hash hash = (Hash)entry.getValue();
            CollectionsKt.addAll((Collection)result2, (Iterable)this.loadChangesFromCommit(repo, hash));
        }
        return result2;
    }

    private final List<Change> loadChangesFromCommit(GitRepository repo, Hash hash) {
        CollectConsumer consumer = new CollectConsumer();
        GitCommitRequirements commitRequirements = new GitCommitRequirements(false, null, GitCommitRequirements.DiffInMergeCommits.FIRST_PARENT, 3, null);
        GitLogUtil.readFullDetailsForHashes(this.project, repo.getRoot(), CollectionsKt.listOf((Object)hash.asString()), commitRequirements, (Consumer<? super GitCommit>)((Consumer)consumer));
        Collection collection = consumer.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResult(...)");
        GitCommit gitCommit = (GitCommit)((Object)CollectionsKt.firstOrNull((Iterable)collection));
        if (gitCommit == null) {
            Object[] objectArray = new Object[]{repo.getRoot().getName(), hash.asString()};
            throw new VcsException(GitBundle.message("post.commit.check.load.changes.error", objectArray));
        }
        GitCommit commit = gitCommit;
        Collection collection2 = commit.getChanges(0);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getChanges(...)");
        return CollectionsKt.toList((Iterable)collection2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean areConsequentCommits(@NotNull List<CommitContext> commitContexts) {
        boolean bl;
        List commitHashes;
        block12: {
            boolean bl2;
            block11: {
                Iterator $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(commitContexts, (String)"commitContexts");
                Iterable $this$map$iv = commitContexts;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator.next();
                    CommitContext commitContext = (CommitContext)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(GitPostCommitChangeConverter.Companion.getPostCommitHashes((CommitContext)it));
                }
                commitHashes = (List)destination$iv$iv;
                Iterable $this$all$iv = commitHashes;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Map it = (Map)element$iv;
                        boolean bl4 = false;
                        if (it == null) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return true;
            }
            Iterable $this$any$iv = commitHashes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Map it = (Map)element$iv;
                    boolean bl5 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Map repoMap = new LinkedHashMap();
        Iterator iterator = CollectionsKt.reversed((Iterable)commitHashes).iterator();
        while (iterator.hasNext()) {
            Map hashes;
            Map map2 = hashes = (Map)iterator.next();
            Intrinsics.checkNotNull((Object)map2);
            for (Map.Entry entry : map2.entrySet()) {
                Hash parentHash;
                Hash hash;
                GitRepository repo = (GitRepository)entry.getKey();
                Hash oldHash = repoMap.put(repo, hash = (Hash)entry.getValue());
                if (oldHash == null || Intrinsics.areEqual((Object)(parentHash = Git.getInstance().resolveReference(repo, oldHash + "^1")), (Object)hash)) continue;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitPostCommitChangeConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Non-consequent commits: " + oldHash + " - " + hash);
                return false;
            }
        }
        return true;
    }

    public boolean isFailureUpToDate(@NotNull List<CommitContext> commitContexts) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(commitContexts, (String)"commitContexts");
            Object object = (CommitContext)CollectionsKt.lastOrNull(commitContexts);
            if (object == null || (object = GitPostCommitChangeConverter.Companion.getPostCommitHashes((CommitContext)object)) == null) {
                return true;
            }
            Object lastCommit = object;
            Iterable $this$any$iv = lastCommit.entrySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    GitRepository repo = (GitRepository)entry.getKey();
                    Hash hash = (Hash)entry.getValue();
                    if (!Intrinsics.areEqual((Object)repo.getCurrentRevision(), (Object)hash.asString())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Map<GitRepository, Hash> getRecordedPostCommitHashes(@NotNull CommitContext commitContext) {
        return Companion.getRecordedPostCommitHashes(commitContext);
    }

    @JvmStatic
    public static final void markRepositoryCommit(@NotNull CommitContext commitContext, @NotNull GitRepository repository2) {
        Companion.markRepositoryCommit(commitContext, repository2);
    }

    static {
        Key key = Key.create((String)"Git.Post.Commit.Hash");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        GIT_POST_COMMIT_HASHES_KEY = key;
        postCommitHashes$delegate = AbstractCommitWorkflowKt.commitExecutorProperty(GIT_POST_COMMIT_HASHES_KEY, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007H\u0007R9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RK\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006*\u00020\r2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00068B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lgit4idea/checkin/GitPostCommitChangeConverter$Companion;", "", "<init>", "()V", "GIT_POST_COMMIT_HASHES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/Hash;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "postCommitHashes", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "getPostCommitHashes", "(Lcom/intellij/openapi/vcs/changes/CommitContext;)Ljava/util/Map;", "setPostCommitHashes", "(Lcom/intellij/openapi/vcs/changes/CommitContext;Ljava/util/Map;)V", "postCommitHashes$delegate", "Lkotlin/properties/ReadWriteProperty;", "getRecordedPostCommitHashes", "", "commitContext", "markRepositoryCommit", "", "repository", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitPostCommitChangeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n13#2:94\n*S KotlinDebug\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter$Companion\n*L\n89#1:94\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Map<GitRepository, Hash> getPostCommitHashes(CommitContext $this$postCommitHashes) {
            return (Map)postCommitHashes$delegate.getValue((Object)$this$postCommitHashes, $$delegatedProperties[0]);
        }

        private final void setPostCommitHashes(CommitContext $this$postCommitHashes, Map<GitRepository, Hash> map2) {
            postCommitHashes$delegate.setValue((Object)$this$postCommitHashes, $$delegatedProperties[0], map2);
        }

        @JvmStatic
        @Nullable
        public final Map<GitRepository, Hash> getRecordedPostCommitHashes(@NotNull CommitContext commitContext) {
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            return this.getPostCommitHashes(commitContext);
        }

        @JvmStatic
        public final void markRepositoryCommit(@NotNull CommitContext commitContext, @NotNull GitRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Map hashes = this.getPostCommitHashes(commitContext);
            if (hashes == null) {
                hashes = new LinkedHashMap();
                this.setPostCommitHashes(commitContext, hashes);
            }
            Hash hash = GitUtil.getHead(repository2);
            if (hash == null) {
                return;
            }
            Hash head = hash;
            Hash oldHead = hashes.put(repository2, head);
            if (oldHead != null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitPostCommitChangeConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Multiple commits found for " + repository2 + ": " + head + " - " + oldHead);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "postCommitHashes", "getPostCommitHashes(Lcom/intellij/openapi/vcs/changes/CommitContext;)Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

