/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.log.GitCommitEditingOperation;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.changes.GitDropSelectedChangesOperation;
import git4idea.rebase.log.squash.GitSquashOperation;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.GitPreservingProcess;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/rebase/log/changes/GitDropSelectedChangesOperation;", "Lgit4idea/rebase/log/GitCommitEditingOperation;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/util/List;)V", "initialHeadPosition", "", "execute", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropSelectedChanges", "canDropViaAmend", "", "dropViaAmend", "dropViaRebase", "createFixupCommit", "restoreChanges", "notifyGitCommandFailed", "", "result", "Lgit4idea/commands/GitCommandResult;", "notifyOperationFailed", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDropSelectedChangesOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDropSelectedChangesOperation.kt\ngit4idea/rebase/log/changes/GitDropSelectedChangesOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1586#2:160\n1661#2,3:161\n*S KotlinDebug\n*F\n+ 1 GitDropSelectedChangesOperation.kt\ngit4idea/rebase/log/changes/GitDropSelectedChangesOperation\n*L\n124#1:160\n124#1:161,3\n*E\n"})
public final class GitDropSelectedChangesOperation
extends GitCommitEditingOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsCommitMetadata commit;
    @NotNull
    private final List<Change> changes;
    private String initialHeadPosition;
    @NonNls
    @NotNull
    private static final String FIXUP_COMMIT_MESSAGE_SUFFIX = "\n\nCreated by IntelliJ Git plugin for drop selected changes operation";

    public GitDropSelectedChangesOperation(@NotNull GitRepository repository2, @NotNull VcsCommitMetadata commit, @NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        super(repository2);
        this.commit = commit;
        this.changes = changes;
    }

    @Nullable
    public final Object execute(@NotNull Continuation<? super GitCommitEditingOperationResult> $completion) {
        this.getRepository().update();
        String string = this.getRepository().getCurrentRevision();
        Intrinsics.checkNotNull((Object)string);
        this.initialHeadPosition = string;
        VcsLogManager logManager = VcsProjectLog.Companion.getInstance(this.getProject()).getLogManager();
        if (this.canDropViaAmend() || logManager == null) {
            return this.dropSelectedChanges($completion);
        }
        return logManager.runWithFreezing((Function1)new Function1<Continuation<? super GitCommitEditingOperationResult>, Object>(this, null){
            int label;
            final /* synthetic */ GitDropSelectedChangesOperation this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = GitDropSelectedChangesOperation.access$dropSelectedChanges(this.this$0, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super GitCommitEditingOperationResult> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object dropSelectedChanges(Continuation<? super GitCommitEditingOperationResult> $completion) {
        if (!($completion instanceof dropSelectedChanges.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GitDropSelectedChangesOperation this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GitDropSelectedChangesOperation.access$dropSelectedChanges(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getRepository().getCurrentBranchName();
                if (v0 == null) {
                    v1 = GitBundle.message("rebase.log.changes.drop.action.detached.head.destination", new Object[0]);
                    v0 = v1;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(...)");
                }
                destinationName = v0;
                v2 = this.getRepository();
                v3 = GitBundle.message("rebase.log.changes.action.operation.drop.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)destinationName);
                $continuation.label = 1;
                v4 = GitPreservingProcess.Companion.runWithPreservedLocalChanges(v2, v3, destinationName, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, dropSelectedChanges$lambda$0(git4idea.rebase.log.changes.GitDropSelectedChangesOperation ), ()Lgit4idea/rebase/log/GitCommitEditingOperationResult;)((GitDropSelectedChangesOperation)this), $continuation);
                if (v4 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                destinationName = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl31:
                // 2 sources

                if ((v5 = (GitCommitEditingOperationResult)v4) == null) {
                    v5 = GitCommitEditingOperationResult.Incomplete.INSTANCE;
                }
                return v5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean canDropViaAmend() {
        String string = ((Hash)this.commit.getId()).asString();
        String string2 = this.initialHeadPosition;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
            string2 = null;
        }
        return Intrinsics.areEqual((Object)string, (Object)string2);
    }

    private final GitCommitEditingOperationResult dropViaAmend() {
        GitLineHandler gitLineHandler;
        if (!this.restoreChanges()) {
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        GitLineHandler $this$dropViaAmend_u24lambda_u240 = gitLineHandler = new GitLineHandler(this.getProject(), this.getRepository().getRoot(), GitCommand.COMMIT);
        boolean bl = false;
        String[] stringArray = new String[]{"--amend", "--no-verify", "--no-edit"};
        $this$dropViaAmend_u24lambda_u240.addParameters(stringArray);
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        this.getRepository().update();
        if (result2.success()) {
            GitRebaseParams.RebaseUpstream upstream = GitInteractiveRebaseUsingLogKt.getRebaseUpstreamFor((VcsShortCommitDetails)this.commit);
            GitRepository gitRepository = this.getRepository();
            String string = this.initialHeadPosition;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
                string = null;
            }
            String string2 = this.getRepository().getCurrentRevision();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.getRepository().getCurrentRevision();
            Intrinsics.checkNotNull((Object)string3);
            return new GitCommitEditingOperationResult.Complete(gitRepository, upstream, string, string2, HashImpl.build((String)string3), (Hash)this.commit.getId());
        }
        this.notifyGitCommandFailed(result2);
        return GitCommitEditingOperationResult.Incomplete.INSTANCE;
    }

    private final GitCommitEditingOperationResult dropViaRebase() {
        GitCommitEditingOperationResult result2;
        VcsCommitMetadata vcsCommitMetadata;
        if (!this.createFixupCommit()) {
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        try {
            List<? extends VcsCommitMetadata> list = GitLogUtil.collectMetadata(this.getProject(), this.getRepository().getRoot(), CollectionsKt.listOf((Object)"HEAD"));
            Intrinsics.checkNotNullExpressionValue(list, (String)"collectMetadata(...)");
            vcsCommitMetadata = (VcsCommitMetadata)CollectionsKt.single(list);
        }
        catch (VcsException e) {
            this.notifyOperationFailed(e);
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        VcsCommitMetadata fixupCommit = vcsCommitMetadata;
        Object[] e = new VcsCommitMetadata[]{fixupCommit, this.commit};
        List commitsToSquash = CollectionsKt.listOf((Object[])e);
        GitSquashOperation gitSquashOperation = new GitSquashOperation(this.getRepository());
        String string = this.commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        String string2 = this.initialHeadPosition;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
            string2 = null;
        }
        if ((result2 = gitSquashOperation.execute(commitsToSquash, string, string2)) instanceof GitCommitEditingOperationResult.Complete) {
            return ((GitCommitEditingOperationResult.Complete)result2).withFocusCommits(((GitCommitEditingOperationResult.Complete)result2).getFirstChangedHash(), (Hash)this.commit.getId());
        }
        return result2;
    }

    private final boolean createFixupCommit() {
        boolean bl;
        GitLineHandler gitLineHandler;
        if (!this.restoreChanges()) {
            return false;
        }
        GitLineHandler $this$createFixupCommit_u24lambda_u240 = gitLineHandler = new GitLineHandler(this.getProject(), this.getRepository().getRoot(), GitCommand.COMMIT);
        boolean bl2 = false;
        String[] stringArray = new String[]{"--no-verify", "-m", "fixup! " + this.commit.getId() + FIXUP_COMMIT_MESSAGE_SUFFIX};
        $this$createFixupCommit_u24lambda_u240.addParameters(stringArray);
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        if (result2.success()) {
            bl = true;
        } else {
            this.notifyGitCommandFailed(result2);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean restoreChanges() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.changes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void change;
            Change change2 = (Change)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = change.getBeforeRevision();
            if (object == null || (object = object.getFile()) == null) {
                ContentRevision contentRevision = change.getAfterRevision();
                object = contentRevision != null ? contentRevision.getFile() : null;
                if (object == null) {
                    throw new IllegalStateException("Can't get a path from a change".toString());
                }
            }
            collection.add(object);
        }
        List paths = (List)destination$iv$iv;
        try {
            List list = this.commit.getParents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
            if (!((Collection)list).isEmpty()) {
                GitFileUtils.restoreStagedAndWorktree(this.getProject(), this.getRepository().getRoot(), paths, this.commit.getId() + "~1");
            } else {
                GitFileUtils.deletePaths(this.getProject(), this.getRepository().getRoot(), paths, new String[0]);
            }
            return true;
        }
        catch (VcsException e) {
            this.notifyOperationFailed(e);
            return false;
        }
    }

    private final void notifyGitCommandFailed(GitCommandResult result2) {
        VcsNotifier.getInstance((Project)this.getProject()).notifyError("git.rebase.log.changes.drop.failed", GitBundle.message("rebase.log.changes.drop.failed.title", new Object[0]), result2.getErrorOutputAsHtmlString());
    }

    private final void notifyOperationFailed(VcsException exception) {
        VcsNotifier.getInstance((Project)this.getProject()).notifyError("git.rebase.log.changes.drop.failed", GitBundle.message("rebase.log.changes.drop.failed.title", new Object[0]), exception.getMessage());
    }

    private static final GitCommitEditingOperationResult dropSelectedChanges$lambda$0(GitDropSelectedChangesOperation this$0) {
        return this$0.canDropViaAmend() ? this$0.dropViaAmend() : this$0.dropViaRebase();
    }

    public static final /* synthetic */ Object access$dropSelectedChanges(GitDropSelectedChangesOperation $this, Continuation $completion) {
        return $this.dropSelectedChanges((Continuation<? super GitCommitEditingOperationResult>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/rebase/log/changes/GitDropSelectedChangesOperation$Companion;", "", "<init>", "()V", "FIXUP_COMMIT_MESSAGE_SUFFIX", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

