/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.coverage;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.git.coverage.CachedResult;
import com.intellij.vcs.git.coverage.CachedState;
import com.intellij.vcs.git.coverage.CurrentFeatureBranchBaseDetectorCache;
import com.intellij.vcs.git.coverage.CurrentFeatureBranchBaseDetectorKt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogGraphData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.config.GitSharedSettings;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0003$%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013JH\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00180\u00150\u001cH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0002J\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010#\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0018\u00010\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector;", "", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "pack", "Lcom/intellij/vcs/log/data/VcsLogGraphData;", "permanentGraph", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "getPermanentGraph$annotations", "()V", "findBaseCommit", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "computeStatus", "Lkotlin/Pair;", "", "headHash", "Lcom/intellij/vcs/log/Hash;", "permanentCommitsInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentCommitsInfo;", "protectedBranchHashes", "", "Lgit4idea/GitRemoteBranch;", "getHeadHash", "getCommitIndex", "hash", "(Lcom/intellij/vcs/log/Hash;)Ljava/lang/Integer;", "getHash", "nodeId", "Status", "BaseCommit", "BaseCommitAndBranch", "intellij.vcs.git.coverage"})
@SourceDebugExtension(value={"SMAP\nCurrentFeatureBranchBaseDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentFeatureBranchBaseDetector.kt\ncom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,217:1\n777#2:218\n873#2,2:219\n1586#2:221\n1661#2,3:222\n1586#2:225\n1661#2,3:226\n1642#2,10:230\n1915#2:240\n1916#2:242\n1652#2:243\n1642#2,10:244\n1915#2:254\n1916#2:256\n1652#2:257\n1586#2:258\n1661#2,3:259\n1#3:229\n1#3:241\n1#3:255\n23#4:262\n*S KotlinDebug\n*F\n+ 1 CurrentFeatureBranchBaseDetector.kt\ncom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector\n*L\n55#1:218\n55#1:219,2\n63#1:221\n63#1:222,3\n68#1:225\n68#1:226,3\n98#1:230,10\n98#1:240\n98#1:242\n98#1:243\n104#1:244,10\n104#1:254\n104#1:256\n104#1:257\n116#1:258\n116#1:259,3\n98#1:241\n104#1:255\n136#1:262\n*E\n"})
public final class CurrentFeatureBranchBaseDetector {
    @NotNull
    private final GitRepository repository;
    @Nullable
    private final VcsLogData logData;
    @Nullable
    private final VcsLogStorage storage;
    @Nullable
    private final VcsLogGraphData pack;
    @Nullable
    private final PermanentGraphInfo<Integer> permanentGraph;

    public CurrentFeatureBranchBaseDetector(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VcsLogData vcsLogData = this.logData = VcsProjectLog.Companion.getInstance(project).getDataManager();
        this.storage = vcsLogData != null ? vcsLogData.getStorage() : null;
        VcsLogData vcsLogData2 = this.logData;
        VcsLogGraphData vcsLogGraphData = this.pack = vcsLogData2 != null ? vcsLogData2.getGraphData() : null;
        PermanentGraph permanentGraph = vcsLogGraphData != null ? vcsLogGraphData.getPermanentGraph() : null;
        this.permanentGraph = permanentGraph instanceof PermanentGraphInfo ? (PermanentGraphInfo)permanentGraph : null;
    }

    private static /* synthetic */ void getPermanentGraph$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Status findBaseCommit() {
        Status status;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$filterTo$iv$iv;
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Collection collection = this.repository.getBranches().getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRemoteBranches(...)");
        Collection remoteBranches = collection;
        Iterable $this$filter$iv = remoteBranches;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRemoteBranch it = (GitRemoteBranch)element$iv$iv;
            boolean bl = false;
            if (!GitSharedSettings.getInstance((Project)project2).isBranchProtected(it.getNameForRemoteOperations())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List protectedBranches = (List)destination$iv$iv;
        if (protectedBranches.isEmpty()) {
            return Status.NoProtectedBranches.INSTANCE;
        }
        PermanentCommitsInfo permanentCommitsInfo = this.permanentGraph;
        if (permanentCommitsInfo == null || (permanentCommitsInfo = permanentCommitsInfo.getPermanentCommitsInfo()) == null) {
            return Status.GitDataNotFound.INSTANCE;
        }
        PermanentCommitsInfo permanentCommitsInfo2 = permanentCommitsInfo;
        Hash hash = this.getHeadHash();
        if (hash == null) {
            return Status.GitDataNotFound.INSTANCE;
        }
        Hash headHash = hash;
        Iterable $this$map$iv2 = protectedBranches;
        boolean $i$f$map22 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Hash branchHash;
            void branch;
            GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            if (this.repository.getBranches().getHash((GitBranch)branch) == null) {
                return Status.GitDataNotFound.INSTANCE;
            }
            collection2.add(TuplesKt.to((Object)branch, (Object)branchHash));
        }
        List protectedBranchHashes = (List)destination$iv$iv2;
        String string = headHash.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        Iterable $i$f$map22 = protectedBranchHashes;
        String string2 = string;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection3 = destination$iv$iv3;
            boolean bl = false;
            GitRemoteBranch branch = (GitRemoteBranch)pair.component1();
            Hash hash2 = (Hash)pair.component2();
            collection3.add(TuplesKt.to((Object)branch.getFullName(), (Object)hash2.asString()));
        }
        List list = (List)destination$iv$iv3;
        String string3 = string2;
        CachedState currentState = new CachedState(string3, list);
        WeakHashMap<GitRepository, CachedResult> cache = CurrentFeatureBranchBaseDetectorCache.Companion.getInstance(project2).getCache();
        CachedResult cachedResult = cache.get(this.repository);
        if (cachedResult == null || !Intrinsics.areEqual((Object)cachedResult.getState(), (Object)currentState)) {
            Pair<Status, Boolean> pair = this.computeStatus(headHash, (PermanentCommitsInfo<Integer>)permanentCommitsInfo2, protectedBranchHashes);
            Status status2 = (Status)pair.component1();
            boolean canCache = (Boolean)pair.component2();
            if (canCache) {
                ((Map)cache).put(this.repository, new CachedResult(status2, currentState));
            } else {
                cache.remove(this.repository);
            }
            status = status2;
        } else {
            status = cachedResult.getStatus();
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Status, Boolean> computeStatus(Hash headHash, PermanentCommitsInfo<Integer> permanentCommitsInfo, List<? extends Pair<? extends GitRemoteBranch, ? extends Hash>> protectedBranchHashes) {
        Status status;
        boolean completeGitData;
        void $this$mapNotNullTo$iv$iv;
        int commitIndex;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Integer n;
        Object it22;
        block15: {
            block14: {
                Integer n2 = this.getCommitIndex(headHash);
                if (n2 == null) break block14;
                int it22 = ((Number)n2).intValue();
                boolean bl = false;
                it22 = permanentCommitsInfo.getNodeId((Object)it22);
                int it = ((Number)it22).intValue();
                boolean bl2 = false;
                Integer n3 = n = it >= 0 ? it22 : null;
                if (n != null) break block15;
            }
            return TuplesKt.to((Object)Status.GitDataNotFound.INSTANCE, (Object)false);
        }
        int headNodeId = n;
        Iterable $this$mapNotNull$iv = protectedBranchHashes;
        boolean $i$f$mapNotNull = false;
        it22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            Pair pair;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            Pair pair2 = (Pair)element$iv$iv;
            boolean bl3 = false;
            GitRemoteBranch branch = (GitRemoteBranch)pair2.component1();
            Hash hash = (Hash)pair2.component2();
            VcsLogStorage vcsLogStorage = this.storage;
            if (vcsLogStorage == null) {
                pair = null;
            } else {
                VirtualFile virtualFile = this.repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                commitIndex = vcsLogStorage.getCommitIndex(hash, virtualFile);
                pair = TuplesKt.to((Object)commitIndex, (Object)branch);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map protectedBranchIndexes = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Set allNodeIds = permanentCommitsInfo.convertToNodeIds((Collection)protectedBranchIndexes.keySet());
        Iterable $this$mapNotNull$iv2 = allNodeIds;
        boolean $i$f$mapNotNull2 = false;
        Iterable $i$f$mapNotNullTo22 = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        element$iv$iv = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv.hasNext()) {
            Pair it$iv$iv;
            GitRemoteBranch branch;
            Object element$iv$iv$iv;
            Object element$iv$iv2 = element$iv$iv$iv = element$iv$iv.next();
            boolean bl = false;
            int nodeId = ((Number)element$iv$iv2).intValue();
            boolean bl5 = false;
            commitIndex = ((Number)permanentCommitsInfo.getCommitId(nodeId)).intValue();
            if (((GitRemoteBranch)protectedBranchIndexes.get(commitIndex) == null ? null : TuplesKt.to((Object)nodeId, (Object)branch)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map protectedNodeIds = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        boolean bl = completeGitData = protectedNodeIds.size() == protectedBranchHashes.size();
        if (protectedNodeIds.isEmpty()) {
            return TuplesKt.to((Object)Status.GitDataNotFound.INSTANCE, (Object)false);
        }
        LinearGraph linearGraph = this.permanentGraph;
        if (linearGraph == null || (linearGraph = linearGraph.getLinearGraph()) == null) {
            return TuplesKt.to((Object)Status.GitDataNotFound.INSTANCE, (Object)false);
        }
        LinearGraph linearGraph2 = linearGraph;
        Status status2 = CurrentFeatureBranchBaseDetectorKt.findBaseCommit(linearGraph2, headNodeId, protectedNodeIds.keySet());
        if (status2 instanceof Status.InternalSuccess) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((Status.InternalSuccess)status2).getCommits();
            boolean $i$f$map = false;
            Iterable $i$f$forEach22 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GitRemoteBranch branch;
                Hash hash;
                BaseCommit baseCommit = (BaseCommit)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl7 = false;
                int commitId = baseCommit.component1();
                int protectedBranchId = baseCommit.component2();
                if (this.getHash(commitId) == null) {
                    return TuplesKt.to((Object)Status.GitDataNotFound.INSTANCE, (Object)false);
                }
                if ((GitRemoteBranch)protectedNodeIds.get(protectedBranchId) == null) {
                    return TuplesKt.to((Object)Status.GitDataNotFound.INSTANCE, (Object)false);
                }
                collection.add(new BaseCommitAndBranch(hash, branch));
            }
            List commits = (List)destination$iv$iv3;
            status = new Status.Success(commits);
        } else {
            status = status2;
        }
        return TuplesKt.to((Object)status, (Object)completeGitData);
    }

    private final Hash getHeadHash() {
        Hash hash;
        String string = this.repository.getCurrentRevision();
        if (string == null) {
            return null;
        }
        String headRevision = string;
        try {
            hash = HashImpl.build((String)headRevision);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            CurrentFeatureBranchBaseDetector $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CurrentFeatureBranchBaseDetector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(e);
            return null;
        }
        return hash;
    }

    private final Integer getCommitIndex(Hash hash) {
        Integer n;
        VcsLogStorage vcsLogStorage = this.storage;
        if (vcsLogStorage != null) {
            VirtualFile virtualFile = this.repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            n = vcsLogStorage.getCommitIndex(hash, virtualFile);
        } else {
            n = null;
        }
        return n;
    }

    private final Hash getHash(int nodeId) {
        CommitId commit;
        Object object = this.permanentGraph;
        if (object == null || (object = object.getPermanentCommitsInfo()) == null || (object = (Integer)object.getCommitId(nodeId)) == null) {
            return null;
        }
        int commitId = (Integer)object;
        VcsLogStorage vcsLogStorage = this.storage;
        CommitId commitId2 = commit = vcsLogStorage != null ? vcsLogStorage.getCommitId(commitId) : null;
        return commitId2 != null ? commitId2.getHash() : null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$BaseCommit;", "", "commitId", "", "protectedNodeId", "<init>", "(II)V", "getCommitId", "()I", "getProtectedNodeId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.vcs.git.coverage"})
    public static final class BaseCommit {
        private final int commitId;
        private final int protectedNodeId;

        public BaseCommit(int commitId, int protectedNodeId) {
            this.commitId = commitId;
            this.protectedNodeId = protectedNodeId;
        }

        public final int getCommitId() {
            return this.commitId;
        }

        public final int getProtectedNodeId() {
            return this.protectedNodeId;
        }

        public final int component1() {
            return this.commitId;
        }

        public final int component2() {
            return this.protectedNodeId;
        }

        @NotNull
        public final BaseCommit copy(int commitId, int protectedNodeId) {
            return new BaseCommit(commitId, protectedNodeId);
        }

        public static /* synthetic */ BaseCommit copy$default(BaseCommit baseCommit, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = baseCommit.commitId;
            }
            if ((n3 & 2) != 0) {
                n2 = baseCommit.protectedNodeId;
            }
            return baseCommit.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "BaseCommit(commitId=" + this.commitId + ", protectedNodeId=" + this.protectedNodeId + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.commitId);
            result = result * 31 + Integer.hashCode(this.protectedNodeId);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BaseCommit)) {
                return false;
            }
            BaseCommit baseCommit = (BaseCommit)other;
            if (this.commitId != baseCommit.commitId) {
                return false;
            }
            return this.protectedNodeId == baseCommit.protectedNodeId;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$BaseCommitAndBranch;", "", "hash", "Lcom/intellij/vcs/log/Hash;", "protectedBranch", "Lgit4idea/GitRemoteBranch;", "<init>", "(Lcom/intellij/vcs/log/Hash;Lgit4idea/GitRemoteBranch;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getProtectedBranch", "()Lgit4idea/GitRemoteBranch;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
    public static final class BaseCommitAndBranch {
        @NotNull
        private final Hash hash;
        @NotNull
        private final GitRemoteBranch protectedBranch;

        public BaseCommitAndBranch(@NotNull Hash hash, @NotNull GitRemoteBranch protectedBranch) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)protectedBranch, (String)"protectedBranch");
            this.hash = hash;
            this.protectedBranch = protectedBranch;
        }

        @NotNull
        public final Hash getHash() {
            return this.hash;
        }

        @NotNull
        public final GitRemoteBranch getProtectedBranch() {
            return this.protectedBranch;
        }

        @NotNull
        public final Hash component1() {
            return this.hash;
        }

        @NotNull
        public final GitRemoteBranch component2() {
            return this.protectedBranch;
        }

        @NotNull
        public final BaseCommitAndBranch copy(@NotNull Hash hash, @NotNull GitRemoteBranch protectedBranch) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)protectedBranch, (String)"protectedBranch");
            return new BaseCommitAndBranch(hash, protectedBranch);
        }

        public static /* synthetic */ BaseCommitAndBranch copy$default(BaseCommitAndBranch baseCommitAndBranch, Hash hash, GitRemoteBranch gitRemoteBranch, int n, Object object) {
            if ((n & 1) != 0) {
                hash = baseCommitAndBranch.hash;
            }
            if ((n & 2) != 0) {
                gitRemoteBranch = baseCommitAndBranch.protectedBranch;
            }
            return baseCommitAndBranch.copy(hash, gitRemoteBranch);
        }

        @NotNull
        public String toString() {
            return "BaseCommitAndBranch(hash=" + this.hash + ", protectedBranch=" + this.protectedBranch + ")";
        }

        public int hashCode() {
            int result = this.hash.hashCode();
            result = result * 31 + this.protectedBranch.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BaseCommitAndBranch)) {
                return false;
            }
            BaseCommitAndBranch baseCommitAndBranch = (BaseCommitAndBranch)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)baseCommitAndBranch.hash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.protectedBranch, (Object)baseCommitAndBranch.protectedBranch);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u0082\u0001\u0007\t\n\u000b\f\r\u000e\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "", "Success", "InternalSuccess", "NoProtectedBranches", "HeadInProtectedBranch", "GitDataNotFound", "CommitHasNoProtectedParents", "SearchLimitReached", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$CommitHasNoProtectedParents;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$GitDataNotFound;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$HeadInProtectedBranch;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$InternalSuccess;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$NoProtectedBranches;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$SearchLimitReached;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$Success;", "intellij.vcs.git.coverage"})
    public static sealed interface Status {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$CommitHasNoProtectedParents;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
        public static final class CommitHasNoProtectedParents
        implements Status {
            @NotNull
            public static final CommitHasNoProtectedParents INSTANCE = new CommitHasNoProtectedParents();

            private CommitHasNoProtectedParents() {
            }

            @NotNull
            public String toString() {
                return "CommitHasNoProtectedParents";
            }

            public int hashCode() {
                return -1794371613;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CommitHasNoProtectedParents)) {
                    return false;
                }
                CommitHasNoProtectedParents cfr_ignored_0 = (CommitHasNoProtectedParents)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$GitDataNotFound;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
        public static final class GitDataNotFound
        implements Status {
            @NotNull
            public static final GitDataNotFound INSTANCE = new GitDataNotFound();

            private GitDataNotFound() {
            }

            @NotNull
            public String toString() {
                return "GitDataNotFound";
            }

            public int hashCode() {
                return 873061487;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GitDataNotFound)) {
                    return false;
                }
                GitDataNotFound cfr_ignored_0 = (GitDataNotFound)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$HeadInProtectedBranch;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
        public static final class HeadInProtectedBranch
        implements Status {
            @NotNull
            public static final HeadInProtectedBranch INSTANCE = new HeadInProtectedBranch();

            private HeadInProtectedBranch() {
            }

            @NotNull
            public String toString() {
                return "HeadInProtectedBranch";
            }

            public int hashCode() {
                return -1826825393;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HeadInProtectedBranch)) {
                    return false;
                }
                HeadInProtectedBranch cfr_ignored_0 = (HeadInProtectedBranch)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$InternalSuccess;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "commits", "", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$BaseCommit;", "<init>", "(Ljava/util/List;)V", "getCommits", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
        public static final class InternalSuccess
        implements Status {
            @NotNull
            private final List<BaseCommit> commits;

            public InternalSuccess(@NotNull List<BaseCommit> commits) {
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                this.commits = commits;
            }

            @NotNull
            public final List<BaseCommit> getCommits() {
                return this.commits;
            }

            @NotNull
            public final List<BaseCommit> component1() {
                return this.commits;
            }

            @NotNull
            public final InternalSuccess copy(@NotNull List<BaseCommit> commits) {
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                return new InternalSuccess(commits);
            }

            public static /* synthetic */ InternalSuccess copy$default(InternalSuccess internalSuccess, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = internalSuccess.commits;
                }
                return internalSuccess.copy(list);
            }

            @NotNull
            public String toString() {
                return "InternalSuccess(commits=" + this.commits + ")";
            }

            public int hashCode() {
                return ((Object)this.commits).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InternalSuccess)) {
                    return false;
                }
                InternalSuccess internalSuccess = (InternalSuccess)other;
                return Intrinsics.areEqual(this.commits, internalSuccess.commits);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$NoProtectedBranches;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
        public static final class NoProtectedBranches
        implements Status {
            @NotNull
            public static final NoProtectedBranches INSTANCE = new NoProtectedBranches();

            private NoProtectedBranches() {
            }

            @NotNull
            public String toString() {
                return "NoProtectedBranches";
            }

            public int hashCode() {
                return -598675679;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoProtectedBranches)) {
                    return false;
                }
                NoProtectedBranches cfr_ignored_0 = (NoProtectedBranches)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$SearchLimitReached;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
        public static final class SearchLimitReached
        implements Status {
            @NotNull
            public static final SearchLimitReached INSTANCE = new SearchLimitReached();

            private SearchLimitReached() {
            }

            @NotNull
            public String toString() {
                return "SearchLimitReached";
            }

            public int hashCode() {
                return 340885275;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SearchLimitReached)) {
                    return false;
                }
                SearchLimitReached cfr_ignored_0 = (SearchLimitReached)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status$Success;", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "commits", "", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$BaseCommitAndBranch;", "<init>", "(Ljava/util/List;)V", "getCommits", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git.coverage"})
        public static final class Success
        implements Status {
            @NotNull
            private final List<BaseCommitAndBranch> commits;

            public Success(@NotNull List<BaseCommitAndBranch> commits) {
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                this.commits = commits;
            }

            @NotNull
            public final List<BaseCommitAndBranch> getCommits() {
                return this.commits;
            }

            @NotNull
            public final List<BaseCommitAndBranch> component1() {
                return this.commits;
            }

            @NotNull
            public final Success copy(@NotNull List<BaseCommitAndBranch> commits) {
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                return new Success(commits);
            }

            public static /* synthetic */ Success copy$default(Success success, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = success.commits;
                }
                return success.copy(list);
            }

            @NotNull
            public String toString() {
                return "Success(commits=" + this.commits + ")";
            }

            public int hashCode() {
                return ((Object)this.commits).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual(this.commits, success.commits);
            }
        }
    }
}

