/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.tools.simple.DiffViewerHighlighters;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0002+,B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0017J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0013H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0013H\u0002J\n\u0010'\u001a\u0004\u0018\u00010$H\u0002J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/intellij/diff/merge/ThreesideMergeHighlighters;", "Lcom/intellij/diff/tools/simple/DiffViewerHighlighters;", "change", "Lcom/intellij/diff/merge/TextMergeChange;", "innerFragments", "Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "<init>", "(Lcom/intellij/diff/merge/TextMergeChange;Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;Lcom/intellij/diff/merge/MergeThreesideViewer;)V", "getChange", "()Lcom/intellij/diff/merge/TextMergeChange;", "getInnerFragments", "()Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "setInnerFragments", "(Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;)V", "updateOperations", "", "force", "", "reinstallAll", "installOperations", "createOperation", "Lcom/intellij/diff/util/DiffGutterOperation;", "side", "Lcom/intellij/diff/util/ThreeSide;", "builder", "Lcom/intellij/diff/util/DiffGutterOperation$ModifiersRendererBuilder;", "createResolveOperation", "createAcceptOperation", "versionSide", "Lcom/intellij/diff/util/Side;", "type", "Lcom/intellij/diff/merge/ThreesideMergeHighlighters$OperationType;", "createResetOperation", "createApplyRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "modifier", "createIgnoreRenderer", "createResolveRenderer", "destroyInnerHighlighters", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "OperationType", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class ThreesideMergeHighlighters
extends DiffViewerHighlighters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextMergeChange change;
    @NotNull
    private final MergeThreesideViewer viewer;
    @Nullable
    private MergeInnerDifferences innerFragments;

    public ThreesideMergeHighlighters(@NotNull TextMergeChange change, @Nullable MergeInnerDifferences innerFragments, @NotNull MergeThreesideViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        super(change, innerFragments, (Function1<? super ThreeSide, ? extends EditorEx>)((Function1)new Function1<ThreeSide, EditorEx>((Object)viewer){

            public final EditorEx invoke(ThreeSide p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MergeThreesideViewer)this.receiver).getEditor(p0);
            }
        }));
        this.change = change;
        this.viewer = viewer;
        this.reinstallAll();
    }

    public /* synthetic */ ThreesideMergeHighlighters(TextMergeChange textMergeChange, MergeInnerDifferences mergeInnerDifferences, MergeThreesideViewer mergeThreesideViewer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mergeInnerDifferences = null;
        }
        this(textMergeChange, mergeInnerDifferences, mergeThreesideViewer);
    }

    @Override
    @NotNull
    protected TextMergeChange getChange() {
        return this.change;
    }

    @Override
    @Nullable
    public MergeInnerDifferences getInnerFragments() {
        return this.innerFragments;
    }

    @Override
    @RequiresEdt
    public void setInnerFragments(@Nullable MergeInnerDifferences innerFragments) {
        if (this.innerFragments == null && innerFragments == null) {
            return;
        }
        this.innerFragments = innerFragments;
        this.reinstallAll();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    public final void updateOperations(boolean force) {
        for (DiffGutterOperation operation : this.getOperations()) {
            operation.update(force);
        }
    }

    @Override
    @RequiresEdt
    public void reinstallAll() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyOperations();
        this.installOperations();
        this.viewer.repaintDividers();
    }

    @Override
    public void installOperations() {
        if (this.viewer.isExternalOperationInProgress()) {
            return;
        }
        this.addOperation(this.createResolveOperation());
        this.addOperation(this.createAcceptOperation(Side.LEFT, OperationType.APPLY));
        this.addOperation(this.createAcceptOperation(Side.LEFT, OperationType.IGNORE));
        this.addOperation(this.createAcceptOperation(Side.RIGHT, OperationType.APPLY));
        this.addOperation(this.createAcceptOperation(Side.RIGHT, OperationType.IGNORE));
        this.addOperation(this.createResetOperation());
    }

    private final DiffGutterOperation createOperation(ThreeSide side, DiffGutterOperation.ModifiersRendererBuilder builder) {
        if (this.getChange().isResolved(side)) {
            return null;
        }
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getChange().getStartLine(side));
        return new DiffGutterOperation.WithModifiers((Editor)editor, offset, this.viewer.getModifierProvider(), builder);
    }

    private final DiffGutterOperation createResolveOperation() {
        return this.createOperation(ThreeSide.BASE, (arg_0, arg_1, arg_2) -> ThreesideMergeHighlighters.createResolveOperation$lambda$0(this, arg_0, arg_1, arg_2));
    }

    private final DiffGutterOperation createAcceptOperation(Side versionSide, OperationType type) {
        ThreeSide side = (ThreeSide)versionSide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        return this.createOperation(side, (arg_0, arg_1, arg_2) -> ThreesideMergeHighlighters.createAcceptOperation$lambda$0(this, versionSide, type, arg_0, arg_1, arg_2));
    }

    private final DiffGutterOperation createResetOperation() {
        if (!this.getChange().isResolved() || !this.getChange().isResolvedWithAI()) {
            return null;
        }
        EditorEx editorEx = this.viewer.getEditor(ThreeSide.BASE);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getChange().getStartLine(ThreeSide.BASE));
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> ThreesideMergeHighlighters.createResetOperation$lambda$0(this));
    }

    private final GutterIconRenderer createApplyRenderer(Side side, boolean modifier) {
        if (this.getChange().isResolved(side)) {
            return null;
        }
        Icon icon = this.getChange().isOnesideAppliedConflict() ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        String string = DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return Companion.createIconRenderer$intellij_platform_diff_impl(string, icon2, this.getChange().isConflict(), () -> ThreesideMergeHighlighters.createApplyRenderer$lambda$0(this, side, modifier));
    }

    private final GutterIconRenderer createIgnoreRenderer(Side side, boolean modifier) {
        if (this.getChange().isResolved(side)) {
            return null;
        }
        String string = DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.Diff.Remove;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Remove");
        return Companion.createIconRenderer$intellij_platform_diff_impl(string, icon, this.getChange().isConflict(), () -> ThreesideMergeHighlighters.createIgnoreRenderer$lambda$0(this, side, modifier));
    }

    private final GutterIconRenderer createResolveRenderer() {
        if (!this.getChange().isConflict() || !this.viewer.getModel().canResolveChangeAutomatically(this.getChange().getIndex(), ThreeSide.BASE)) {
            return null;
        }
        String string = DiffBundle.message((String)"action.presentation.merge.resolve.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.Diff.MagicResolve;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MagicResolve");
        return Companion.createIconRenderer$intellij_platform_diff_impl(string, icon, false, () -> ThreesideMergeHighlighters.createResolveRenderer$lambda$0(this));
    }

    public final void destroyInnerHighlighters(@NotNull DocumentEx document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        for (RangeHighlighter inner : this.getInnerHighlighters()) {
            if (!Intrinsics.areEqual((Object)inner.getDocument(), (Object)document)) continue;
            inner.dispose();
        }
    }

    private static final GutterIconRenderer createResolveOperation$lambda$0(ThreesideMergeHighlighters this$0, boolean bl, boolean bl2, boolean bl3) {
        return this$0.createResolveRenderer();
    }

    private static final GutterIconRenderer createAcceptOperation$lambda$0(ThreesideMergeHighlighters this$0, Side $versionSide, OperationType $type, boolean ctrlPressed, boolean bl, boolean bl2) {
        if (!this$0.getChange().isChange($versionSide)) {
            return null;
        }
        if ($type == OperationType.APPLY) {
            return this$0.createApplyRenderer($versionSide, ctrlPressed);
        }
        return this$0.createIgnoreRenderer($versionSide, ctrlPressed);
    }

    private static final void createResetOperation$lambda$0$0$0(ThreesideMergeHighlighters this$0) {
        this$0.viewer.getModel().resetResolvedChange(this$0.getChange().getIndex());
    }

    private static final void createResetOperation$lambda$0$0(ThreesideMergeHighlighters this$0) {
        Object[] objectArray = new TextMergeChange[]{this$0.getChange()};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.reset.change.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> ThreesideMergeHighlighters.createResetOperation$lambda$0$0$0(this$0));
    }

    private static final GutterIconRenderer createResetOperation$lambda$0(ThreesideMergeHighlighters this$0) {
        String string = DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.Diff.Revert;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Revert");
        return Companion.createIconRenderer$intellij_platform_diff_impl(string, icon, false, () -> ThreesideMergeHighlighters.createResetOperation$lambda$0$0(this$0));
    }

    private static final void createApplyRenderer$lambda$0$0(ThreesideMergeHighlighters this$0, Side $side, boolean $modifier) {
        this$0.viewer.replaceSingleChange(this$0.getChange(), $side, $modifier);
    }

    private static final void createApplyRenderer$lambda$0(ThreesideMergeHighlighters this$0, Side $side, boolean $modifier) {
        Object[] objectArray = new TextMergeChange[]{this$0.getChange()};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> ThreesideMergeHighlighters.createApplyRenderer$lambda$0$0(this$0, $side, $modifier));
    }

    private static final void createIgnoreRenderer$lambda$0$0(ThreesideMergeHighlighters this$0, Side $side, boolean $modifier) {
        this$0.viewer.getModel().ignoreChange(this$0.getChange().getIndex(), $side, $modifier);
    }

    private static final void createIgnoreRenderer$lambda$0(ThreesideMergeHighlighters this$0, Side $side, boolean $modifier) {
        Object[] objectArray = new TextMergeChange[]{this$0.getChange()};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> ThreesideMergeHighlighters.createIgnoreRenderer$lambda$0$0(this$0, $side, $modifier));
    }

    private static final void createResolveRenderer$lambda$0$0(ThreesideMergeHighlighters this$0) {
        this$0.viewer.resolveSingleChangeAutomatically(this$0.getChange(), ThreeSide.BASE);
    }

    private static final void createResolveRenderer$lambda$0(ThreesideMergeHighlighters this$0) {
        Object[] objectArray = new TextMergeChange[]{this$0.getChange()};
        this$0.viewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.resolve.conflict.command", (Object[])new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), () -> ThreesideMergeHighlighters.createResolveRenderer$lambda$0$0(this$0));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/merge/ThreesideMergeHighlighters$Companion;", "", "<init>", "()V", "createIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "icon", "Ljavax/swing/Icon;", "ctrlClickVisible", "", "perform", "Ljava/lang/Runnable;", "createIconRenderer$intellij_platform_diff_impl", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GutterIconRenderer createIconRenderer$intellij_platform_diff_impl(@NotNull String text, @NotNull Icon icon, boolean ctrlClickVisible, @NotNull Runnable perform) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)perform, (String)"perform");
            String appendix = ctrlClickVisible ? DiffBundle.message((String)"tooltip.merge.ctrl.click.to.resolve.conflict", (Object[])new Object[0]) : null;
            String string = DiffUtil.createTooltipText(text, appendix);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createTooltipText(...)");
            String tooltipText = string;
            return new DiffGutterRenderer(icon, tooltipText, perform){
                final /* synthetic */ Runnable $perform;
                {
                    this.$perform = $perform;
                    super($icon, $tooltipText);
                }

                protected void handleMouseClick() {
                    this.$perform.run();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/merge/ThreesideMergeHighlighters$OperationType;", "", "<init>", "(Ljava/lang/String;I)V", "APPLY", "IGNORE", "intellij.platform.diff.impl"})
    private static final class OperationType
    extends Enum<OperationType> {
        public static final /* enum */ OperationType APPLY = new OperationType();
        public static final /* enum */ OperationType IGNORE = new OperationType();
        private static final /* synthetic */ OperationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OperationType[] values() {
            return (OperationType[])$VALUES.clone();
        }

        public static OperationType valueOf(String value) {
            return Enum.valueOf(OperationType.class, value);
        }

        @NotNull
        public static EnumEntries<OperationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationTypeArray = new OperationType[]{OperationType.APPLY, OperationType.IGNORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

