/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.statistics;

import com.intellij.diff.merge.MergeStatisticsAggregator;
import com.intellij.diff.statistics.MergeAction;
import com.intellij.diff.statistics.MergeResultSource;
import com.intellij.diff.statistics.SourceDialog;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventDataCollector;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u00014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010$\u001a\u00020\u0005H\u0016J2\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+H\u0007J\u0018\u0010.\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u001eJ*\u0010/\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u000203H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/diff/statistics/MergeStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "MERGE_RESULT", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/diff/statistics/MergeStatisticsCollector$MergeResult;", "SOURCE", "Lcom/intellij/diff/statistics/MergeResultSource;", "CHANGES", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "AUTO_RESOLVABLE", "AUTO_RESOLVABLE_WITH_SEMANTICS", "FILE_LANGUAGE", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/lang/Language;", "CONFLICTS", "EDITED", "UNRESOLVED", "AI_RESOLVED", "AI_ROLLED_BACK", "AI_UNDONE", "AI_EDITED", "FILE_MERGED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "SOURCE_DIALOG", "Lcom/intellij/diff/statistics/SourceDialog;", "MERGE_ACTION", "Lcom/intellij/diff/statistics/MergeAction;", "CONFIRMATION_SHOWN", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "CONFIRMATION_ACCEPTED", "BY_ESC", "DIALOG_MERGE_EVENT", "getGroup", "logMergeDialogEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "action", "confirmationShown", "", "confirmationAccepted", "byEsc", "logButtonClickOnTable", "logMergeFinished", "result", "source", "aggregator", "Lcom/intellij/diff/merge/MergeStatisticsAggregator;", "MergeResult", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class MergeStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final MergeStatisticsCollector INSTANCE = new MergeStatisticsCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("vcs.merge", 5, null, 4, null);
    @NotNull
    private static final EnumEventField<MergeResult> MERGE_RESULT = EventFields.Enum$default((String)"result", MergeResult.class, null, (int)4, null);
    @NotNull
    private static final EnumEventField<MergeResultSource> SOURCE = EventFields.Enum$default((String)"source", MergeResultSource.class, null, (int)4, null);
    @NotNull
    private static final IntEventField CHANGES = EventFields.Int((String)"changes");
    @NotNull
    private static final IntEventField AUTO_RESOLVABLE = EventFields.Int((String)"autoResolvable");
    @NotNull
    private static final IntEventField AUTO_RESOLVABLE_WITH_SEMANTICS = EventFields.Int((String)"autoResolvableWithSemantics");
    @NotNull
    private static final PrimitiveEventField<Language> FILE_LANGUAGE = EventFields.Language((String)"fileLanguage", (String)"Stores information about the base file");
    @NotNull
    private static final IntEventField CONFLICTS = EventFields.Int((String)"conflicts");
    @NotNull
    private static final IntEventField EDITED = EventFields.Int((String)"edited");
    @NotNull
    private static final IntEventField UNRESOLVED = EventFields.Int((String)"unresolved");
    @NotNull
    private static final IntEventField AI_RESOLVED = EventFields.Int((String)"aiResolved");
    @NotNull
    private static final IntEventField AI_ROLLED_BACK = EventFields.Int((String)"rolledBackAfterAi");
    @NotNull
    private static final IntEventField AI_UNDONE = EventFields.Int((String)"undoneAfterAi");
    @NotNull
    private static final IntEventField AI_EDITED = EventFields.Int((String)"editedAfterAi");
    @NotNull
    private static final VarargEventId FILE_MERGED_EVENT;
    @NotNull
    private static final EnumEventField<SourceDialog> SOURCE_DIALOG;
    @NotNull
    private static final EnumEventField<MergeAction> MERGE_ACTION;
    @NotNull
    private static final BooleanEventField CONFIRMATION_SHOWN;
    @NotNull
    private static final BooleanEventField CONFIRMATION_ACCEPTED;
    @NotNull
    private static final BooleanEventField BY_ESC;
    @NotNull
    private static final VarargEventId DIALOG_MERGE_EVENT;

    private MergeStatisticsCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void logMergeDialogEvent(@Nullable Project project, @NotNull MergeAction action2, boolean confirmationShown, boolean confirmationAccepted, boolean byEsc) {
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        EventPair[] eventPairArray = new EventPair[]{SOURCE_DIALOG.with((Object)SourceDialog.MERGE_VIEWER), MERGE_ACTION.with((Object)action2), CONFIRMATION_SHOWN.with((Object)confirmationShown), CONFIRMATION_ACCEPTED.with((Object)confirmationAccepted), BY_ESC.with((Object)byEsc)};
        DIALOG_MERGE_EVENT.log(project, eventPairArray);
    }

    public final void logButtonClickOnTable(@Nullable Project project, @NotNull MergeAction action2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        boolean bl2 = bl = action2 == MergeAction.LEFT || action2 == MergeAction.RIGHT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        EventPair[] eventPairArray = new EventPair[]{SOURCE_DIALOG.with((Object)SourceDialog.CONFLICTS_TABLE), MERGE_ACTION.with((Object)action2), CONFIRMATION_SHOWN.with((Object)false), CONFIRMATION_ACCEPTED.with((Object)false), BY_ESC.with((Object)false)};
        DIALOG_MERGE_EVENT.log(project, eventPairArray);
    }

    @JvmStatic
    public static final void logMergeFinished(@Nullable Project project, @NotNull MergeResult result, @NotNull MergeResultSource source, @NotNull MergeStatisticsAggregator aggregator) {
        Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)aggregator, (String)"aggregator");
        FILE_MERGED_EVENT.log(project, arg_0 -> MergeStatisticsCollector.logMergeFinished$lambda$0(result, source, aggregator, arg_0));
    }

    private static final Unit logMergeFinished$lambda$0(MergeResult $result, MergeResultSource $source, MergeStatisticsAggregator $aggregator, EventDataCollector $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        $this$log.add((Object)MERGE_RESULT.with((Object)$result));
        $this$log.add((Object)SOURCE.with((Object)$source));
        $this$log.add((Object)CHANGES.with((Object)$aggregator.getChanges()));
        $this$log.add((Object)EventFields.DurationMs.with((Object)(System.currentTimeMillis() - $aggregator.getInitialTimestamp())));
        $this$log.add((Object)AUTO_RESOLVABLE.with((Object)$aggregator.getAutoResolvable()));
        $this$log.add((Object)AUTO_RESOLVABLE_WITH_SEMANTICS.with((Object)$aggregator.getAutoResolvableWithSemantics()));
        $this$log.add((Object)CONFLICTS.with((Object)$aggregator.getConflicts()));
        $this$log.add((Object)EDITED.with((Object)$aggregator.edited()));
        $this$log.add((Object)UNRESOLVED.with((Object)$aggregator.getUnresolved()));
        $this$log.add((Object)AI_RESOLVED.with((Object)$aggregator.resolvedByAi()));
        $this$log.add((Object)AI_ROLLED_BACK.with((Object)$aggregator.rolledBackAfterAI()));
        $this$log.add((Object)AI_UNDONE.with((Object)$aggregator.undoneAfterAI()));
        $this$log.add((Object)AI_EDITED.with((Object)$aggregator.editedAfterAI()));
        $this$log.add((Object)FILE_LANGUAGE.with((Object)$aggregator.getLanguage()));
        return Unit.INSTANCE;
    }

    static {
        EventField[] eventFieldArray = new EventField[]{MERGE_RESULT, SOURCE, CHANGES, EventFields.DurationMs, AUTO_RESOLVABLE, AUTO_RESOLVABLE_WITH_SEMANTICS, FILE_LANGUAGE, CONFLICTS, EDITED, UNRESOLVED, AI_RESOLVED, AI_ROLLED_BACK, AI_UNDONE, AI_EDITED};
        FILE_MERGED_EVENT = GROUP.registerVarargEvent("file.merged", eventFieldArray);
        SOURCE_DIALOG = EventFields.Enum$default((String)"dialog", SourceDialog.class, null, (int)4, null);
        MERGE_ACTION = EventFields.Enum$default((String)"action", MergeAction.class, null, (int)4, null);
        CONFIRMATION_SHOWN = EventFields.Boolean((String)"confirmationShown");
        CONFIRMATION_ACCEPTED = EventFields.Boolean((String)"confirmationAccepted");
        BY_ESC = EventFields.Boolean((String)"byEsc");
        eventFieldArray = new EventField[]{SOURCE_DIALOG, MERGE_ACTION, CONFIRMATION_SHOWN, CONFIRMATION_SHOWN, CONFIRMATION_ACCEPTED, BY_ESC};
        DIALOG_MERGE_EVENT = GROUP.registerVarargEvent("merge.event", eventFieldArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/statistics/MergeStatisticsCollector$MergeResult;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "CANCELED", "intellij.platform.diff.impl"})
    public static final class MergeResult
    extends Enum<MergeResult> {
        public static final /* enum */ MergeResult SUCCESS = new MergeResult();
        public static final /* enum */ MergeResult CANCELED = new MergeResult();
        private static final /* synthetic */ MergeResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MergeResult[] values() {
            return (MergeResult[])$VALUES.clone();
        }

        public static MergeResult valueOf(String value) {
            return Enum.valueOf(MergeResult.class, value);
        }

        @NotNull
        public static EnumEntries<MergeResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mergeResultArray = new MergeResult[]{MergeResult.SUCCESS, MergeResult.CANCELED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

