/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffState;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilderKt;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Document;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diff/tools/fragmented/SimpleUnifiedFragmentBuilder;", "Lcom/intellij/diff/tools/fragmented/UnifiedFragmentBuilder;", "document1", "Lcom/intellij/openapi/editor/Document;", "document2", "masterSide", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lcom/intellij/diff/util/Side;)V", "exec", "Lcom/intellij/diff/tools/fragmented/UnifiedDiffState;", "fragments", "", "Lcom/intellij/diff/fragments/LineFragment;", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class SimpleUnifiedFragmentBuilder
extends UnifiedFragmentBuilder {
    public SimpleUnifiedFragmentBuilder(@NotNull Document document1, @NotNull Document document2, @NotNull Side masterSide) {
        Intrinsics.checkNotNullParameter((Object)document1, (String)"document1");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document2");
        Intrinsics.checkNotNullParameter((Object)masterSide, (String)"masterSide");
        super(document1, document2, masterSide);
    }

    @NotNull
    public final UnifiedDiffState exec(@NotNull List<? extends LineFragment> fragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        for (LineFragment lineFragment : fragments) {
            UnifiedFragmentBuilder.BlockLineRange blockLineRange = this.processChanged(UnifiedFragmentBuilderKt.asLineRange(lineFragment));
            UnifiedDiffChange change = new UnifiedDiffChange(blockLineRange.getBlockStart(), blockLineRange.getInsertedStart(), blockLineRange.getBlockEnd(), lineFragment);
            this.reportChange(change);
        }
        this.finishDocuments();
        Side side = this.getMasterSide();
        CharSequence charSequence = this.getTextBuilder();
        List<UnifiedDiffChange> list = this.getChanges();
        List<HighlightRange> list2 = this.getRanges();
        LineNumberConvertor lineNumberConvertor = this.getConvertorBuilder1().build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor, (String)"build(...)");
        LineNumberConvertor lineNumberConvertor2 = this.getConvertorBuilder2().build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor2, (String)"build(...)");
        return new UnifiedDiffState(side, charSequence, list, list2, lineNumberConvertor, lineNumberConvertor2, this.getChangedLines());
    }
}

