/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/diff/tools/simple/SimpleThreesideDiffChange;", "Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;", "fragment", "Lcom/intellij/diff/fragments/MergeLineFragment;", "conflictType", "Lcom/intellij/diff/util/MergeConflictType;", "<init>", "(Lcom/intellij/diff/fragments/MergeLineFragment;Lcom/intellij/diff/util/MergeConflictType;)V", "lineStarts", "", "lineEnds", "value", "", "isValid", "()Z", "getStartLine", "", "side", "Lcom/intellij/diff/util/ThreeSide;", "getEndLine", "isResolved", "markInvalid", "", "processChange", "oldLine1", "oldLine2", "shift", "intellij.platform.diff.impl"})
public final class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final int[] lineStarts;
    @NotNull
    private final int[] lineEnds;
    private boolean isValid;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)conflictType, (String)"conflictType");
        super(conflictType);
        this.lineStarts = new int[3];
        this.lineEnds = new int[3];
        this.isValid = true;
        for (ThreeSide side : ThreeSide.getEntries()) {
            this.lineStarts[side.getIndex()] = fragment.getStartLine(side);
            this.lineEnds[side.getIndex()] = fragment.getEndLine(side);
        }
    }

    public final boolean isValid() {
        return this.isValid;
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side.select(this.lineStarts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side.select(this.lineEnds);
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return false;
    }

    public final void markInvalid() {
        this.isValid = false;
    }

    public final boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange updatedLineRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        Intrinsics.checkNotNullExpressionValue((Object)updatedLineRange, (String)"updateRangeOnModification(...)");
        DiffUtil.UpdatedLineRange newRange = updatedLineRange;
        this.lineStarts[sideIndex] = newRange.startLine;
        this.lineEnds[sideIndex] = newRange.endLine;
        return newRange.damaged;
    }
}

