/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DiffLineSeparatorRenderer
implements LineMarkerRendererEx,
LineSeparatorRenderer,
ActiveGutterRenderer {
    private static Object[] ourCachedImageKey = null;
    private static BufferedImage outCachedImage = null;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final SeparatorPresentation myPresentation;
    @Deprecated
    public static final ColorKey BACKGROUND = ColorKey.createColorKey((String)"DIFF_SEPARATORS_BACKGROUND");
    public static final ColorKey FOREGROUND = ColorKey.createColorKey((String)"DIFF_SEPARATOR_WAVE");

    public DiffLineSeparatorRenderer(@NotNull Editor editor, @NotNull SeparatorPresentation presentation) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myPresentation = presentation;
    }

    public static void drawConnectorLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2, int lineHeight, boolean isHovered, @Nullable EditorColorsScheme scheme) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(2);
        }
        if (x1 == x2) {
            return;
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        int extraGap = DiffLineSeparatorRenderer.getAAGap();
        int verticalOffset = DiffLineSeparatorRenderer.getVerticalOffset(lineHeight);
        int verticalAlign = verticalOffset + height + extraGap;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo((float)x1 - 0.5f, y1 += verticalAlign);
        double delta = (double)Math.abs((y2 += verticalAlign) - y1) / (double)Math.abs(x2 - x1);
        if (delta < 0.2) {
            double middleX = (double)(x1 + x2) / 2.0;
            double middleY = (double)(y1 + y2) / 2.0;
            if (x2 - x1 > 5 * step) {
                ((Path2D)path).quadTo((double)x1 + (double)step * 0.5, y1 + height, x1 + step, y1 + height);
                ((Path2D)path).quadTo((double)x1 + (double)step * 1.5, y1 + height, (double)x1 + (double)step * 2.0, middleY);
                ((Path2D)path).quadTo((double)x1 + (double)step * 2.5, middleY - (double)height, middleX, middleY - (double)height);
                ((Path2D)path).quadTo((double)x2 - (double)step * 2.5, middleY - (double)height, (double)x2 - (double)step * 2.0, middleY);
                ((Path2D)path).quadTo((double)x2 - (double)step * 1.5, y2 + height, (double)x2 - (double)step * 1.0, y2 + height);
                ((Path2D)path).quadTo((double)x2 - (double)step * 0.5, y2 + height, x2, y2);
            } else {
                ((Path2D)path).quadTo(middleX, middleY + (double)(2 * height), x2, y2);
            }
        } else if (y1 > y2) {
            ((Path2D)path).curveTo((double)x1 + (double)step * 0.125, (double)y1 + (double)height * 0.125, (double)x1 + (double)step * 0.125, (double)y1 + (double)height * 0.5, (double)x1 + (double)step * 0.5, (double)y1 + (double)height * 0.5);
            ((Path2D)path).curveTo((double)x2 - (double)step * 2.0, (double)y1 + (double)height * 0.5, (double)x2 - (double)step * 2.0, (double)y2 + (double)(2 * height) * 2.0, x2, y2);
        } else {
            ((Path2D)path).curveTo((double)x1 + (double)step * 2.0, (double)y1 + (double)(2 * height) * 2.0, (double)x1 + (double)step * 2.0, (double)y2 + (double)height * 0.5, (double)x2 - (double)step * 0.5, (double)y2 + (double)height * 0.5);
            ((Path2D)path).curveTo((double)x2 - (double)step * 0.125, (double)y2 + (double)height * 0.5, (double)x2 - (double)step * 0.125, (double)y2 + (double)height * 0.125, x2, y2);
        }
        g.setColor(DiffLineSeparatorRenderer.getWaveColor(scheme));
        g.setStroke(DiffLineSeparatorRenderer.getStroke(isHovered));
        g.draw(path);
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(3);
        }
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(4);
        }
        if (r == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(5);
        }
        if (!this.myPresentation.isVisible()) {
            return;
        }
        boolean isHovered = this.myPresentation.isHovered();
        int y = r.y;
        int lineHeight = this.myEditor.getLineHeight();
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int annotationsOffset = gutter.getAnnotationsAreaOffset();
        int annotationsWidth = gutter.getAnnotationsAreaWidth();
        if (annotationsWidth != 0) {
            g.setColor(editor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND));
            g.fillRect(annotationsOffset, y, annotationsWidth, lineHeight);
        }
        boolean isMirrored = DiffUtil.isMirrored(this.myEditor);
        int shiftX = DiffLineSeparatorRenderer.getStartPhase(lineHeight, isMirrored);
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, isHovered, this.myEditor.getColorsScheme());
    }

    public boolean canDoAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(6);
        }
        if (e == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(7);
        }
        return this.myPresentation.isVisible() && this.myPresentation.isHovered();
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(8);
        }
        if (e == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(9);
        }
        this.myPresentation.setExpanded(true);
    }

    @NotNull
    public String getAccessibleName() {
        String string = DiffBundle.message((String)"diff.unchanged.lines.folding.marker.renderer", (Object[])new Object[0]);
        if (string == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void drawLine(Graphics g, int x1, int x2, int y) {
        String description;
        if (!this.myPresentation.isVisible()) {
            return;
        }
        boolean isHovered = this.myPresentation.isHovered();
        ++y;
        int gutterWidth = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        int interval = DiffLineSeparatorRenderer.getStepSize(lineHeight) * 4;
        JScrollPane pane = ((EditorEx)this.myEditor).getScrollPane();
        boolean isMirrored = DiffUtil.isMirrored(this.myEditor);
        int shiftX = -interval;
        if (isMirrored) {
            int contentWidth = pane.getViewport().getWidth();
            shiftX += contentWidth % interval - interval;
            shiftX += gutterWidth % interval - interval;
            shiftX -= DiffLineSeparatorRenderer.getStartPhase(lineHeight, isMirrored);
        } else {
            shiftX += -gutterWidth % interval - interval;
            shiftX += DiffLineSeparatorRenderer.getStartPhase(lineHeight, isMirrored);
        }
        shiftX += pane.getHorizontalScrollBar().getValue();
        String string = description = this.myEditor instanceof EditorImpl ? this.myPresentation.getDescription() : null;
        if (description != null) {
            DiffLineSeparatorRenderer.drawWithDescription((Graphics2D)g, x1, y, shiftX, lineHeight, isHovered, (EditorImpl)this.myEditor, description);
        } else {
            DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, isHovered, this.myEditor.getColorsScheme());
        }
    }

    private static void drawWithDescription(Graphics2D g, int x, int y, int shiftX, int lineHeight, boolean isHovered, @NotNull EditorImpl editor, @NotNull String description) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(11);
        }
        if (description == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(12);
        }
        EditorColorsScheme scheme = editor.getColorsScheme();
        int rectX = x + JBUIScale.scale((int)5);
        int rectWidth = HintRenderer.calcWidthInPixels((Editor)editor, (String)description, null);
        Shape oldClip = g.getClip();
        g.clip(new Rectangle(0, 0, rectX, Integer.MAX_VALUE));
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, isHovered, editor.getColorsScheme());
        g.setClip(oldClip);
        g.clip(new Rectangle(rectX + rectWidth, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, isHovered, editor.getColorsScheme());
        g.setClip(oldClip);
        HintRenderer.paintHint((Graphics)g, (EditorImpl)editor, (Rectangle)new Rectangle(rectX, y, rectWidth, lineHeight), (String)description, (TextAttributes)scheme.getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT), (TextAttributes)scheme.getAttributes(HighlighterColors.TEXT), null);
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
        if (position == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(13);
        }
        return position;
    }

    private static void draw(@NotNull Graphics g, int shiftX, int shiftY, int lineHeight, boolean isHovered, @NotNull EditorColorsScheme scheme) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(14);
        }
        if (scheme == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(15);
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        Color color = DiffLineSeparatorRenderer.getWaveColor(scheme);
        Rectangle clip = g.getClipBounds();
        if (clip.width <= 0) {
            return;
        }
        int startX = clip.x - shiftX;
        int endX = startX + clip.width;
        int startIndex = startX / step - 4;
        int endIndex = endX / step + 1;
        Graphics2D gg = (Graphics2D)g.create();
        gg.translate(shiftX, shiftY + DiffLineSeparatorRenderer.getVerticalOffset(lineHeight));
        BufferedImage image = DiffLineSeparatorRenderer.createImage(gg, color, isHovered, step, height);
        gg.setComposite(AlphaComposite.SrcOver);
        for (int index = startIndex; index < endIndex; ++index) {
            if (index % 4 != 0) continue;
            UIUtil.drawImage((Graphics)gg, (Image)image, (int)(index * step), (int)0, null);
        }
        gg.dispose();
    }

    @NotNull
    private static BufferedImage createImage(@NotNull Graphics2D g, @NotNull Color color, boolean isHovered, int step, int height) {
        Object[] key;
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(16);
        }
        if (color == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(17);
        }
        if (Arrays.equals(ourCachedImageKey, key = new Object[]{color.getRGB(), Float.valueOf(JBUIScale.sysScale((Graphics2D)g)), isHovered, step, height}) && outCachedImage != null) {
            BufferedImage bufferedImage = outCachedImage;
            if (bufferedImage == null) {
                DiffLineSeparatorRenderer.$$$reportNull$$$0(18);
            }
            return bufferedImage;
        }
        int extraGap = DiffLineSeparatorRenderer.getAAGap();
        int imageWidth = step * 4;
        int imageHeight = height * 2 + extraGap * 2;
        BufferedImage image = ImageUtil.createImage((Graphics)g, (int)imageWidth, (int)imageHeight, (int)2);
        Graphics2D gg = image.createGraphics();
        double upper = extraGap;
        double center = height + extraGap;
        double lower = height * 2 + extraGap;
        double dx = (double)step / 2.0;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(0.0, upper);
        ((Path2D)path).quadTo((double)step * 1.0 - dx, upper, (double)step * 1.0, center);
        ((Path2D)path).quadTo((double)step * 2.0 - dx, lower, (double)step * 2.0, lower);
        ((Path2D)path).quadTo((double)step * 3.0 - dx, lower, (double)step * 3.0, center);
        ((Path2D)path).quadTo((double)step * 4.0 - dx, upper, (double)step * 4.0, upper);
        GraphicsUtil.setupAAPainting((Graphics)gg);
        gg.setStroke(DiffLineSeparatorRenderer.getStroke(isHovered));
        gg.setColor(color);
        gg.draw(path);
        outCachedImage = image;
        ourCachedImageKey = key;
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(19);
        }
        return bufferedImage;
    }

    private static int getStepSize(int lineHeight) {
        return Math.max(JBUIScale.scale((int)Registry.intValue((String)"diff.divider.width")) / 6, 2);
    }

    private static int getHeight(int lineHeight) {
        return JBUI.scale((int)3);
    }

    private static int getVerticalOffset(int lineHeight) {
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        return (lineHeight - 2 * height - 2 * DiffLineSeparatorRenderer.getAAGap()) / 2;
    }

    private static int getStartPhase(int lineHeight, boolean isMirror) {
        return DiffLineSeparatorRenderer.getStepSize(lineHeight);
    }

    private static int getAAGap() {
        return 1;
    }

    @NotNull
    private static Color getWaveColor(@Nullable EditorColorsScheme scheme) {
        Color color;
        if (scheme == null) {
            scheme = EditorColorsManager.getInstance().getGlobalScheme();
        }
        if ((color = scheme.getColor(FOREGROUND)) != null) {
            Color color2 = color;
            if (color2 == null) {
                DiffLineSeparatorRenderer.$$$reportNull$$$0(20);
            }
            return color2;
        }
        color = scheme.getColor(BACKGROUND);
        if (color != null) {
            Color color3 = color;
            if (color3 == null) {
                DiffLineSeparatorRenderer.$$$reportNull$$$0(21);
            }
            return color3;
        }
        Gray gray = Gray._128;
        if (gray == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(22);
        }
        return gray;
    }

    private static Stroke getStroke(boolean isHovered) {
        if (isHovered) {
            return new BasicStroke(2.0f);
        }
        return new BasicStroke(1.0f);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 4: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getWaveColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "drawConnectorLine";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "drawWithDescription";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13, 18, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }

    public static interface SeparatorPresentation {
        public boolean isVisible();

        public boolean isHovered();

        @Nullable
        public String getDescription();

        public void setExpanded(boolean var1);
    }
}

