/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.DefaultLineFlags;
import com.intellij.openapi.diff.LineStatusMarkerColorScheme;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ex.ChangedLines;
import com.intellij.openapi.vcs.ex.ChangesBlock;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.VisibleRangeMerger;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IntPair;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LineStatusMarkerDrawUtil {
    @NotNull
    public static List<Range> getSelectedRanges(@NotNull List<? extends Range> ranges, @NotNull Editor editor, int y) {
        if (ranges == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(1);
        }
        int lineHeight = editor.getLineHeight();
        int triangleGap = LineStatusMarkerDrawUtil.getTriangleAimGap(editor);
        Rectangle clip = new Rectangle(0, y - lineHeight, editor.getComponent().getWidth(), lineHeight * 2);
        List<ChangesBlock<Unit>> blocks = VisibleRangeMerger.merge(editor, ranges, clip);
        ArrayList<Range> result = new ArrayList<Range>();
        for (ChangesBlock<Unit> block : blocks) {
            if (!LineStatusMarkerDrawUtil.isBlockUnderY(block, y, triangleGap)) continue;
            result.addAll(block.ranges);
        }
        ArrayList<Range> arrayList = result;
        if (arrayList == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isBlockUnderY(ChangesBlock<?> block, int y, int triangleGap) {
        if (y == -1) {
            return false;
        }
        ChangedLines firstChange = block.changes.get(0);
        ChangedLines lastChange = block.changes.get(block.changes.size() - 1);
        int startY = firstChange.y1;
        int endY = lastChange.y2;
        if (firstChange.y1 == firstChange.y2) {
            startY -= triangleGap;
        }
        if (lastChange.y1 == lastChange.y2) {
            endY += triangleGap;
        }
        return startY <= y && endY > y;
    }

    public static Rectangle calcBounds(@NotNull List<? extends Range> ranges, @NotNull Editor editor, int lineNum) {
        int yStart;
        Rectangle clip;
        List<ChangesBlock<Unit>> blocks;
        if (ranges == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(4);
        }
        if ((blocks = VisibleRangeMerger.merge(editor, ranges, clip = new Rectangle(0, yStart = editor.visualLineToY(lineNum), 0, editor.getLineHeight()))).isEmpty()) {
            return null;
        }
        List changes = blocks.get((int)0).changes;
        int y = changes.get((int)0).y1;
        int endY = changes.get((int)(changes.size() - 1)).y2;
        if (y == endY) {
            endY += editor.getLineHeight();
        }
        IntPair area = LineStatusMarkerDrawUtil.getGutterArea(editor);
        return new Rectangle(area.first, y, area.second - area.first, endY - y);
    }

    public static void paintDefault(@NotNull Editor editor, @NotNull Graphics g, @NotNull List<? extends Range> ranges, @NotNull VisibleRangeMerger.FlagsProvider<DefaultLineFlags> flagsProvider, int framingBorder) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(5);
        }
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(6);
        }
        if (ranges == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(7);
        }
        if (flagsProvider == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(8);
        }
        LineStatusMarkerDrawUtil.paintDefault(editor, g, ranges, flagsProvider, LineStatusMarkerColorScheme.DEFAULT, framingBorder);
    }

    public static void paintDefault(@NotNull Editor editor, @NotNull Graphics g, @NotNull List<? extends Range> ranges, @NotNull VisibleRangeMerger.FlagsProvider<DefaultLineFlags> flagsProvider, @NotNull LineStatusMarkerColorScheme colorScheme, int framingBorder) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(9);
        }
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(10);
        }
        if (ranges == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(11);
        }
        if (flagsProvider == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(12);
        }
        if (colorScheme == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(13);
        }
        List<ChangesBlock<DefaultLineFlags>> blocks = VisibleRangeMerger.merge(editor, ranges, flagsProvider, g.getClipBounds());
        EditorGutterComponentEx gutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
        GroupedBlocks groupedBlocks = LineStatusMarkerDrawUtil.groupBlocks(editor, gutterComponentEx, blocks);
        for (ChangesBlock<DefaultLineFlags> block : groupedBlocks.unhoveredBlocks()) {
            LineStatusMarkerDrawUtil.paintChangedLines((Graphics2D)g, editor, block.changes, colorScheme, framingBorder, false);
        }
        for (ChangesBlock<DefaultLineFlags> block : groupedBlocks.hoveredBlocks()) {
            LineStatusMarkerDrawUtil.paintChangedLines((Graphics2D)g, editor, block.changes, colorScheme, framingBorder, true);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static GroupedBlocks groupBlocks(@NotNull Editor editor, EditorGutterComponentEx gutterComponentEx, List<ChangesBlock<DefaultLineFlags>> blocks) {
        GroupedBlocks groupedBlocks;
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(14);
        }
        ArrayList<ChangesBlock<DefaultLineFlags>> hoveredBlocks = new ArrayList<ChangesBlock<DefaultLineFlags>>();
        ArrayList<ChangesBlock<DefaultLineFlags>> unhoveredBlocks = new ArrayList<ChangesBlock<DefaultLineFlags>>();
        int triangleGap = LineStatusMarkerDrawUtil.getTriangleAimGap(editor);
        int y = gutterComponentEx.getHoveredFreeMarkersY();
        for (ChangesBlock<DefaultLineFlags> block : blocks) {
            if (LineStatusMarkerDrawUtil.isBlockUnderY(block, y, triangleGap)) {
                hoveredBlocks.add(block);
                continue;
            }
            unhoveredBlocks.add(block);
        }
        GroupedBlocks groupedBlocks2 = groupedBlocks = new GroupedBlocks(hoveredBlocks, unhoveredBlocks);
        if (groupedBlocks2 == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(15);
        }
        return groupedBlocks2;
    }

    public static void paintChangedLines(@NotNull Graphics2D g, @NotNull Editor editor, @NotNull List<? extends ChangedLines<DefaultLineFlags>> block, int framingBorder, boolean isHovered) {
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(17);
        }
        if (block == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(18);
        }
        LineStatusMarkerDrawUtil.paintChangedLines(g, editor, block, LineStatusMarkerColorScheme.DEFAULT, framingBorder, isHovered);
    }

    public static void paintChangedLines(@NotNull Graphics2D g, @NotNull Editor editor, @NotNull List<? extends ChangedLines<DefaultLineFlags>> block, @NotNull LineStatusMarkerColorScheme colorScheme, int framingBorder, boolean isHovered) {
        int end;
        int start;
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(20);
        }
        if (block == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(21);
        }
        if (colorScheme == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(22);
        }
        Color borderColor = LineStatusMarkerColorScheme.DEFAULT.getBorderColor(editor);
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Color gutterBackgroundColor = gutter.getBackground();
        IntPair area = LineStatusMarkerDrawUtil.getGutterArea(editor);
        int x = area.first;
        int endX = area.second;
        int y = block.get((int)0).y1;
        int endY = block.get((int)(block.size() - 1)).y2;
        if (framingBorder > 0 && y != endY) {
            g.setColor(gutterBackgroundColor);
            g.fillRect(x - framingBorder, y - framingBorder, endX - x + framingBorder, endY - y + framingBorder * 2);
        }
        for (ChangedLines<DefaultLineFlags> changedLines : block) {
            if (changedLines.y1 == changedLines.y2 || ((DefaultLineFlags)changedLines.flags).isIgnored) continue;
            start = changedLines.y1;
            end = changedLines.y2;
            Color gutterColor = colorScheme.getColor(editor, changedLines.type);
            int x1 = isHovered ? x - LineStatusMarkerDrawUtil.getHoveredMarkerExtraWidth() : x;
            LineStatusMarkerDrawUtil.paintRect(g, gutterColor, null, x1, start, endX, end);
        }
        if (borderColor == null) {
            for (ChangedLines<DefaultLineFlags> changedLines : block) {
                if (changedLines.y1 == changedLines.y2 || !((DefaultLineFlags)changedLines.flags).isIgnored) continue;
                start = changedLines.y1;
                end = changedLines.y2;
                Color ignoredBorderColor = colorScheme.getIgnoredBorderColor(editor, changedLines.type);
                LineStatusMarkerDrawUtil.paintRect(g, null, ignoredBorderColor, x, start, endX, end);
            }
        } else if (y != endY) {
            LineStatusMarkerDrawUtil.paintRect(g, null, borderColor, x, y, endX, endY);
        }
        for (ChangedLines<DefaultLineFlags> changedLines : block) {
            if (changedLines.y1 != changedLines.y2) continue;
            start = changedLines.y1;
            if (!((DefaultLineFlags)changedLines.flags).isIgnored) {
                Color gutterColor = colorScheme.getColor(editor, changedLines.type);
                int x1 = isHovered ? x - LineStatusMarkerDrawUtil.getHoveredMarkerExtraWidth() : x;
                LineStatusMarkerDrawUtil.paintTriangle(g, editor, gutterColor, borderColor, x1, endX, start);
                continue;
            }
            Color ignoredBorderColor = borderColor != null ? borderColor : colorScheme.getIgnoredBorderColor(editor, changedLines.type);
            LineStatusMarkerDrawUtil.paintTriangle(g, editor, null, ignoredBorderColor, x, endX, start);
        }
    }

    public static boolean isRangeHovered(@NotNull Editor editor, int line, int x, int start, int end) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(23);
        }
        return line != -1 && editor.xyToLogicalPosition((Point)new Point((int)x, (int)start)).line <= line && line < editor.xyToLogicalPosition((Point)new Point((int)x, (int)end)).line;
    }

    public static void paintRange(@NotNull Graphics g, @NotNull Editor editor, @NotNull Range range, int framingBorder, boolean isIgnored) {
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(25);
        }
        if (range == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(26);
        }
        VisibleRangeMerger.FlagsProvider<DefaultLineFlags> flagsProvider = isIgnored ? DefaultFlagsProvider.ALL_IGNORED : DefaultFlagsProvider.DEFAULT;
        List<ChangesBlock<DefaultLineFlags>> blocks = VisibleRangeMerger.merge(editor, Collections.singletonList(range), flagsProvider, g.getClipBounds());
        for (ChangesBlock<DefaultLineFlags> block : blocks) {
            LineStatusMarkerDrawUtil.paintChangedLines((Graphics2D)g, editor, block.changes, framingBorder, false);
        }
    }

    public static void paintSimpleRange(@NotNull Graphics g, @NotNull Editor editor, int line1, int line2, @Nullable Color color) {
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(27);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(28);
        }
        IntPair horizontalArea = LineStatusMarkerDrawUtil.getGutterArea(editor);
        int x = horizontalArea.first;
        int endX = horizontalArea.second;
        int y = DiffDrawUtil.lineToY(editor, line1);
        int endY = DiffDrawUtil.lineToY(editor, line2);
        Color borderColor = LineStatusMarkerColorScheme.DEFAULT.getBorderColor(editor);
        if (endY != y) {
            LineStatusMarkerDrawUtil.paintRect((Graphics2D)g, color, borderColor, x, y, endX, endY);
        } else {
            LineStatusMarkerDrawUtil.paintTriangle((Graphics2D)g, editor, color, borderColor, x, endX, y);
        }
    }

    @NotNull
    public static IntPair getGutterArea(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(29);
        }
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        if (ExperimentalUI.isNewUI()) {
            int x = gutter.getExtraLineMarkerFreePaintersAreaOffset();
            int width = Registry.intValue((String)"gutter.vcs.changes.width", (int)4, (int)4, (int)6);
            x += JBUI.scale((int)1);
            if (width < 5) {
                x += JBUI.scale((int)2);
            }
            int areaWidth = LineStatusMarkerDrawUtil.scaleWithEditor(JBUIScale.scale((int)JBUI.getInt((String)"Gutter.VcsChanges.width", (int)width)), editor);
            return new IntPair(x, x + areaWidth);
        }
        int x = gutter.getLineMarkerFreePaintersAreaOffset();
        int endX = gutter.getWhitespaceSeparatorOffset();
        return new IntPair(++x, endX);
    }

    public static boolean isInsideMarkerArea(@NotNull MouseEvent e) {
        if (e == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(30);
        }
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
        return gutter.isInsideMarkerArea(e);
    }

    public static void paintRect(@NotNull Graphics2D g, @Nullable Color color, @Nullable Color borderColor, int x1, int y1, int x2, int y2) {
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(31);
        }
        if (ExperimentalUI.isNewUI()) {
            if (color != null) {
                g.setColor(color);
                double width = x2 - x1;
                RectanglePainter2D.FILL.paint(g, (double)x1, (double)(y1 + 1), width, (double)(y2 - y1 - 2), (Object)width);
            } else if (borderColor != null) {
                g.setColor(borderColor);
                double width = x2 - x1;
                RectanglePainter2D.DRAW.paint(g, (double)x1, (double)(y1 + 1), width, (double)(y2 - y1 - 2), (Object)width);
            }
            return;
        }
        if (color != null) {
            g.setColor(color);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        if (borderColor != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUIScale.scale((int)1)));
            g.setColor(borderColor);
            LinePainter2D.paint((Graphics2D)g, (double)x1, (double)y1, (double)(x2 - 1), (double)y1);
            LinePainter2D.paint((Graphics2D)g, (double)x1, (double)y1, (double)x1, (double)(y2 - 1));
            LinePainter2D.paint((Graphics2D)g, (double)x1, (double)(y2 - 1), (double)(x2 - 1), (double)(y2 - 1));
            g.setStroke(oldStroke);
        }
    }

    public static void paintTriangle(@NotNull Graphics2D g, @NotNull Editor editor, @Nullable Color color, @Nullable Color borderColor, int x1, int x2, int y) {
        int size;
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(32);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(33);
        }
        if (y < (size = LineStatusMarkerDrawUtil.getTriangleHeight(editor))) {
            y = size;
        }
        if (ExperimentalUI.isNewUI()) {
            if (color != null) {
                g.setColor(color);
                double width = x2 - x1;
                RectanglePainter2D.FILL.paint(g, (double)x1, (double)(y - size + 1), width, (double)(2 * size - 2), (Object)width);
            } else if (borderColor != null) {
                g.setColor(borderColor);
                double width = x2 - x1;
                RectanglePainter2D.DRAW.paint(g, (double)x1, (double)(y - size + 1), width, (double)(2 * size - 2), (Object)width);
            }
            return;
        }
        int[] xPoints = new int[]{x1, x1, x2};
        int[] yPoints = new int[]{y - size, y + size, y};
        if (color != null) {
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUIScale.scale((int)1)));
            g.setColor(borderColor);
            g.drawPolygon(xPoints, yPoints, xPoints.length);
            g.setStroke(oldStroke);
        }
    }

    private static int getTriangleHeight(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(34);
        }
        int unscaled = ExperimentalUI.isNewUI() ? 5 : 4;
        return LineStatusMarkerDrawUtil.scaleWithEditor(unscaled, editor);
    }

    private static int getTriangleAimGap(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(35);
        }
        return editor.getLineHeight() / 3;
    }

    private static int getHoveredMarkerExtraWidth() {
        return JBUI.scale((int)3);
    }

    private static int scaleWithEditor(float v, @NotNull Editor editor) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(36);
        }
        float scale = editor instanceof EditorImpl ? ((EditorImpl)editor).getScale() : 1.0f;
        return PaintUtil.RoundingMode.ROUND.round((double)(v * scale));
    }

    @Nullable
    public static Color getErrorStripeColor(byte type) {
        return LineStatusMarkerColorScheme.DEFAULT.getErrorStripeColor(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/LineStatusMarkerDrawUtil";
                break;
            }
            case 6: 
            case 10: 
            case 16: 
            case 19: 
            case 24: 
            case 27: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagsProvider";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorScheme";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/LineStatusMarkerDrawUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRanges";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRanges";
                break;
            }
            case 2: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcBounds";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paintDefault";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "groupBlocks";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "paintChangedLines";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRangeHovered";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "paintRange";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "paintSimpleRange";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getGutterArea";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMarkerArea";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "paintRect";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "paintTriangle";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTriangleHeight";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTriangleAimGap";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "scaleWithEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 15 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public record GroupedBlocks(List<ChangesBlock<DefaultLineFlags>> hoveredBlocks, List<ChangesBlock<DefaultLineFlags>> unhoveredBlocks) {
    }

    public static class DiffStripeTextAttributes
    extends TextAttributes {
        private final byte myType;

        public DiffStripeTextAttributes(byte type) {
            this.myType = type;
        }

        public byte getType() {
            return this.myType;
        }

        public Color getErrorStripeColor() {
            return LineStatusMarkerDrawUtil.getErrorStripeColor(this.myType);
        }
    }
}

