/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.ISerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u0014\u0010\"\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/ISerializableProperty;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "hasBackingField", "", "declaresDefaultValue", "<init>", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;ZZ)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "name", "", "getName", "()Ljava/lang/String;", "originalDescriptorName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalDescriptorName", "()Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "genericIndex", "", "getGenericIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "serializableWith", "getSerializableWith", "optional", "getOptional", "()Z", "transient", "getTransient", "kotlinx-serialization-compiler-plugin.k1"})
public final class SerializableProperty
implements ISerializableProperty {
    @NotNull
    private final PropertyDescriptor descriptor;
    @NotNull
    private final String name;
    @NotNull
    private final Name originalDescriptorName;
    @NotNull
    private final KotlinType type;
    @Nullable
    private final Integer genericIndex;
    @NotNull
    private final ModuleDescriptor module;
    @Nullable
    private final KotlinType serializableWith;
    private final boolean optional;
    private final boolean transient;

    public SerializableProperty(@NotNull PropertyDescriptor descriptor, boolean hasBackingField, boolean declaresDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        String string = KSerializationUtilKt.getSerialNameValue(this.descriptor.getAnnotations());
        if (string == null) {
            String string2 = this.descriptor.getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        this.name = string;
        Name name = this.descriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        this.originalDescriptorName = name;
        KotlinType kotlinType = this.descriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.type = kotlinType;
        this.genericIndex = KSerializationUtilKt.getGenericIndex(this.type);
        this.module = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.descriptor));
        KotlinType kotlinType2 = KSerializationUtilKt.getSerializableWith((DeclarationDescriptor)this.descriptor);
        if (kotlinType2 == null) {
            ClassDescriptor classDescriptor = TypeUtilKt.analyzeSpecialSerializers(this.module, this.descriptor.getAnnotations());
            kotlinType2 = (KotlinType)(classDescriptor != null ? classDescriptor.getDefaultType() : null);
        }
        this.serializableWith = kotlinType2;
        this.optional = !KSerializationUtilKt.getSerialRequired(this.descriptor.getAnnotations()) && declaresDefaultValue;
        this.transient = KSerializationUtilKt.getSerialTransient(this.descriptor.getAnnotations()) || !hasBackingField;
    }

    @NotNull
    public final PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Name getOriginalDescriptorName() {
        return this.originalDescriptorName;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @Nullable
    public final Integer getGenericIndex() {
        return this.genericIndex;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        return this.module;
    }

    @Nullable
    public final KotlinType getSerializableWith() {
        return this.serializableWith;
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public boolean getTransient() {
        return this.transient;
    }
}

