/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.local;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.BaseTargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.value.TargetValue;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalTargetEnvironmentRequest
extends BaseTargetEnvironmentRequest {
    private static int nextSyntheticId = 0;
    private TargetEnvironmentRequest.Volume myDefaultVolume;
    private final Map<String, LocalUploadVolume> myUploadRoots;
    @NotNull
    private GeneralCommandLine.ParentEnvironmentType myParentEnvironmentType;

    public LocalTargetEnvironmentRequest() {
        this.myUploadRoots = new LinkedHashMap<String, LocalUploadVolume>();
        this.myParentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.CONSOLE;
    }

    private LocalTargetEnvironmentRequest(@NotNull Set<TargetEnvironment.UploadRoot> uploadVolumes, @NotNull Set<TargetEnvironment.DownloadRoot> downloadVolumes, @NotNull Set<TargetEnvironment.TargetPortBinding> targetPortBindings, @NotNull Set<TargetEnvironment.LocalPortBinding> localPortBindings) {
        if (uploadVolumes == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(0);
        }
        if (downloadVolumes == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(1);
        }
        if (targetPortBindings == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(2);
        }
        if (localPortBindings == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(3);
        }
        super(uploadVolumes, downloadVolumes, targetPortBindings, localPortBindings);
        this.myUploadRoots = new LinkedHashMap<String, LocalUploadVolume>();
        this.myParentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.CONSOLE;
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest duplicate() {
        return new LocalTargetEnvironmentRequest(new HashSet<TargetEnvironment.UploadRoot>(this.getUploadVolumes()), new HashSet<TargetEnvironment.DownloadRoot>(this.getDownloadVolumes()), new HashSet<TargetEnvironment.TargetPortBinding>(this.getTargetPortBindings()), new HashSet<TargetEnvironment.LocalPortBinding>(this.getLocalPortBindings()));
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = TargetPlatform.CURRENT;
        if (targetPlatform == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(4);
        }
        return targetPlatform;
    }

    @Override
    @Nullable
    public TargetEnvironmentConfiguration getConfiguration() {
        return null;
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest.Volume getDefaultVolume() {
        if (this.myDefaultVolume == null) {
            this.myDefaultVolume = this.createTempVolume();
        }
        TargetEnvironmentRequest.Volume volume = this.myDefaultVolume;
        if (volume == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(5);
        }
        return volume;
    }

    @NotNull
    private TargetEnvironmentRequest.Volume createTempVolume() {
        String id = LocalTargetEnvironmentRequest.nextSyntheticId();
        TargetEnvironmentRequest.Volume volume = this.myUploadRoots.computeIfAbsent(id, path -> new LocalUploadVolume(this, id));
        if (volume == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(6);
        }
        return volume;
    }

    @Override
    @NotNull
    public LocalTargetEnvironment prepareEnvironment(@NotNull TargetProgressIndicator progressIndicator) throws ExecutionException {
        if (progressIndicator == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(7);
        }
        LocalTargetEnvironment environment = new LocalTargetEnvironment(this);
        this.environmentPrepared(environment, progressIndicator);
        LocalTargetEnvironment localTargetEnvironment = environment;
        if (localTargetEnvironment == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(8);
        }
        return localTargetEnvironment;
    }

    @NotNull
    GeneralCommandLine.ParentEnvironmentType getParentEnvironmentType() {
        GeneralCommandLine.ParentEnvironmentType parentEnvironmentType = this.myParentEnvironmentType;
        if (parentEnvironmentType == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(9);
        }
        return parentEnvironmentType;
    }

    private static String nextSyntheticId() {
        return LocalTargetEnvironmentRequest.class.getSimpleName() + ":volume:" + nextSyntheticId++;
    }

    public void setParentEnvironmentType(@NotNull GeneralCommandLine.ParentEnvironmentType parentEnvironmentType) {
        if (parentEnvironmentType == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(10);
        }
        this.myParentEnvironmentType = parentEnvironmentType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadVolumes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadVolumes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPortBindings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPortBindings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVolume";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVolume";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setParentEnvironmentType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class LocalUploadVolume
    implements TargetEnvironmentRequest.Volume {
        private final LocalTargetEnvironmentRequest myRequest;
        private final String myVolumeId;

        LocalUploadVolume(@NotNull LocalTargetEnvironmentRequest request, @NotNull String volumeId) {
            if (request == null) {
                LocalUploadVolume.$$$reportNull$$$0(0);
            }
            if (volumeId == null) {
                LocalUploadVolume.$$$reportNull$$$0(1);
            }
            this.myRequest = request;
            this.myVolumeId = volumeId;
        }

        @Override
        @NotNull
        public String getVolumeId() {
            String string = this.myVolumeId;
            if (string == null) {
                LocalUploadVolume.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Platform getPlatform() {
            Platform platform = this.myRequest.getTargetPlatform().getPlatform();
            if (platform == null) {
                LocalUploadVolume.$$$reportNull$$$0(3);
            }
            return platform;
        }

        @Override
        @NotNull
        public TargetValue<String> createUpload(@NotNull String localPath) {
            if (localPath == null) {
                LocalUploadVolume.$$$reportNull$$$0(4);
            }
            TargetValue<String> targetValue = TargetValue.fixed(localPath);
            if (targetValue == null) {
                LocalUploadVolume.$$$reportNull$$$0(5);
            }
            return targetValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volumeId";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest$LocalUploadVolume";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest$LocalUploadVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVolumeId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlatform";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUpload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createUpload";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

