/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.TestStatusListener;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppIcon;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.config.AbstractProperty;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestsUIUtil {
    @NonNls
    private static final String TESTS = "tests";

    @NotNull
    public static NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Test Runner");
        if (notificationGroup == null) {
            TestsUIUtil.$$$reportNull$$$0(0);
        }
        return notificationGroup;
    }

    private TestsUIUtil() {
    }

    public static boolean isMultipleSelectionImpossible(DataContext dataContext) {
        Component component = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (component instanceof JTree) {
            Object lastPathComponent;
            TreePath[] selectionPaths = ((JTree)component).getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length == 0) {
                return true;
            }
            return selectionPaths.length == 1 && (lastPathComponent = selectionPaths[0].getLastPathComponent()) instanceof TreeNode && ((TreeNode)lastPathComponent).isLeaf();
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        return editor != null && !editor.getSelectionModel().hasSelection() && editor.getCaretModel().getCaretCount() < 2;
    }

    public static Navigatable getOpenFileDescriptor(AbstractTestProxy testProxy, TestFrameworkRunningModel model2) {
        return TestsUIUtil.getOpenFileDescriptor(testProxy, model2.getProperties());
    }

    public static Navigatable getOpenFileDescriptor(AbstractTestProxy testProxy, TestConsoleProperties testConsoleProperties) {
        return TestsUIUtil.getOpenFileDescriptor(testProxy, testConsoleProperties, TestConsoleProperties.OPEN_FAILURE_LINE.value((AbstractProperty.AbstractPropertyContainer)testConsoleProperties));
    }

    private static Navigatable getOpenFileDescriptor(AbstractTestProxy proxy, TestConsoleProperties testConsoleProperties, boolean openFailureLine) {
        Project project = testConsoleProperties.getProject();
        if (proxy != null) {
            Navigatable navigatable;
            Location location = proxy.getLocation(project, testConsoleProperties.getScope());
            if (openFailureLine) {
                return proxy.getDescriptor(location, testConsoleProperties);
            }
            Navigatable navigatable2 = navigatable = location == null ? null : location.getNavigatable();
            if (navigatable instanceof OpenFileDescriptor && ((OpenFileDescriptor)navigatable).getFile().isValid()) {
                return navigatable;
            }
            return navigatable;
        }
        return null;
    }

    public static void notifyByBalloon(@NotNull Project project, boolean started, AbstractTestProxy root, TestConsoleProperties properties, @NlsContexts.SystemNotificationText @Nullable String comment) {
        if (project == null) {
            TestsUIUtil.$$$reportNull$$$0(1);
        }
        TestsUIUtil.notifyByBalloon(project, root, properties, new TestResultPresentation(root, started, comment).getPresentation());
    }

    public static void notifyByBalloon(@NotNull Project project, AbstractTestProxy root, TestConsoleProperties properties, TestResultPresentation testResultPresentation) {
        if (project == null) {
            TestsUIUtil.$$$reportNull$$$0(2);
        }
        if (project.isDisposed()) {
            return;
        }
        if (properties == null) {
            return;
        }
        TestStatusListener.notifySuiteFinished(root, properties.getProject());
        String windowId = properties.getWindowId();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        String title = testResultPresentation.getTitle();
        String text2 = testResultPresentation.getText();
        String balloonText = testResultPresentation.getBalloonText();
        MessageType type = testResultPresentation.getType();
        ToolWindow toolWindow = toolWindowManager.getToolWindow(windowId);
        if (toolWindow != null && !toolWindow.isVisible()) {
            NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("Test Results");
            group.createNotification(balloonText, type).setToolWindowId(windowId).notify(project);
        }
        TestsUIUtil.getNotificationGroup().createNotification(balloonText, type).notify(project);
        SystemNotifications.getInstance().notify("TestRunner", title, text2);
    }

    @NlsContexts.NotificationContent
    public static String getTestSummary(AbstractTestProxy proxy) {
        return new TestResultPresentation(proxy).getPresentation().getBalloonText();
    }

    public static void showIconProgress(Project project, int n, int maximum, int problemsCounter, boolean updateWithAttention) {
        AppIcon icon = AppIcon.getInstance();
        if (n < maximum || !updateWithAttention) {
            if ((!updateWithAttention || icon.setProgress(project, (Object)TESTS, AppIconScheme.Progress.TESTS, (double)n / (double)maximum, problemsCounter == 0)) && problemsCounter > 0) {
                icon.setErrorBadge(project, String.valueOf(problemsCounter));
            }
        } else if (icon.hideProgress(project, (Object)TESTS)) {
            if (problemsCounter > 0) {
                icon.setErrorBadge(project, String.valueOf(problemsCounter));
            } else {
                icon.setOkBadge(project, true);
            }
            icon.requestAttention(project, false);
        }
    }

    public static void clearIconProgress(Project project) {
        AppIcon.getInstance().hideProgress(project, (Object)TESTS);
        AppIcon.getInstance().setErrorBadge(project, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/TestsUIUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/TestsUIUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyByBalloon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class TestResultPresentation {
        private final AbstractTestProxy myRoot;
        private final boolean myStarted;
        private final @NlsContexts.SystemNotificationText String myComment;
        private @NlsContexts.SystemNotificationTitle String myTitle;
        private @NlsContexts.SystemNotificationText String myText;
        private @NlsContexts.NotificationContent String myBalloonText;
        private MessageType myType;
        private int myFailedCount;
        private int myPassedCount;
        private int myNotStartedCount;
        private int myIgnoredCount;

        public TestResultPresentation(AbstractTestProxy root, boolean started, @NlsContexts.SystemNotificationText String comment) {
            this.myRoot = root;
            this.myStarted = started;
            this.myComment = comment;
        }

        public TestResultPresentation(AbstractTestProxy root) {
            this(root, true, null);
        }

        @NlsContexts.SystemNotificationTitle
        public String getTitle() {
            return this.myTitle;
        }

        @NlsContexts.SystemNotificationText
        public String getText() {
            return this.myText;
        }

        @NlsContexts.NotificationContent
        public String getBalloonText() {
            return this.myBalloonText;
        }

        public MessageType getType() {
            return this.myType;
        }

        @Deprecated
        public int getFailedCount() {
            return this.myFailedCount;
        }

        @Deprecated
        public int getPassedCount() {
            return this.myPassedCount;
        }

        @Deprecated
        public int getNotStartedCount() {
            return this.myNotStartedCount;
        }

        @Deprecated
        public int getIgnoredCount() {
            return this.myIgnoredCount;
        }

        public TestResultPresentation getPresentation() {
            List<? extends AbstractTestProxy> allTests = Filter.LEAF.select(this.myRoot.getAllTests());
            List<? extends AbstractTestProxy> failed = Filter.DEFECTIVE_LEAF.select(allTests);
            List<? extends AbstractTestProxy> notStarted = Filter.NOT_PASSED.select(allTests);
            notStarted.removeAll(failed);
            List<? extends AbstractTestProxy> ignored = Filter.IGNORED.select(allTests);
            notStarted.removeAll(ignored);
            failed.removeAll(ignored);
            int failedCount = failed.size();
            int notStartedCount = notStarted.size() + ignored.size();
            int passedCount = allTests.size() - failedCount - notStartedCount;
            return this.getPresentation(failedCount, passedCount, notStartedCount, ignored.size());
        }

        public TestResultPresentation getPresentation(int failedCount, int passedCount, int notStartedCount, int ignoredCount) {
            if (this.myRoot == null) {
                this.myTitle = this.myStarted ? TestRunnerBundle.message("test.interrupted.progress.text", new Object[0]) : ExecutionBundle.message("test.not.started.progress.text", new Object[0]);
                this.myBalloonText = this.myTitle;
                this.myText = "";
                this.myType = MessageType.WARNING;
            } else {
                this.myFailedCount = failedCount;
                this.myPassedCount = passedCount;
                this.myNotStartedCount = notStartedCount;
                this.myIgnoredCount = ignoredCount;
                if (failedCount > 0) {
                    this.myTitle = ExecutionBundle.message("junit.running.info.tests.failed.label", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("tests.failed.0.passed.1.ignored.2.not.started.3", failedCount, passedCount, ignoredCount, ignoredCount > 0 ? 0 : notStartedCount);
                    this.myText = this.myComment == null ? TestRunnerBundle.message("0.failed.1.passed.2.ignored.3.not.started", failedCount, passedCount, ignoredCount, ignoredCount > 0 ? 0 : notStartedCount) : TestRunnerBundle.message("0.failed.1.passed.2.ignored.3.not.started.with.comment", failedCount, passedCount, ignoredCount, ignoredCount > 0 ? 0 : notStartedCount, this.myComment);
                    this.myType = MessageType.ERROR;
                } else if (ignoredCount > 0) {
                    this.myTitle = TestRunnerBundle.message("tests.ignored.error.message", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("tests.ignored.0.passed.1", ignoredCount, passedCount);
                    this.myText = this.myComment == null ? TestRunnerBundle.message("0.ignored.1.passed", ignoredCount, passedCount) : TestRunnerBundle.message("0.ignored.1.passed.with.comment", ignoredCount, passedCount, this.myComment);
                    this.myType = MessageType.WARNING;
                } else if (notStartedCount > 0) {
                    this.myTitle = ExecutionBundle.message("junit.running.info.failed.to.start.error.message", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("failed.to.start.0.passed.1", notStartedCount, passedCount);
                    this.myText = this.myComment == null ? TestRunnerBundle.message("0.not.started.1.passed", notStartedCount, passedCount) : TestRunnerBundle.message("0.not.started.1.passed.with.comment", notStartedCount, passedCount, this.myComment);
                    this.myType = MessageType.ERROR;
                } else {
                    this.myTitle = ExecutionBundle.message("junit.running.info.tests.passed.label", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("tests.passed.0", passedCount);
                    this.myText = this.myComment == null ? TestRunnerBundle.message("0.passed", passedCount) : TestRunnerBundle.message("0.passed.with.comment", passedCount, this.myComment);
                    this.myType = MessageType.INFO;
                }
            }
            return this;
        }
    }
}

