/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.actions.TestDiffContent;
import com.intellij.execution.testframework.actions.TestDiffProvider;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestDiffRequestProcessor {
    @NotNull
    public static DiffRequestChain createRequestChain(@NotNull Project project, @NotNull ListSelection<? extends DiffHyperlink> requests) {
        if (project == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        if (requests == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        ListSelection producers = requests.map(hyperlink -> new DiffHyperlinkRequestProducer(project, (DiffHyperlink)hyperlink));
        SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducers((ListSelection)producers);
        chain.putUserData(DiffUserDataKeys.PLACE, (Object)"TestsFiledAssertions");
        chain.putUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, (Object)true);
        chain.putUserData(DiffUserDataKeys.DIALOG_GROUP_KEY, (Object)"#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
        SimpleDiffRequestChain simpleDiffRequestChain = chain;
        if (simpleDiffRequestChain == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return simpleDiffRequestChain;
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String path) {
        if (path == null) {
            return null;
        }
        JarFileSystem fs = path.contains("!/") ? JarFileSystem.getInstance() : LocalFileSystem.getInstance();
        return fs.refreshAndFindFileByPath(path);
    }

    @NotNull
    private static DiffContent createContentWithTitle(@Nullable Project project, @NotNull String content, @Nullable VirtualFile contentFile, @Nullable VirtualFile highlightFile) {
        if (content == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        if (contentFile != null) {
            DiffContent diffContent = DiffContentFactory.getInstance().create(project, contentFile);
            if (diffContent == null) {
                TestDiffRequestProcessor.$$$reportNull$$$0(4);
            }
            return diffContent;
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, content, highlightFile);
        if (documentContent == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestChain";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentWithTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRequestChain";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createContentWithTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class DiffHyperlinkRequestProducer
    implements DiffRequestProducer {
        private final Project myProject;
        private final DiffHyperlink myHyperlink;

        private DiffHyperlinkRequestProducer(@NotNull Project project, @NotNull DiffHyperlink hyperlink) {
            if (project == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(0);
            }
            if (hyperlink == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myHyperlink = hyperlink;
        }

        @Nls
        @NotNull
        public String getName() {
            String testName = this.myHyperlink.getTestName();
            if (testName != null) {
                String string = testName;
                if (string == null) {
                    DiffHyperlinkRequestProducer.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.myHyperlink.getDiffTitle();
            if (string == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public FileType getContentType() {
            VirtualFile file = TestDiffRequestProcessor.findFile(this.myHyperlink.getFilePath());
            return file != null ? file.getFileType() : PlainTextFileType.INSTANCE;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
            if (context == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(5);
            }
            VirtualFile file1 = TestDiffRequestProcessor.findFile(this.myHyperlink.getFilePath());
            VirtualFile file2 = TestDiffRequestProcessor.findFile(this.myHyperlink.getActualFilePath());
            DiffContent content = null;
            if (file1 == null && this.myHyperlink.getTestProxy() != null) {
                content = (DiffContent)ReadAction.nonBlocking(() -> {
                    TestDiffProvider provider = this.getTestDiffProvider(this.myHyperlink.getTestProxy());
                    ProgressManager.checkCanceled();
                    if (provider == null) {
                        return null;
                    }
                    String stackTrace = this.myHyperlink.getTestProxy().getStacktrace();
                    if (stackTrace == null) {
                        return null;
                    }
                    PsiElement expected = provider.findExpected(this.myProject, stackTrace, this.myHyperlink.getLeft());
                    ProgressManager.checkCanceled();
                    if (expected == null) {
                        return null;
                    }
                    return TestDiffContent.create(this.myProject, this.myHyperlink.getLeft(), (SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)expected));
                }).executeSynchronously();
            }
            if (content instanceof DocumentContent) {
                DocumentContent documentContent = (DocumentContent)content;
                file1 = documentContent.getHighlightFile();
            }
            if (content == null) {
                content = TestDiffRequestProcessor.createContentWithTitle(this.myProject, this.myHyperlink.getLeft(), file1, file2);
            }
            DiffContent content2 = TestDiffRequestProcessor.createContentWithTitle(this.myProject, this.myHyperlink.getRight(), file2, file1);
            String title1 = file1 != null ? ExecutionBundle.message("diff.content.expected.title.with.file.url", file1.getPresentableUrl()) : ExecutionBundle.message("diff.content.expected.title", new Object[0]);
            String title2 = file2 != null ? ExecutionBundle.message("diff.content.actual.title.with.file.url", file2.getPresentableUrl()) : ExecutionBundle.message("diff.content.actual.title", new Object[0]);
            return new SimpleDiffRequest(this.myHyperlink.getDiffTitle(), content, content2, title1, title2);
        }

        @Nullable
        private TestDiffProvider getTestDiffProvider(@NotNull AbstractTestProxy testProxy) {
            TestProxyRoot testRoot;
            if (testProxy == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(6);
            }
            if ((testRoot = AbstractTestProxy.getTestRoot(testProxy)) == null) {
                return null;
            }
            Location loc = testProxy.getLocation(this.myProject, testRoot.getTestConsoleProperties().getScope());
            if (loc == null) {
                return null;
            }
            return TestDiffProvider.getProviderByLanguage(loc.getPsiElement().getLanguage());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffHyperlinkRequestProducer producer = (DiffHyperlinkRequestProducer)o;
            return Objects.equals(this.myHyperlink, producer.myHyperlink);
        }

        public int hashCode() {
            return Objects.hash(this.myHyperlink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor$DiffHyperlinkRequestProducer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testProxy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor$DiffHyperlinkRequestProducer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTestDiffProvider";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

