/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsDialog;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.AttachmentFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PathUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.xml.sax.SAXException;

public final class ExportTestResultsAction
extends DumbAwareAction {
    private static final String ID = "ExportTestResults";
    private static final Logger LOG = Logger.getInstance((String)ExportTestResultsAction.class.getName());
    private TestFrameworkRunningModel myModel;
    private String myToolWindowId;
    private RunConfiguration myRunConfiguration;

    public static ExportTestResultsAction create(String toolWindowId, RunConfiguration runtimeConfiguration, JComponent component) {
        ExportTestResultsAction action = new ExportTestResultsAction();
        ActionUtil.copyFrom((AnAction)((Object)action), (String)ID);
        action.myToolWindowId = toolWindowId;
        action.myRunConfiguration = runtimeConfiguration;
        action.registerCustomShortcutSet(action.getShortcutSet(), component);
        return action;
    }

    public void setModel(TestFrameworkRunningModel model2) {
        this.myModel = model2;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExportTestResultsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportTestResultsAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isEnabled(e.getDataContext()));
    }

    private boolean isEnabled(DataContext dataContext) {
        if (this.myModel == null) {
            return false;
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
            return false;
        }
        return !this.myModel.getRoot().isInProgress();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile parent;
        Project project;
        if (e == null) {
            ExportTestResultsAction.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        final ExportTestResultsConfiguration config = ExportTestResultsConfiguration.getInstance(project);
        String name = ExecutionBundle.message("export.test.results.filename", PathUtil.suggestFileName((String)this.myRunConfiguration.getName()));
        Object filename = name + "." + config.getExportFormat().getDefaultExtension();
        boolean showDialog = true;
        while (showDialog) {
            ExportTestResultsDialog d = new ExportTestResultsDialog(project, config, (String)filename);
            if (!d.showAndGet()) {
                return;
            }
            filename = d.getFileName();
            Path outputFile = ExportTestResultsAction.getOutputFile(config, project, (String)filename);
            showDialog = outputFile != null && Files.exists(outputFile, new LinkOption[0]) && Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message("export.test.results.file.exists.message", filename), (String)ExecutionBundle.message("export.test.results.file.exists.title", new Object[0]), (String)TestRunnerBundle.message("export.test.results.overwrite.button.text", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) != 0;
        }
        final Path outputFile = ExportTestResultsAction.getOutputFile(config, project, (String)filename);
        Path parentFile = ExportTestResultsAction.createDirectories(outputFile != null ? outputFile.getParent() : null);
        VirtualFile virtualFile = parent = parentFile != null ? LocalFileSystem.getInstance().refreshAndFindFileByNioFile(parentFile) : null;
        if (parent == null || !parent.isValid()) {
            Object filePath = outputFile != null ? outputFile.toString() : filename;
            this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message("export.test.results.failed", ExecutionBundle.message("failed.to.create.output.file", filePath)), null);
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, ExecutionBundle.message("export.test.results.task.name", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                try {
                    if (!ExportTestResultsAction.this.writeOutputFile(config, outputFile)) {
                        return;
                    }
                }
                catch (IOException | TransformerException | SAXException ex) {
                    LOG.warn((Throwable)ex);
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message("export.test.results.failed", ex.getMessage()), null);
                    return;
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (RuntimeException ex) {
                    Path tempFile;
                    try {
                        tempFile = Files.createTempFile("", "_xml", new FileAttribute[0]);
                    }
                    catch (IOException exception) {
                        LOG.error("Failed to create temp file", (Throwable)exception);
                        LOG.error("Failed to export test results", (Throwable)ex);
                        return;
                    }
                    try {
                        ExportTestResultsConfiguration c = new ExportTestResultsConfiguration();
                        c.setExportFormat(ExportTestResultsConfiguration.ExportFormat.Xml);
                        c.setOpenResults(false);
                        ExportTestResultsAction.this.writeOutputFile(c, tempFile);
                    }
                    catch (Throwable c) {
                        // empty catch block
                    }
                    LOG.error("Failed to export test results", (Throwable)ex, new Attachment[]{AttachmentFactory.createAttachment((Path)tempFile, (boolean)false)});
                    try {
                        NioFiles.deleteRecursively((Path)tempFile);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to delete temp file", (Throwable)e);
                    }
                    return;
                }
                final Ref result2 = new Ref();
                Ref error = new Ref();
                ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)((VirtualFile)WriteAction.compute(() -> {
                    try {
                        String fileName = outputFile.getFileName().toString();
                        VirtualFile child = parent.findChild(fileName);
                        return child == null ? parent.createChildData((Object)this, fileName) : child;
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        error.set((Object)e.getMessage());
                        return null;
                    }
                }))));
                if (!result2.isNull()) {
                    if (config.isOpenResults()) {
                        ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result2.get(), project, config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                    } else {
                        HyperlinkListener listener2 = new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                    ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result2.get(), project, config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                                }
                            }
                        };
                        ExportTestResultsAction.this.showBalloon(project, MessageType.INFO, ExecutionBundle.message("export.test.results.succeeded", outputFile.getFileName().toString()), listener2);
                    }
                } else {
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message("export.test.results.failed", error.get()), null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/export/ExportTestResultsAction$1", "run"));
            }
        });
    }

    @Nullable
    private static Path createDirectories(@Nullable Path path) {
        if (path == null) {
            return path;
        }
        try {
            return Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Path getOutputFile(@NotNull ExportTestResultsConfiguration config, @NotNull Project project, @NotNull String filename) {
        if (config == null) {
            ExportTestResultsAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ExportTestResultsAction.$$$reportNull$$$0(4);
        }
        if (filename == null) {
            ExportTestResultsAction.$$$reportNull$$$0(5);
        }
        try {
            Path outputFolder = ExportTestResultsAction.getOutputFolder(config, project);
            return outputFolder != null ? outputFolder.resolve(filename) : null;
        }
        catch (InvalidPathException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Path getOutputFolder(@NotNull ExportTestResultsConfiguration config, @NotNull Project project) {
        Path outputFolder;
        String outputFolderStr;
        if (config == null) {
            ExportTestResultsAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ExportTestResultsAction.$$$reportNull$$$0(7);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(outputFolderStr = config.getOutputFolder())) && (outputFolder = Path.of(outputFolderStr, new String[0])).isAbsolute()) {
            return outputFolder;
        }
        String basePathStr = project.getBasePath();
        if (basePathStr == null) {
            return null;
        }
        Path basePath = Path.of(basePathStr, new String[0]);
        return StringUtil.isEmptyOrSpaces((String)outputFolderStr) ? basePath : basePath.resolve(outputFolderStr);
    }

    private static void openEditorOrBrowser(VirtualFile result2, Project project, boolean editor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor) {
                FileEditorManager.getInstance((Project)project).openFile(result2, true);
            } else {
                BrowserUtil.browse((VirtualFile)result2);
            }
        });
    }

    private boolean writeOutputFile(ExportTestResultsConfiguration config, @NotNull Path outputFile) throws IOException, TransformerException, SAXException {
        if (outputFile == null) {
            ExportTestResultsAction.$$$reportNull$$$0(8);
        }
        try {
            ExportTestResultsAction.writeOutputFile(new ExportContext(config.getExportFormat(), config.getUserTemplatePath(), this.myModel.getRoot(), this.myRunConfiguration, this.myModel.getProperties(), outputFile));
            return true;
        }
        catch (NonExistentUserTemplatePathException e) {
            this.showBalloon(this.myRunConfiguration.getProject(), MessageType.ERROR, e.getMessage(), null);
            return false;
        }
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static void writeOutputFile(@NotNull ExportContext context) throws IOException, TransformerException, SAXException {
        if (context == null) {
            ExportTestResultsAction.$$$reportNull$$$0(9);
        }
        switch (context.exportFormat) {
            case Xml: {
                TransformerHandler handler = ((SAXTransformerFactory)TransformerFactory.newDefaultInstance()).newTransformerHandler();
                handler.getTransformer().setOutputProperty("indent", "yes");
                handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                ExportTestResultsAction.transform(context, handler);
                break;
            }
            case BundledTemplate: {
                try (InputStream bundledXsltUrl = ExportTestResultsAction.class.getResourceAsStream("intellij-export.xsl");){
                    ExportTestResultsAction.transformWithXslt(context, new StreamSource(bundledXsltUrl));
                    break;
                }
            }
            case UserTemplate: {
                Path xslFile;
                String userTemplatePath = context.userTemplatePath;
                Path path = xslFile = StringUtil.isEmptyOrSpaces((String)userTemplatePath) ? null : NioFiles.toPath((String)userTemplatePath);
                if (xslFile == null || !Files.isRegularFile(xslFile, new LinkOption[0])) {
                    throw new NonExistentUserTemplatePathException(userTemplatePath);
                }
                ExportTestResultsAction.transformWithXslt(context, new StreamSource(xslFile.toUri().toASCIIString()));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void transformWithXslt(@NotNull ExportContext context, @NotNull Source xslSource) throws TransformerConfigurationException, IOException, SAXException {
        if (context == null) {
            ExportTestResultsAction.$$$reportNull$$$0(10);
        }
        if (xslSource == null) {
            ExportTestResultsAction.$$$reportNull$$$0(11);
        }
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newDefaultInstance();
        transformerFactory.setFeature("jdk.xml.enableExtensionFunctions", true);
        TransformerHandler handler = transformerFactory.newTransformerHandler(xslSource);
        handler.getTransformer().setParameter("TITLE", ExecutionBundle.message("export.test.results.filename", context.runConfiguration.getName(), context.runConfiguration.getType().getDisplayName()));
        ExportTestResultsAction.transform(context, handler);
    }

    private static void transform(@NotNull ExportContext context, TransformerHandler handler) throws IOException, SAXException {
        if (context == null) {
            ExportTestResultsAction.$$$reportNull$$$0(12);
        }
        try (BufferedWriter w = Files.newBufferedWriter(context.outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            handler.setResult(new StreamResult(w));
            TestResultsXmlFormatter.execute(context.root, context.runConfiguration, context.properties, handler);
        }
    }

    private void showBalloon(Project project, MessageType type, @NlsContexts.PopupContent String text2, @Nullable HyperlinkListener listener2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            if (ToolWindowManager.getInstance((Project)project).getToolWindow(this.myToolWindowId) != null) {
                ToolWindowManager.getInstance((Project)project).notifyByBalloon(this.myToolWindowId, type, text2, null, listener2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/export/ExportTestResultsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xslSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/export/ExportTestResultsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeOutputFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "transformWithXslt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public record ExportContext(@NotNull ExportTestResultsConfiguration.ExportFormat exportFormat, @Nullable String userTemplatePath, @NotNull AbstractTestProxy root, @NotNull RunConfiguration runConfiguration, @NotNull TestConsoleProperties properties, @NotNull Path outputFile) {
        @NotNull
        private final ExportTestResultsConfiguration.ExportFormat exportFormat;
        @NotNull
        private final AbstractTestProxy root;
        @NotNull
        private final RunConfiguration runConfiguration;
        @NotNull
        private final TestConsoleProperties properties;
        @NotNull
        private final Path outputFile;

        public ExportContext(@NotNull ExportTestResultsConfiguration.ExportFormat exportFormat, @Nullable String userTemplatePath, @NotNull AbstractTestProxy root, @NotNull RunConfiguration runConfiguration, @NotNull TestConsoleProperties properties, @NotNull Path outputFile) {
            if (exportFormat == null) {
                ExportContext.$$$reportNull$$$0(0);
            }
            if (root == null) {
                ExportContext.$$$reportNull$$$0(1);
            }
            if (runConfiguration == null) {
                ExportContext.$$$reportNull$$$0(2);
            }
            if (properties == null) {
                ExportContext.$$$reportNull$$$0(3);
            }
            if (outputFile == null) {
                ExportContext.$$$reportNull$$$0(4);
            }
        }

        @NotNull
        public ExportTestResultsConfiguration.ExportFormat exportFormat() {
            ExportTestResultsConfiguration.ExportFormat exportFormat = this.exportFormat;
            if (exportFormat == null) {
                ExportContext.$$$reportNull$$$0(5);
            }
            return exportFormat;
        }

        @NotNull
        public AbstractTestProxy root() {
            AbstractTestProxy abstractTestProxy = this.root;
            if (abstractTestProxy == null) {
                ExportContext.$$$reportNull$$$0(6);
            }
            return abstractTestProxy;
        }

        @NotNull
        public RunConfiguration runConfiguration() {
            RunConfiguration runConfiguration = this.runConfiguration;
            if (runConfiguration == null) {
                ExportContext.$$$reportNull$$$0(7);
            }
            return runConfiguration;
        }

        @NotNull
        public TestConsoleProperties properties() {
            TestConsoleProperties testConsoleProperties = this.properties;
            if (testConsoleProperties == null) {
                ExportContext.$$$reportNull$$$0(8);
            }
            return testConsoleProperties;
        }

        @NotNull
        public Path outputFile() {
            Path path = this.outputFile;
            if (path == null) {
                ExportContext.$$$reportNull$$$0(9);
            }
            return path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportFormat";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfiguration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputFile";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/export/ExportTestResultsAction$ExportContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/export/ExportTestResultsAction$ExportContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "exportFormat";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "root";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runConfiguration";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "properties";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "outputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class NonExistentUserTemplatePathException
    extends RuntimeException {
        NonExistentUserTemplatePathException(@Nullable String userTemplatePath) {
            super(ExecutionBundle.message("export.test.results.custom.template.not.found", Objects.requireNonNullElse(userTemplatePath, "N/A")));
        }
    }
}

