/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/bookmark/actions/AddAnotherBookmarkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "process", "", "perform", "intellij.platform.bookmarks"})
public final class AddAnotherBookmarkAction
extends DumbAwareAction {
    public AddAnotherBookmarkAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setEnabledAndVisible(this.process(event, false));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.process(event, true);
    }

    private final boolean process(AnActionEvent event, boolean perform) {
        if (ExtensionsKt.getContextBookmarks(event) != null) {
            return false;
        }
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return false;
        }
        BookmarksManager manager = bookmarksManager;
        Bookmark bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark == null) {
            return false;
        }
        Bookmark bookmark2 = bookmark;
        if (bookmark2 instanceof LineBookmark) {
            return false;
        }
        BookmarkType bookmarkType = manager.getType(bookmark2);
        if (bookmarkType == null) {
            return false;
        }
        BookmarkType type = bookmarkType;
        if (perform) {
            manager.add(bookmark2, type);
        }
        return true;
    }
}

