/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.bookmark.BookmarksListProviderService;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"bookmarkOccurrence", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getBookmarkOccurrence", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "toOpenFileDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "asVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "toLocation", "Lcom/intellij/execution/Location;", "initialize", "", "Lcom/intellij/util/ui/StatusText;", "owner", "Ljava/awt/Component;", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\ncom/intellij/ide/bookmark/ui/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class ExtensionsKt {
    @Nullable
    public static final BookmarkOccurrence getBookmarkOccurrence(@NotNull AbstractTreeNode<?> $this$bookmarkOccurrence) {
        BookmarkOccurrence bookmarkOccurrence;
        Intrinsics.checkNotNullParameter($this$bookmarkOccurrence, (String)"<this>");
        BookmarkNode bookmarkNode = $this$bookmarkOccurrence instanceof BookmarkNode ? (BookmarkNode)((Object)$this$bookmarkOccurrence) : null;
        if (bookmarkNode != null) {
            BookmarkNode $this$_get_bookmarkOccurrence__u24lambda_u240 = bookmarkNode;
            boolean bl = false;
            BookmarkGroup bookmarkGroup = $this$_get_bookmarkOccurrence__u24lambda_u240.getBookmarkGroup();
            if (bookmarkGroup != null) {
                BookmarkGroup it = bookmarkGroup;
                boolean bl2 = false;
                Object object = $this$_get_bookmarkOccurrence__u24lambda_u240.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                bookmarkOccurrence = new BookmarkOccurrence(it, (Bookmark)object);
            } else {
                bookmarkOccurrence = null;
            }
        } else {
            bookmarkOccurrence = null;
        }
        return bookmarkOccurrence;
    }

    @Nullable
    public static final OpenFileDescriptor toOpenFileDescriptor(@NotNull AbstractTreeNode<?> $this$toOpenFileDescriptor) {
        BookmarksListProvider descriptor;
        BookmarksListProvider bookmarksListProvider;
        BookmarksListProvider bookmarksListProvider2;
        Project project;
        block6: {
            Intrinsics.checkNotNullParameter($this$toOpenFileDescriptor, (String)"<this>");
            Project project2 = $this$toOpenFileDescriptor.getProject();
            if (project2 == null) {
                return null;
            }
            project = project2;
            if (!$this$toOpenFileDescriptor.canNavigateToSource()) {
                return null;
            }
            for (BookmarksListProvider it : (Iterable)BookmarksListProviderService.Companion.getProviders(project)) {
                boolean bl = false;
                if ((it = it.getDescriptor($this$toOpenFileDescriptor)) == null) continue;
                bookmarksListProvider2 = it;
                break block6;
            }
            bookmarksListProvider2 = null;
        }
        if ((bookmarksListProvider = (descriptor = bookmarksListProvider2)) == null) {
            VirtualFile virtualFile = ExtensionsKt.asVirtualFile($this$toOpenFileDescriptor);
            if (virtualFile != null) {
                BookmarksListProvider it;
                it = virtualFile;
                boolean bl = false;
                bookmarksListProvider = new OpenFileDescriptor(project, (VirtualFile)it);
            } else {
                bookmarksListProvider = null;
            }
        }
        return bookmarksListProvider;
    }

    @Nullable
    public static final VirtualFile asVirtualFile(@NotNull AbstractTreeNode<?> $this$asVirtualFile) {
        Intrinsics.checkNotNullParameter($this$asVirtualFile, (String)"<this>");
        ProjectViewNode projectViewNode = $this$asVirtualFile instanceof ProjectViewNode ? (ProjectViewNode)$this$asVirtualFile : null;
        return projectViewNode != null ? projectViewNode.getVirtualFile() : null;
    }

    @Nullable
    public static final Location<?> toLocation(@NotNull AbstractTreeNode<?> $this$toLocation) {
        int offset;
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter($this$toLocation, (String)"<this>");
        BookmarkOccurrence bookmarkOccurrence = ExtensionsKt.getBookmarkOccurrence($this$toLocation);
        Object object = bookmark = bookmarkOccurrence != null ? bookmarkOccurrence.getBookmark() : null;
        if (bookmark instanceof FileBookmark && ((FileBookmark)bookmark).getFile().isDirectory()) {
            Location<PsiElement> location;
            VirtualFile virtualFile = ExtensionsKt.asVirtualFile($this$toLocation);
            if (virtualFile != null && (virtualFile = VirtualFileUtil.validOrNull((VirtualFile)virtualFile)) != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                location = PsiLocation.fromPsiElement($this$toLocation.getProject(), (PsiElement)PsiUtilBase.findFileSystemItem((Project)$this$toLocation.getProject(), (VirtualFile)it));
            } else {
                location = null;
            }
            return location;
        }
        if (!(bookmark instanceof LineBookmark)) {
            return null;
        }
        int lineNum = ((LineBookmark)bookmark).getLine();
        VirtualFile virtualFile = ((LineBookmark)bookmark).getFile();
        PsiFile psiFile = PsiManager.getInstance((Project)$this$toLocation.getProject()).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)$this$toLocation.getProject()).getDocument(psiFile2);
        if (document == null) {
            return null;
        }
        Document doc = document;
        if (lineNum <= 0 || lineNum > doc.getLineCount()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile2);
        }
        int endOffset = doc.getLineEndOffset(lineNum);
        Ref.ObjectRef elementAtLine = new Ref.ObjectRef();
        PsiElement nextElement = psiFile2.findElementAt(offset);
        for (offset = doc.getLineStartOffset(lineNum); offset <= endOffset && nextElement != null; offset += ((PsiWhiteSpace)elementAtLine.element).getTextLength()) {
            elementAtLine.element = nextElement;
            if (!(elementAtLine.element instanceof PsiWhiteSpace)) break;
            nextElement = PsiTreeUtil.nextLeaf((PsiElement)((PsiElement)elementAtLine.element));
        }
        if (elementAtLine.element instanceof PsiPlainText && offset > 0) {
            int offsetInPlainTextFile = offset;
            Project project = $this$toLocation.getProject();
            return new PsiLocation<PsiPlainText>((Ref.ObjectRef<PsiElement>)elementAtLine, virtualFile, offsetInPlainTextFile, project){
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ int $offsetInPlainTextFile;
                {
                    this.$virtualFile = $virtualFile;
                    this.$offsetInPlainTextFile = $offsetInPlainTextFile;
                    super($super_call_param$1, (PsiElement)$elementAtLine.element);
                }

                public OpenFileDescriptor getOpenFileDescriptor() {
                    return new OpenFileDescriptor(this.getProject(), this.$virtualFile, this.$offsetInPlainTextFile);
                }
            };
        }
        Project project = $this$toLocation.getProject();
        PsiElement psiElement = (PsiElement)elementAtLine.element;
        if (psiElement == null) {
            psiElement = (PsiElement)psiFile2;
        }
        return PsiLocation.fromPsiElement(project, psiElement);
    }

    public static final void initialize(@NotNull StatusText $this$initialize, @NotNull Component owner) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$initialize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        $this$initialize.setText(BookmarkBundle.message("status.text.no.bookmarks.added", new Object[0]));
        String string2 = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFirstKeyboardShortcutText(...)");
        String shortcut = string2;
        if (StringsKt.isBlank((CharSequence)shortcut)) {
            string = BookmarkBundle.message("status.text.add.bookmark", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{shortcut};
            string = BookmarkBundle.message("status.text.add.bookmark.with.shortcut", objectArray);
        }
        $this$initialize.appendLine(string);
        $this$initialize.appendLine(BookmarkBundle.message("status.text.add.bookmark.next.line", new Object[0]));
        AnAction anAction = ActionUtil.getAction((String)"BookmarksView.Create");
        if (anAction != null) {
            AnAction action = anAction;
            boolean bl = false;
            $this$initialize.appendLine(ActionsBundle.message((String)"action.BookmarksView.Create.text", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> ExtensionsKt.initialize$lambda$0$0(action, owner, arg_0));
        }
        $this$initialize.appendLine("");
        $this$initialize.appendLine(AllIcons.General.ContextHelp, BookmarkBundle.message("status.text.context.help", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, ExtensionsKt::initialize$lambda$1);
    }

    private static final void initialize$lambda$0$0(AnAction $action, Component $owner, ActionEvent it) {
        ActionUtil.invokeAction((AnAction)$action, (Component)$owner, (String)"BookmarksView", null, null);
    }

    private static final void initialize$lambda$1(ActionEvent it) {
        HelpManager.getInstance().invokeHelp("bookmarks.tool.window.help");
    }
}

