/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeElementWrapper
extends CachingChildrenTreeNode<TreeElement> {
    private static final Logger LOG = Logger.getInstance(TreeElementWrapper.class);

    public TreeElementWrapper(Project project, @NotNull TreeElement value, @NotNull TreeModel treeModel) {
        if (value == null) {
            TreeElementWrapper.$$$reportNull$$$0(0);
        }
        if (treeModel == null) {
            TreeElementWrapper.$$$reportNull$$$0(1);
        }
        super(project, value, treeModel);
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode oldInstance) {
        if (oldInstance == null) {
            TreeElementWrapper.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void update(@NotNull PresentationData presentation) {
        StructureViewTreeElement value;
        Object valueValue;
        if (presentation == null) {
            TreeElementWrapper.$$$reportNull$$$0(3);
        }
        Object object = valueValue = (value = (StructureViewTreeElement)this.getValue()) == null ? null : value.getValue();
        if (valueValue != null) {
            presentation.updateFrom(((TreeElement)this.getValue()).getPresentation());
        }
    }

    @Override
    public void initChildren() {
        Object[] children;
        this.clearChildren();
        TreeElement value = (TreeElement)this.getValue();
        if (value == null) {
            return;
        }
        for (TreeElement treeElement : children = value.getChildren()) {
            if (treeElement == null) {
                LOG.error(String.valueOf(value) + " returned null child: " + Arrays.toString(children));
                continue;
            }
            this.addSubElement(this.createChildNode(treeElement));
        }
        TreeModel treeModel = this.myTreeModel;
        if (treeModel instanceof ProvidingTreeModel) {
            ProvidingTreeModel model2 = (ProvidingTreeModel)treeModel;
            Collection<NodeProvider<?>> originalProviders = model2.getNodeProviders();
            List providers = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(originalProviders);
            for (NodeProvider provider : providers) {
                Collection nodes;
                if (!model2.isEnabled(provider)) continue;
                try {
                    nodes = provider.provideNodes(value);
                }
                catch (IndexNotReadyException ignore) {
                    continue;
                }
                for (Object node : nodes) {
                    if (node == null) {
                        LOG.error(String.valueOf(provider) + " returned null node: " + String.valueOf(nodes));
                        continue;
                    }
                    this.addSubElement(this.createChildNode((TreeElement)node));
                }
            }
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInstance";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/treeView/smartTree/TreeElementWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFromNewInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

