/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupListener;
import com.intellij.openapi.editor.impl.DocumentMarkupModelManager;
import com.intellij.openapi.editor.impl.EmptyImmutableMarkupModel;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DocumentMarkupModel {
    private static final Key<MarkupModelEx> MARKUP_MODEL_KEY = Key.create((String)"DocumentMarkupModel.MarkupModel");
    private static final Key<ConcurrentMap<Project, MarkupModelImpl>> MARKUP_MODEL_MAP_KEY = Key.create((String)"DocumentMarkupModel.MarkupModelMap");

    private DocumentMarkupModel() {
    }

    @Contract(value="_,_,true -> !null")
    public static MarkupModel forDocument(@NotNull Document document, @Nullable Project project, boolean create2) {
        DocumentMarkupModelManager documentMarkupModelManager;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(0);
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            MarkupModelEx baseMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(delegate, project, true);
            return new MarkupModelWindow(baseMarkupModel, window);
        }
        if (project == null) {
            MarkupModelEx markupModel = (MarkupModelEx)document.getUserData(MARKUP_MODEL_KEY);
            if (create2 && markupModel == null) {
                MarkupModelImpl newModel = new MarkupModelImpl((DocumentEx)document);
                DocumentMarkupModel.fireMarkupModelCreated(null, newModel);
                markupModel = (MarkupModelEx)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_KEY, (Object)newModel);
                if (markupModel != newModel) {
                    newModel.dispose();
                    DocumentMarkupModel.fireMarkupModelDisposed(null, newModel);
                }
            }
            return markupModel;
        }
        DocumentMarkupModelManager documentMarkupModelManager2 = documentMarkupModelManager = project.isDisposed() ? null : DocumentMarkupModelManager.getInstance(project);
        if (documentMarkupModelManager == null || documentMarkupModelManager.isDisposed() || project.isDisposed()) {
            return new EmptyImmutableMarkupModel(document);
        }
        ConcurrentMap<Project, MarkupModelImpl> markupModelMap = DocumentMarkupModel.getMarkupModelMap(document);
        MarkupModelImpl model2 = (MarkupModelImpl)markupModelMap.get(project);
        if (create2 && model2 == null) {
            MarkupModelImpl newModel = new MarkupModelImpl((DocumentEx)document);
            DocumentMarkupModel.fireMarkupModelCreated(project, newModel);
            model2 = (MarkupModelImpl)ConcurrencyUtil.cacheOrGet(markupModelMap, (Object)project, (Object)newModel);
            if (model2 == newModel) {
                documentMarkupModelManager.registerDocument(document);
            } else {
                newModel.dispose();
                DocumentMarkupModel.fireMarkupModelDisposed(project, newModel);
            }
        }
        return model2;
    }

    @ApiStatus.Experimental
    public static @Unmodifiable @NotNull List<? extends MarkupModel> getExistingMarkupModels(@NotNull Document document) {
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(1);
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow documentWindow = (DocumentWindow)document;
            Document delegate = documentWindow.getDelegate();
            List<? extends MarkupModel> baseMarkupModels = DocumentMarkupModel.getExistingMarkupModels(delegate);
            List list2 = ContainerUtil.map(baseMarkupModels, model2 -> new MarkupModelWindow((MarkupModelEx)model2, documentWindow));
            if (list2 == null) {
                DocumentMarkupModel.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ConcurrentMap markupModelMap = (ConcurrentMap)document.getUserData(MARKUP_MODEL_MAP_KEY);
        List<Object> list3 = markupModelMap != null ? List.copyOf(markupModelMap.values()) : Collections.emptyList();
        if (list3 == null) {
            DocumentMarkupModel.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    private static ConcurrentMap<Project, MarkupModelImpl> getMarkupModelMap(@NotNull Document document) {
        ConcurrentMap markupModelMap;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(4);
        }
        if ((markupModelMap = (ConcurrentMap)document.getUserData(MARKUP_MODEL_MAP_KEY)) == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            markupModelMap = (ConcurrentMap)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_MAP_KEY, newMap);
        }
        ConcurrentMap concurrentMap = markupModelMap;
        if (concurrentMap == null) {
            DocumentMarkupModel.$$$reportNull$$$0(5);
        }
        return concurrentMap;
    }

    static void removeMarkupModel(@NotNull Document document, @NotNull Project project) {
        MarkupModelImpl removed;
        if (document == null) {
            DocumentMarkupModel.$$$reportNull$$$0(6);
        }
        if (project == null) {
            DocumentMarkupModel.$$$reportNull$$$0(7);
        }
        if ((removed = (MarkupModelImpl)DocumentMarkupModel.getMarkupModelMap(document).remove(project)) != null) {
            removed.dispose();
            DocumentMarkupModel.fireMarkupModelDisposed(project, removed);
        }
    }

    private static void fireMarkupModelCreated(@Nullable Project project, @NotNull MarkupModelEx markupModel) {
        Application app;
        if (markupModel == null) {
            DocumentMarkupModel.$$$reportNull$$$0(8);
        }
        if ((app = DocumentMarkupModel.getApplication()) != null) {
            ((DocumentMarkupListener)app.getMessageBus().syncPublisher(DocumentMarkupListener.TOPIC)).markupModelCreated(project, markupModel);
        }
    }

    private static void fireMarkupModelDisposed(@Nullable Project project, @NotNull MarkupModelEx markupModel) {
        Application app;
        if (markupModel == null) {
            DocumentMarkupModel.$$$reportNull$$$0(9);
        }
        if ((app = DocumentMarkupModel.getApplication()) != null) {
            ((DocumentMarkupListener)app.getMessageBus().syncPublisher(DocumentMarkupListener.TOPIC)).markupModelDisposed(project, markupModel);
        }
    }

    @Nullable
    private static Application getApplication() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            return app;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/DocumentMarkupModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/DocumentMarkupModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingMarkupModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModelMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExistingMarkupModels";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMarkupModelMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeMarkupModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireMarkupModelCreated";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireMarkupModelDisposed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

