/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RangeHighlighterTree
extends RangeMarkerTree<RangeHighlighterEx> {
    static final byte ERROR_STRIPE_FLAG = RangeHighlighterTree.nextAvailableTasteFlag();
    static final byte RENDER_IN_GUTTER_FLAG = RangeHighlighterTree.nextAvailableTasteFlag();
    private final MarkupModelImpl myMarkupModel;

    RangeHighlighterTree(@NotNull MarkupModelImpl markupModel) {
        if (markupModel == null) {
            RangeHighlighterTree.$$$reportNull$$$0(0);
        }
        super(markupModel.getDocument());
        this.myMarkupModel = markupModel;
    }

    void dispose() {
        this.dispose(this.myMarkupModel.getDocument());
    }

    protected boolean keepIntervalOnWeakReference(@NotNull RangeHighlighterEx interval) {
        if (interval == null) {
            RangeHighlighterTree.$$$reportNull$$$0(1);
        }
        return false;
    }

    protected byte getTasteFlags(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            RangeHighlighterTree.$$$reportNull$$$0(2);
        }
        return (byte)((highlighter.getErrorStripeMarkColor(null) != null ? ERROR_STRIPE_FLAG : (byte)0) | (highlighter.isRenderedInGutter() ? RENDER_IN_GUTTER_FLAG : (byte)0));
    }

    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i1, @NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i2) {
        if (i1 == null) {
            RangeHighlighterTree.$$$reportNull$$$0(3);
        }
        if (i2 == null) {
            RangeHighlighterTree.$$$reportNull$$$0(4);
        }
        return ((RHNode)i1).compareTo((RHNode)i2);
    }

    @NotNull
    protected RangeMarkerTree.RMNode<RangeHighlighterEx> createNewNode(@NotNull RangeHighlighterEx key, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (key == null) {
            RangeHighlighterTree.$$$reportNull$$$0(5);
        }
        return new RHNode(this, key, start, end, greedyToLeft, greedyToRight, stickingToRight, layer);
    }

    protected void fireBeforeRemoved(@NotNull RangeHighlighterEx marker) {
        if (marker == null) {
            RangeHighlighterTree.$$$reportNull$$$0(6);
        }
        this.myMarkupModel.fireBeforeRemoved(marker);
    }

    protected void fireAfterRemoved(@NotNull RangeHighlighterEx marker) {
        if (marker == null) {
            RangeHighlighterTree.$$$reportNull$$$0(7);
        }
        this.myMarkupModel.fireAfterRemoved(marker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/RangeHighlighterTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "keepIntervalOnWeakReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTasteFlags";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compareEqualStartIntervals";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBeforeRemoved";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fireAfterRemoved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    static final class RHNode
    extends RangeMarkerTree.RMNode<RangeHighlighterEx>
    implements Comparable<RangeMarkerTree.RMNode<?>> {
        private static final byte IS_PERSISTENT = 64;
        final int myLayer;

        RHNode(@NotNull RangeHighlighterTree rangeMarkerTree, @NotNull RangeHighlighterEx key, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            if (rangeMarkerTree == null) {
                RHNode.$$$reportNull$$$0(0);
            }
            if (key == null) {
                RHNode.$$$reportNull$$$0(1);
            }
            super((RangeMarkerTree)rangeMarkerTree, (RangeMarkerEx)key, start, end, greedyToLeft, greedyToRight, stickingToRight);
            this.myLayer = layer;
            this.setFlag((byte)64, key.isPersistent());
        }

        @Override
        public int compareTo(@NotNull RangeMarkerTree.RMNode o) {
            boolean persistent2;
            if (o == null) {
                RHNode.$$$reportNull$$$0(2);
            }
            RHNode o1 = this;
            RHNode o2 = (RHNode)o;
            int d = o2.myLayer - o1.myLayer;
            if (d != 0) {
                return d;
            }
            int result2 = super.compareTo((RangeMarkerTree.RMNode)o2);
            if (result2 != 0) {
                return result2;
            }
            boolean persistent1 = o1.isFlagSet((byte)64);
            return persistent1 == (persistent2 = o2.isFlagSet((byte)64)) ? 0 : (persistent1 ? -1 : 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeMarkerTree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/RangeHighlighterTree$RHNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

