/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.csat;

import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.csat.CsatFeedbackSurvey;
import com.intellij.platform.feedback.csat.CsatNewUserTrackerKt;
import com.intellij.platform.feedback.csat.NextDate;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\b\u0010\u0011\u001a\u00020\tH\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0000\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0014H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"USER_CONSIDERED_NEW_DAYS", "", "NEW_USER_SURVEY_PERIOD", "EXISTING_USER_SURVEY_PERIOD", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDaysHash", "today", "Ljava/time/LocalDate;", "surveyPeriod", "getProductHash", "getNextCsatDay", "Lcom/intellij/platform/feedback/csat/NextDate;", "getSurveyPeriod", "isNewUser", "", "getCsatToday", "flipACoin", "productCode", "", "newUser", "userCreatedDate", "tryParseDate", "it", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nCsatFeedbackSurvey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CsatFeedbackSurvey.kt\ncom/intellij/platform/feedback/csat/CsatFeedbackSurveyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class CsatFeedbackSurveyKt {
    public static final int USER_CONSIDERED_NEW_DAYS = 30;
    public static final int NEW_USER_SURVEY_PERIOD = 29;
    public static final int EXISTING_USER_SURVEY_PERIOD = 97;
    @NotNull
    private static final Logger LOG;

    private static final int getDaysHash(LocalDate today, int surveyPeriod) {
        return Math.abs((int)ChronoUnit.DAYS.between(LocalDate.of(1970, 1, 1), today)) % surveyPeriod;
    }

    private static final int getProductHash(int surveyPeriod) {
        return Math.abs((ApplicationInfo.getInstance().getVersionName() + MachineIdManager.INSTANCE.getAnonymizedMachineId("CSAT Survey")).hashCode()) % surveyPeriod;
    }

    @NotNull
    public static final NextDate getNextCsatDay() {
        boolean bl;
        LocalDate userCreatedDate;
        LocalDate today = CsatFeedbackSurveyKt.getCsatToday();
        LocalDate localDate = userCreatedDate = CsatNewUserTrackerKt.getCsatUserCreatedDate();
        if (localDate != null) {
            LocalDate it = localDate;
            boolean bl2 = false;
            bl = CsatFeedbackSurveyKt.isNewUser(today, userCreatedDate);
        } else {
            bl = false;
        }
        boolean isNewUser = bl;
        int surveyPeriod = CsatFeedbackSurveyKt.getSurveyPeriod(isNewUser);
        for (int i = 0; i < 365; ++i) {
            LocalDate date = today.plusDays(i);
            int productHash = CsatFeedbackSurveyKt.getProductHash(surveyPeriod);
            Intrinsics.checkNotNull((Object)date);
            int daysHash = CsatFeedbackSurveyKt.getDaysHash(date, surveyPeriod);
            if (productHash != daysHash) continue;
            return new NextDate(isNewUser, date);
        }
        throw new IllegalStateException("No suitable date found");
    }

    private static final int getSurveyPeriod(boolean isNewUser) {
        return isNewUser ? 29 : 97;
    }

    @NotNull
    public static final LocalDate getCsatToday() {
        String string;
        Object object = Registry.Companion.stringValue("csat.survey.today");
        String it = object;
        boolean bl = false;
        String string2 = string = !StringsKt.isBlank((CharSequence)it) ? object : null;
        if (string != null) {
            Object it2 = string;
            boolean bl2 = false;
            object = CsatFeedbackSurveyKt.tryParseDate((String)it2);
            if (object != null) {
                it2 = object;
                boolean bl3 = false;
                return it2;
            }
        }
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
        return localDate;
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean flipACoin(@NotNull String productCode, boolean newUser) {
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
                it = var4_2 = Registry.Companion.stringValue("csat.survey.show.probability");
                $i$a$-takeIf-CsatFeedbackSurveyKt$flipACoin$probability$1 = false;
                var3_5 = !StringsKt.isBlank((CharSequence)it) != false ? var4_2 : null;
                v0 = probability = var3_5 != null ? StringsKt.toDoubleOrNull((String)var3_5) : null;
                if (probability != null) {
                    if (probability <= 0.0) {
                        return false;
                    }
                    if (probability >= 1.0) {
                        return true;
                    }
                    return Math.random() < probability;
                }
                if (!newUser) break block19;
                var5_3 = productCode;
                switch (var5_3.hashCode()) {
                    case 2547: {
                        if (var5_3.equals("PC")) break;
                        ** break;
                    }
                    case 2569: {
                        if (!var5_3.equals("PY")) {
                            ** break;
                        }
                        ** GOTO lbl29
                    }
                    case 2330: {
                        if (!var5_3.equals("IC")) {
                            ** break;
                        }
                        ** GOTO lbl29
                    }
                    case 2348: {
                        if (!var5_3.equals("IU")) ** break;
lbl29:
                        // 3 sources

                        v1 = 0.125;
                        break block20;
                    }
                }
                v1 = 0.07;
                break block20;
lbl33:
                // 5 sources

                v1 = 1.0;
                break block20;
            }
            var5_3 = productCode;
            switch (var5_3.hashCode()) {
                case 2547: {
                    if (!var5_3.equals("PC")) {
                        ** break;
                    }
                    ** GOTO lbl50
                }
                case 2569: {
                    if (var5_3.equals("PY")) break;
                    ** break;
                }
                case 2330: {
                    if (var5_3.equals("IC")) break;
                    ** break;
                }
                case 2348: {
                    if (!var5_3.equals("IU")) ** break;
lbl50:
                    // 2 sources

                    v1 = 0.015;
                    break block20;
                }
            }
            v1 = 0.025;
            break block20;
lbl54:
            // 5 sources

            v1 = probabilityPerProduct = 0.125;
        }
        if (probabilityPerProduct >= 1.0) {
            return true;
        }
        return Math.random() < probabilityPerProduct;
    }

    public static final boolean isNewUser(@NotNull LocalDate today, @NotNull LocalDate userCreatedDate) {
        Intrinsics.checkNotNullParameter((Object)today, (String)"today");
        Intrinsics.checkNotNullParameter((Object)userCreatedDate, (String)"userCreatedDate");
        return today.isBefore(userCreatedDate.plusDays(30L));
    }

    @Nullable
    public static final LocalDate tryParseDate(@NotNull String it) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            localDate = LocalDate.parse(it, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
        return localDate;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ int access$getSurveyPeriod(boolean isNewUser) {
        return CsatFeedbackSurveyKt.getSurveyPeriod(isNewUser);
    }

    public static final /* synthetic */ int access$getProductHash(int surveyPeriod) {
        return CsatFeedbackSurveyKt.getProductHash(surveyPeriod);
    }

    public static final /* synthetic */ int access$getDaysHash(LocalDate today, int surveyPeriod) {
        return CsatFeedbackSurveyKt.getDaysHash(today, surveyPeriod);
    }

    static {
        Logger logger = Logger.getInstance(CsatFeedbackSurvey.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

