/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml;

import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.TierRequester;
import com.intellij.platform.ml.environment.Environment;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005H\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/ml/ScopeEnvironment;", "Lcom/intellij/platform/ml/environment/Environment;", "baseEnvironment", "scope", "", "Lcom/intellij/platform/ml/Tier;", "<init>", "(Lcom/intellij/platform/ml/environment/Environment;Ljava/util/Set;)V", "tiers", "getTiers", "()Ljava/util/Set;", "getInstance", "T", "", "tier", "(Lcom/intellij/platform/ml/Tier;)Ljava/lang/Object;", "Companion", "intellij.platform.ml"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nScopeEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeEnvironment.kt\ncom/intellij/platform/ml/ScopeEnvironment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class ScopeEnvironment
implements Environment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Environment baseEnvironment;
    @NotNull
    private final Set<Tier<?>> scope;
    @NotNull
    private final Set<Tier<?>> tiers;

    private ScopeEnvironment(Environment baseEnvironment, Set<? extends Tier<?>> scope) {
        this.baseEnvironment = baseEnvironment;
        this.scope = scope;
        this.tiers = this.scope;
    }

    @Override
    @NotNull
    public Set<Tier<?>> getTiers() {
        return this.tiers;
    }

    @Override
    @NotNull
    public <T> T getInstance(@NotNull Tier<T> tier) {
        Intrinsics.checkNotNullParameter(tier, (String)"tier");
        if (!this.scope.contains(tier)) {
            boolean bl = false;
            String string = tier + " was not supposed to be accessed, allowed scope: " + this.scope;
            throw new IllegalArgumentException(string.toString());
        }
        return this.baseEnvironment.getInstance(tier);
    }

    public /* synthetic */ ScopeEnvironment(Environment baseEnvironment, Set scope, DefaultConstructorMarker $constructor_marker) {
        this(baseEnvironment, scope);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bJ\u001c\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/ml/ScopeEnvironment$Companion;", "", "<init>", "()V", "restrictedBy", "Lcom/intellij/platform/ml/ScopeEnvironment;", "Lcom/intellij/platform/ml/environment/Environment;", "scope", "", "Lcom/intellij/platform/ml/Tier;", "narrowedTo", "accessibleSafelyByOrNull", "requester", "Lcom/intellij/platform/ml/TierRequester;", "accessibleSafelyBy", "intellij.platform.ml"})
    @SourceDebugExtension(value={"SMAP\nScopeEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeEnvironment.kt\ncom/intellij/platform/ml/ScopeEnvironment$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1786#2,3:44\n1807#2,3:47\n*S KotlinDebug\n*F\n+ 1 ScopeEnvironment.kt\ncom/intellij/platform/ml/ScopeEnvironment$Companion\n*L\n29#1:44,3\n34#1:47,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScopeEnvironment restrictedBy(@NotNull Environment $this$restrictedBy, @NotNull Set<? extends Tier<?>> scope) {
            Intrinsics.checkNotNullParameter((Object)$this$restrictedBy, (String)"<this>");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            return new ScopeEnvironment($this$restrictedBy, CollectionsKt.intersect((Iterable)scope, (Iterable)$this$restrictedBy.getTiers()), null);
        }

        @NotNull
        public final ScopeEnvironment narrowedTo(@NotNull Environment $this$narrowedTo, @NotNull Set<? extends Tier<?>> scope) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$narrowedTo, (String)"<this>");
                Intrinsics.checkNotNullParameter(scope, (String)"scope");
                Iterable $this$all$iv = scope;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Tier it = (Tier)element$iv;
                        boolean bl2 = false;
                        if ($this$narrowedTo.contains(it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new ScopeEnvironment($this$narrowedTo, scope, null);
        }

        @Nullable
        public final ScopeEnvironment accessibleSafelyByOrNull(@NotNull Environment $this$accessibleSafelyByOrNull, @NotNull TierRequester requester) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$accessibleSafelyByOrNull, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
                Iterable $this$any$iv = requester.getRequiredTiers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Tier it = (Tier)element$iv;
                        boolean bl2 = false;
                        if (!(!$this$accessibleSafelyByOrNull.contains(it))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            return this.accessibleSafelyBy($this$accessibleSafelyByOrNull, requester);
        }

        @NotNull
        public final ScopeEnvironment accessibleSafelyBy(@NotNull Environment $this$accessibleSafelyBy, @NotNull TierRequester requester) {
            Intrinsics.checkNotNullParameter((Object)$this$accessibleSafelyBy, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
            return this.narrowedTo($this$accessibleSafelyBy, requester.getRequiredTiers());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

