/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.DocCommentSettings;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface LanguageCodeStyleProvider
extends CustomCodeStyleSettingsFactory {
    @Nullable
    public static LanguageCodeStyleProvider forLanguage(Language language) {
        for (LanguageCodeStyleProvider languageCodeStyleProvider : CodeStyleSettingsService.getInstance().getLanguageCodeStyleProviders()) {
            if (!languageCodeStyleProvider.getLanguage().equals(language)) continue;
            return languageCodeStyleProvider;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleProvider findUsingBaseLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageCodeStyleProvider.$$$reportNull$$$0(0);
        }
        for (Language currLang = language; currLang != null; currLang = currLang.getBaseLanguage()) {
            LanguageCodeStyleProvider curr = LanguageCodeStyleProvider.forLanguage(currLang);
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    @NotNull
    public Language getLanguage();

    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings();

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings var1);

    public Set<String> getSupportedFields();

    @ApiStatus.Experimental
    default public boolean usesCommonKeepLineBreaks() {
        return false;
    }

    @ApiStatus.Experimental
    default public boolean useBaseLanguageCommonSettings() {
        return false;
    }

    default public boolean canInsertSpaceInLineComment(@NotNull String commentContents) {
        if (commentContents == null) {
            LanguageCodeStyleProvider.$$$reportNull$$$0(1);
        }
        if (commentContents.isBlank()) {
            return false;
        }
        return Character.isLetterOrDigit(commentContents.charAt(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentContents";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsingBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canInsertSpaceInLineComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

