/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionManagerImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.impl.runtime.deployment.LocalDeploymentImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionDataNotAvailableException;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionImpl<D extends DeploymentConfiguration>
implements ServerConnection<D> {
    private static final Logger LOG = Logger.getInstance(ServerConnectionImpl.class);
    private final RemoteServer<?> myServer;
    private final ServerConnector<D> myConnector;
    private final ServerConnectionEventDispatcher myEventDispatcher;
    private final ServerConnectionManagerImpl myConnectionManager;
    private MessageBusConnection myMessageBusConnection;
    private volatile ConnectionStatus myStatus = ConnectionStatus.DISCONNECTED;
    @Nls
    private volatile String myStatusText;
    private volatile ServerRuntimeInstance<D> myRuntimeInstance;
    private final Map<Project, LogManagersForProject> myPerProjectLogManagers = new ConcurrentHashMap<Project, LogManagersForProject>();
    private final MyDeployments myAllDeployments;

    public ServerConnectionImpl(RemoteServer<?> server, ServerConnector<D> connector, @Nullable ServerConnectionManagerImpl connectionManager, ServerConnectionEventDispatcher eventDispatcher) {
        this.myServer = server;
        this.myConnector = connector;
        this.myConnectionManager = connectionManager;
        this.myEventDispatcher = eventDispatcher;
        this.myAllDeployments = new MyDeployments(server.getType().getDeploymentComparator());
    }

    @Override
    @NotNull
    public RemoteServer<?> getServer() {
        RemoteServer<?> remoteServer = this.myServer;
        if (remoteServer == null) {
            ServerConnectionImpl.$$$reportNull$$$0(0);
        }
        return remoteServer;
    }

    @Override
    @NotNull
    public ConnectionStatus getStatus() {
        ConnectionStatus connectionStatus = this.myStatus;
        if (connectionStatus == null) {
            ServerConnectionImpl.$$$reportNull$$$0(1);
        }
        return connectionStatus;
    }

    @Override
    @Nls
    @NotNull
    public String getStatusText() {
        String string = this.myStatusText != null ? this.myStatusText : this.myStatus.getPresentableText();
        if (string == null) {
            ServerConnectionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void connect(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            ServerConnectionImpl.$$$reportNull$$$0(3);
        }
        this.doDisconnect();
        this.connectIfNeeded(new ServerConnector.ConnectionCallback<D>(this){

            @Override
            public void connected(@NotNull ServerRuntimeInstance<D> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                onFinished.run();
            }

            @Override
            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                onFinished.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void disconnect() {
        if (this.myConnectionManager != null) {
            this.myConnectionManager.removeConnection(this.myServer);
        }
        this.doDisconnect();
    }

    private void doDisconnect() {
        if (this.myStatus == ConnectionStatus.CONNECTED) {
            if (this.myRuntimeInstance != null) {
                this.myRuntimeInstance.disconnect();
                this.myRuntimeInstance = null;
            }
            this.setStatus(ConnectionStatus.DISCONNECTED);
            for (LogManagersForProject forNextProject : this.myPerProjectLogManagers.values()) {
                forNextProject.disposeAllLogs();
            }
            if (this.myMessageBusConnection != null) {
                this.myMessageBusConnection.disconnect();
                this.myMessageBusConnection = null;
            }
        }
    }

    @Override
    public void deploy(final @NotNull DeploymentTask<D> task2, final @NotNull java.util.function.Consumer<? super String> onDeploymentStarted) {
        if (task2 == null) {
            ServerConnectionImpl.$$$reportNull$$$0(4);
        }
        if (onDeploymentStarted == null) {
            ServerConnectionImpl.$$$reportNull$$$0(5);
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            @Override
            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    2.$$$reportNull$$$0(0);
                }
                LocalDeploymentImpl deployment = new LocalDeploymentImpl(instance, ServerConnectionImpl.this, DeploymentStatus.DEPLOYING, null, null, task2);
                String deploymentName = deployment.getName();
                ServerConnectionImpl.this.myAllDeployments.addLocal(deployment);
                DeploymentLogManagerImpl logManager = ServerConnectionImpl.this.myPerProjectLogManagers.computeIfAbsent(task2.getProject(), x$0 -> new LogManagersForProject((Project)x$0)).findOrCreateManager(deployment).withMainHandlerVisible(true);
                LoggingHandlerImpl handler = logManager.getMainLoggingHandler();
                handler.printlnSystemMessage("Deploying '" + deploymentName + "'...");
                onDeploymentStarted.accept(deploymentName);
                instance.deploy(task2, logManager, new DeploymentOperationCallbackImpl(deploymentName, (DeploymentTaskImpl)task2, handler, deployment));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$2", "connected"));
            }
        });
    }

    @Override
    @Nullable
    public DeploymentLogManager getLogManager(@NotNull Project project, @NotNull Deployment deployment) {
        LogManagersForProject forProject;
        if (project == null) {
            ServerConnectionImpl.$$$reportNull$$$0(6);
        }
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(7);
        }
        return (forProject = this.myPerProjectLogManagers.get(project)) == null ? null : forProject.findManager(deployment);
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project, @NotNull Deployment deployment) {
        if (project == null) {
            ServerConnectionImpl.$$$reportNull$$$0(8);
        }
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(9);
        }
        LogManagersForProject forProject = this.myPerProjectLogManagers.computeIfAbsent(project, x$0 -> new LogManagersForProject((Project)x$0));
        DeploymentLogManagerImpl deploymentLogManagerImpl = forProject.findOrCreateManager(deployment);
        if (deploymentLogManagerImpl == null) {
            ServerConnectionImpl.$$$reportNull$$$0(10);
        }
        return deploymentLogManagerImpl;
    }

    @Override
    public void computeDeployments(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            ServerConnectionImpl.$$$reportNull$$$0(11);
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            @Override
            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    3.$$$reportNull$$$0(0);
                }
                ServerConnectionImpl.this.computeDeployments(instance, onFinished);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$3", "connected"));
            }
        });
    }

    private void computeDeployments(ServerRuntimeInstance<D> instance, final Runnable onFinished) {
        instance.computeDeployments(new ServerRuntimeInstance.ComputeDeploymentsCallback(){
            private final List<DeploymentImpl<?>> myCollectedDeployments = Collections.synchronizedList(new ArrayList());

            @Override
            public void addDeployment(@NotNull String deploymentName) {
                if (deploymentName == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.addDeployment(deploymentName, null);
            }

            @Override
            public void addDeployment(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime) {
                if (deploymentName == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.addDeployment(deploymentName, deploymentRuntime, null, null);
            }

            @Override
            public Deployment addDeployment(@NotNull String name, @Nullable DeploymentRuntime runtime, @Nullable DeploymentStatus status, @Nullable @Nls String statusText) {
                DeploymentImpl result2;
                if (name == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (status == null) {
                    status = DeploymentStatus.DEPLOYED;
                }
                if ((result2 = ServerConnectionImpl.this.myAllDeployments.updateRemoteState(name, runtime, status, statusText)) == null) {
                    result2 = new DeploymentImpl(ServerConnectionImpl.this, name, status, statusText, runtime, null);
                }
                this.myCollectedDeployments.add(result2);
                return result2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void succeeded() {
                List<DeploymentImpl<?>> list2 = this.myCollectedDeployments;
                synchronized (list2) {
                    ServerConnectionImpl.this.myAllDeployments.replaceRemotesWith(this.myCollectedDeployments);
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }

            @Override
            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    4.$$$reportNull$$$0(3);
                }
                ServerConnectionImpl.this.myAllDeployments.replaceRemotesWith(Collections.emptyList());
                ServerConnectionImpl.this.myStatusText = CloudBundle.message("ServerConnectionImpl.error.cannot.obtain.deployments", errorMessage);
                ServerConnectionImpl.this.myEventDispatcher.queueConnectionStatusChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deploymentName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addDeployment";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void undeploy(@NotNull Deployment deployment, @Nullable DeploymentRuntime runtime) {
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(12);
        }
        final String deploymentName = deployment.getName();
        final MyDeployments.UndeployTransition undeployInProgress = this.myAllDeployments.startUndeploy(deploymentName);
        this.myEventDispatcher.queueDeploymentsChanged(this);
        List<LoggingHandlerImpl> handlers = this.myPerProjectLogManagers.values().stream().map(nextForProject -> nextForProject.findManager(deployment)).filter(Objects::nonNull).map(DeploymentLogManagerImpl::getMainLoggingHandler).toList();
        final Consumer logConsumer = message -> {
            if (handlers.isEmpty()) {
                LOG.info(message);
            } else {
                handlers.forEach(h -> h.printlnSystemMessage((String)message));
            }
        };
        logConsumer.consume((Object)("Undeploying '" + deploymentName + "'..."));
        DeploymentRuntime.UndeploymentTaskCallback undeploymentTaskCallback = new DeploymentRuntime.UndeploymentTaskCallback(){

            @Override
            public void succeeded() {
                logConsumer.consume((Object)("'" + deploymentName + "' has been undeployed successfully."));
                LinkedHashSet<String> namesToDispose = new LinkedHashSet<String>();
                namesToDispose.add(deploymentName);
                if (undeployInProgress != null) {
                    undeployInProgress.succeeded();
                    undeployInProgress.getSubDeployments().forEach(deployment -> namesToDispose.add(deployment.getName()));
                }
                namesToDispose.forEach(name -> ServerConnectionImpl.this.disposeAllLogs((String)name));
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.computeDeployments(ServerConnectionImpl.this.myRuntimeInstance, EmptyRunnable.INSTANCE);
            }

            @Override
            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    5.$$$reportNull$$$0(0);
                }
                logConsumer.consume((Object)("Failed to undeploy '" + deploymentName + "': " + errorMessage));
                if (undeployInProgress != null) {
                    undeployInProgress.failed();
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$5", "errorOccurred"));
            }
        };
        if (runtime == null) {
            undeploymentTaskCallback.succeeded();
        } else {
            runtime.undeploy(undeploymentTaskCallback);
        }
    }

    public void disposeAllLogs(@NotNull DeploymentImpl deployment) {
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(13);
        }
        this.disposeAllLogs(deployment.getName());
    }

    public void disposeAllLogs(@NotNull String deploymentName) {
        if (deploymentName == null) {
            ServerConnectionImpl.$$$reportNull$$$0(14);
        }
        this.myPerProjectLogManagers.values().forEach(nextForProject -> nextForProject.disposeManager(deploymentName));
    }

    @Override
    @NotNull
    public Collection<Deployment> getDeployments() {
        Collection<Deployment> collection = this.myAllDeployments.listDeployments();
        if (collection == null) {
            ServerConnectionImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    private void setupProjectListener() {
        if (this.myMessageBusConnection == null) {
            this.myMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            this.myMessageBusConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ServerConnectionImpl.this.onProjectClosed(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$6", "projectClosed"));
                }
            });
        }
    }

    @Override
    public void connectIfNeeded(final ServerConnector.ConnectionCallback<D> callback) {
        ServerRuntimeInstance<D> instance = this.myRuntimeInstance;
        if (instance != null) {
            callback.connected(instance);
            return;
        }
        this.setStatus(ConnectionStatus.CONNECTING);
        this.myConnector.connect(new ServerConnector.ConnectionCallback<D>(){

            @Override
            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    7.$$$reportNull$$$0(0);
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.CONNECTED);
                ServerConnectionImpl.this.myRuntimeInstance = instance;
                ServerConnectionImpl.this.setupProjectListener();
                callback.connected(instance);
            }

            @Override
            public void errorOccurred(@NotNull @Nls String errorMessage) {
                if (errorMessage == null) {
                    7.$$$reportNull$$$0(1);
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.DISCONNECTED, errorMessage);
                ServerConnectionImpl.this.myRuntimeInstance = null;
                callback.errorOccurred(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setStatus(ConnectionStatus status) {
        this.setStatus(status, null);
    }

    private void setStatus(ConnectionStatus status, @Nls String statusText) {
        this.myStatus = status;
        this.myStatusText = statusText;
        this.myEventDispatcher.queueConnectionStatusChanged(this);
    }

    public void changeDeploymentState(@NotNull DeploymentImpl deployment, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable @Nls String statusText) {
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(16);
        }
        if (oldStatus == null) {
            ServerConnectionImpl.$$$reportNull$$$0(17);
        }
        if (newStatus == null) {
            ServerConnectionImpl.$$$reportNull$$$0(18);
        }
        if (this.myAllDeployments.updateAnyState(deployment, deploymentRuntime, oldStatus, newStatus, statusText)) {
            this.myEventDispatcher.queueDeploymentsChanged(this);
        }
    }

    private void onProjectClosed(@NotNull Project project) {
        if (project == null) {
            ServerConnectionImpl.$$$reportNull$$$0(19);
        }
        this.myPerProjectLogManagers.remove(project);
        boolean hasChanged = this.myAllDeployments.removeAllLocalForProject(project);
        if (hasChanged) {
            this.myEventDispatcher.queueDeploymentsChanged(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFinished";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDeploymentStarted";
                break;
            }
            case 6: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStatus";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLogManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLogManager";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLogManager";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeDeployments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "disposeAllLogs";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "changeDeploymentState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onProjectClosed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }

    private static class MyDeployments {
        private final Object myLock = new Object();
        private final Map<String, DeploymentImpl<?>> myRemoteDeployments = new HashMap();
        private final Map<String, LocalDeploymentImpl<?>> myLocalDeployments = new HashMap();
        private List<Deployment> myCachedAllDeployments;
        private final Comparator<? super Deployment> myDeploymentComparator;

        MyDeployments(Comparator<? super Deployment> deploymentComparator) {
            this.myDeploymentComparator = deploymentComparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLocal(@NotNull LocalDeploymentImpl<?> deployment) {
            if (deployment == null) {
                MyDeployments.$$$reportNull$$$0(0);
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myLocalDeployments.put(deployment.getName(), deployment);
                this.myCachedAllDeployments = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceRemotesWith(@NotNull Collection<? extends DeploymentImpl> newDeployments) {
            if (newDeployments == null) {
                MyDeployments.$$$reportNull$$$0(1);
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myRemoteDeployments.clear();
                this.myCachedAllDeployments = null;
                for (DeploymentImpl deploymentImpl : newDeployments) {
                    this.myRemoteDeployments.put(deploymentImpl.getName(), deploymentImpl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public DeploymentImpl updateRemoteState(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus deploymentStatus, @Nullable @Nls String deploymentStatusText) {
            if (deploymentName == null) {
                MyDeployments.$$$reportNull$$$0(2);
            }
            if (deploymentStatus == null) {
                MyDeployments.$$$reportNull$$$0(3);
            }
            Object object = this.myLock;
            synchronized (object) {
                DeploymentImpl<?> result2 = this.myRemoteDeployments.get(deploymentName);
                if (result2 != null && !result2.getStatus().isTransition()) {
                    result2.changeState(result2.getStatus(), deploymentStatus, deploymentStatusText, deploymentRuntime);
                }
                return result2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateAnyState(@NotNull DeploymentImpl deployment, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable @Nls String statusText) {
            if (deployment == null) {
                MyDeployments.$$$reportNull$$$0(4);
            }
            if (oldStatus == null) {
                MyDeployments.$$$reportNull$$$0(5);
            }
            if (newStatus == null) {
                MyDeployments.$$$reportNull$$$0(6);
            }
            Object object = this.myLock;
            synchronized (object) {
                return deployment.changeState(oldStatus, newStatus, statusText, deploymentRuntime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public Collection<Deployment> listDeployments() {
            Object object = this.myLock;
            // MONITORENTER : object
            if (this.myCachedAllDeployments == null) {
                Collection<Deployment> result2 = this.doListDeployments();
                this.myCachedAllDeployments = List.copyOf(result2);
            }
            List<Deployment> list2 = this.myCachedAllDeployments;
            // MONITOREXIT : object
            if (list2 != null) return list2;
            MyDeployments.$$$reportNull$$$0(7);
            return list2;
        }

        private Collection<Deployment> doListDeployments() {
            TreeMap<Deployment, Object> orderedDeployments = new TreeMap<Deployment, Object>(this.myDeploymentComparator);
            ArrayList matchedLocalsBefore = new ArrayList();
            for (LocalDeploymentImpl<?> localDeployment : this.myLocalDeployments.values()) {
                if (localDeployment.hasRemoteDeloyment()) {
                    matchedLocalsBefore.add(localDeployment);
                }
                localDeployment.setRemoteDeployment(null);
                orderedDeployments.put((Deployment)localDeployment, localDeployment);
            }
            LinkedHashSet<Deployment> result2 = new LinkedHashSet<Deployment>(orderedDeployments.keySet());
            for (DeploymentImpl deploymentImpl : this.myRemoteDeployments.values()) {
                DeploymentImpl deploymentImpl2 = (DeploymentImpl)orderedDeployments.get(deploymentImpl);
                if (deploymentImpl2 != null) {
                    if (!(deploymentImpl2 instanceof LocalDeploymentImpl)) continue;
                    ((LocalDeploymentImpl)deploymentImpl2).setRemoteDeployment(deploymentImpl);
                    continue;
                }
                orderedDeployments.put(deploymentImpl, deploymentImpl);
            }
            DeploymentStatus finishedExternally = DeploymentStatus.NOT_DEPLOYED;
            for (LocalDeploymentImpl localDeploymentImpl : matchedLocalsBefore) {
                if (localDeploymentImpl.hasRemoteDeloyment()) continue;
                localDeploymentImpl.changeState(localDeploymentImpl.getStatus(), finishedExternally, null, null);
            }
            result2.addAll(orderedDeployments.keySet());
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAllLocalForProject(@NotNull Project project) {
            if (project == null) {
                MyDeployments.$$$reportNull$$$0(8);
            }
            Object object = this.myLock;
            synchronized (object) {
                boolean hasChanged = false;
                Iterator<LocalDeploymentImpl<?>> it = this.myLocalDeployments.values().iterator();
                while (it.hasNext()) {
                    LocalDeploymentImpl<?> nextLocal = it.next();
                    if (nextLocal.getDeploymentTask().getProject() != project) continue;
                    it.remove();
                    hasChanged = true;
                }
                if (hasChanged) {
                    this.myCachedAllDeployments = null;
                }
                return hasChanged;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public UndeployTransition startUndeploy(@NotNull String deploymentName) {
            if (deploymentName == null) {
                MyDeployments.$$$reportNull$$$0(9);
            }
            Object object = this.myLock;
            synchronized (object) {
                DeploymentImpl<?> deployment = (DeploymentImpl<?>)this.myLocalDeployments.get(deploymentName);
                if (deployment == null) {
                    deployment = this.myRemoteDeployments.get(deploymentName);
                }
                return deployment == null ? null : new UndeployTransition(deployment, this.collectDeepChildren(deployment));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private List<Deployment> collectDeepChildren(@NotNull Deployment root) {
            if (root == null) {
                MyDeployments.$$$reportNull$$$0(10);
            }
            DeepChildrenCollector collector = new DeepChildrenCollector(root.getRuntime());
            Object object = this.myLock;
            synchronized (object) {
                for (LocalDeploymentImpl<?> localDeploymentImpl : this.myLocalDeployments.values()) {
                    collector.visitDeployment(localDeploymentImpl);
                }
                for (DeploymentImpl deploymentImpl : this.myRemoteDeployments.values()) {
                    collector.visitDeployment(deploymentImpl);
                }
            }
            List<Deployment> list2 = collector.getChildDeployments();
            if (list2 == null) {
                MyDeployments.$$$reportNull$$$0(11);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newDeployments";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentStatus";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldStatus";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newStatus";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listDeployments";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectDeepChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addLocal";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceRemotesWith";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateRemoteState";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAnyState";
                    break;
                }
                case 7: 
                case 11: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAllLocalForProject";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "startUndeploy";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDeepChildren";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 11 -> new IllegalStateException(string);
            };
        }

        private class UndeployTransition {
            private final DeploymentImpl<?> myDeployment;
            private final List<Deployment> mySubDeployments;

            UndeployTransition(@NotNull DeploymentImpl<?> deployment, List<Deployment> subDeployments) {
                if (deployment == null) {
                    UndeployTransition.$$$reportNull$$$0(0);
                }
                if (subDeployments == null) {
                    UndeployTransition.$$$reportNull$$$0(1);
                }
                this.myDeployment = deployment;
                this.mySubDeployments = new ArrayList<Deployment>(subDeployments);
                this.myDeployment.changeState(DeploymentStatus.DEPLOYED, DeploymentStatus.DEPLOYING, null, deployment.getRuntime());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void succeeded() {
                Object object = MyDeployments.this.myLock;
                synchronized (object) {
                    if (this.tryChangeToTerminalState(DeploymentStatus.NOT_DEPLOYED, true) || this.myDeployment.getRuntime() == null) {
                        this.forgetDeployment(this.myDeployment);
                        for (Deployment nextImplicitlyUndeployed : this.mySubDeployments) {
                            if (nextImplicitlyUndeployed == this.myDeployment) continue;
                            this.forgetDeployment(nextImplicitlyUndeployed);
                        }
                        MyDeployments.this.myCachedAllDeployments = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed() {
                Object object = MyDeployments.this.myLock;
                synchronized (object) {
                    this.tryChangeToTerminalState(DeploymentStatus.DEPLOYED, false);
                }
            }

            @NotNull
            public Iterable<Deployment> getSubDeployments() {
                List<Deployment> list2 = this.mySubDeployments;
                if (list2 == null) {
                    UndeployTransition.$$$reportNull$$$0(2);
                }
                return list2;
            }

            private boolean tryChangeToTerminalState(DeploymentStatus terminalState, boolean forgetRuntime) {
                DeploymentRuntime targetRuntime = forgetRuntime ? null : this.myDeployment.getRuntime();
                return this.myDeployment.changeState(DeploymentStatus.DEPLOYING, terminalState, null, targetRuntime);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void forgetDeployment(@NotNull Deployment deployment) {
                if (deployment == null) {
                    UndeployTransition.$$$reportNull$$$0(3);
                }
                Object object = MyDeployments.this.myLock;
                synchronized (object) {
                    String deploymentName = deployment.getName();
                    MyDeployments.this.myLocalDeployments.remove(deploymentName);
                    MyDeployments.this.myRemoteDeployments.remove(deploymentName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deployment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "subDeployments";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments$UndeployTransition";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments$UndeployTransition";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubDeployments";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "forgetDeployment";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        private static class DeepChildrenCollector {
            private final Map<DeploymentRuntime, Boolean> mySettledStatuses = new IdentityHashMap<DeploymentRuntime, Boolean>();
            private final List<Deployment> myCollectedChildren = new LinkedList<Deployment>();
            private final DeploymentRuntime myRootRuntime;

            DeepChildrenCollector(DeploymentRuntime rootRuntime) {
                this.myRootRuntime = rootRuntime;
            }

            public void visitDeployment(@NotNull Deployment deployment) {
                if (deployment == null) {
                    DeepChildrenCollector.$$$reportNull$$$0(0);
                }
                if (this.isUnderRootRuntime(deployment.getRuntime())) {
                    this.myCollectedChildren.add(deployment);
                }
            }

            private boolean isUnderRootRuntime(@Nullable DeploymentRuntime runtime) {
                if (runtime == null) {
                    return false;
                }
                if (runtime == this.myRootRuntime) {
                    return true;
                }
                return this.mySettledStatuses.computeIfAbsent(runtime, rt -> this.isUnderRootRuntime(rt.getParent()));
            }

            public List<Deployment> getChildDeployments() {
                return Collections.unmodifiableList(this.myCollectedChildren);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments$DeepChildrenCollector", "visitDeployment"));
            }
        }
    }

    private class LogManagersForProject {
        private final Project myProject;
        private final Map<String, DeploymentLogManagerImpl> myLogManagers;

        LogManagersForProject(Project project) {
            if (project == null) {
                LogManagersForProject.$$$reportNull$$$0(0);
            }
            this.myLogManagers = new ConcurrentHashMap<String, DeploymentLogManagerImpl>();
            this.myProject = project;
        }

        @Nullable
        public DeploymentLogManagerImpl findManager(@NotNull Deployment deployment) {
            if (deployment == null) {
                LogManagersForProject.$$$reportNull$$$0(1);
            }
            return this.myLogManagers.get(deployment.getName());
        }

        public DeploymentLogManagerImpl findOrCreateManager(@NotNull Deployment deployment) {
            if (deployment == null) {
                LogManagersForProject.$$$reportNull$$$0(2);
            }
            return this.myLogManagers.computeIfAbsent(deployment.getName(), this::newDeploymentLogManager);
        }

        private DeploymentLogManagerImpl newDeploymentLogManager(String deploymentName) {
            return new DeploymentLogManagerImpl(this.myProject, new ChangeListener());
        }

        public void disposeManager(@NotNull String deploymentName) {
            DeploymentLogManagerImpl manager;
            if (deploymentName == null) {
                LogManagersForProject.$$$reportNull$$$0(3);
            }
            if ((manager = this.myLogManagers.remove(deploymentName)) != null) {
                manager.disposeLogs();
            }
        }

        public void disposeAllLogs() {
            for (DeploymentLogManagerImpl nextManager : this.myLogManagers.values()) {
                nextManager.disposeLogs();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$LogManagersForProject";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findOrCreateManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disposeManager";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChangeListener
    implements Runnable {
        private ChangeListener() {
        }

        @Override
        public void run() {
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }
    }

    private class DeploymentOperationCallbackImpl
    implements ServerRuntimeInstance.DeploymentOperationCallback {
        private final String myDeploymentName;
        private final DeploymentTaskImpl<D> myDeploymentTask;
        private final LoggingHandlerImpl myLoggingHandler;
        private final DeploymentImpl<?> myDeployment;

        DeploymentOperationCallbackImpl(String deploymentName, DeploymentTaskImpl<D> deploymentTask, LoggingHandlerImpl handler, DeploymentImpl<?> deployment) {
            this.myDeploymentName = deploymentName;
            this.myDeploymentTask = deploymentTask;
            this.myLoggingHandler = handler;
            this.myDeployment = deployment;
        }

        @Override
        public void started(@NotNull DeploymentRuntime deploymentRuntime) {
            if (deploymentRuntime == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(0);
            }
            this.myDeployment.changeState(this.myDeployment.getStatus(), DeploymentStatus.DEPLOYING, null, deploymentRuntime);
        }

        @Override
        public Deployment succeeded(@NotNull DeploymentRuntime deploymentRuntime) {
            if (deploymentRuntime == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(1);
            }
            this.myLoggingHandler.printlnSystemMessage("'" + this.myDeploymentName + "' has been deployed successfully.");
            this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.DEPLOYED, null, deploymentRuntime);
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            DebugConnector<?, ?> debugConnector = this.myDeploymentTask.getDebugConnector();
            if (debugConnector != null) {
                this.launchDebugger(debugConnector, deploymentRuntime);
            }
            return this.myDeployment;
        }

        private <D extends DebugConnectionData, R extends DeploymentRuntime> void launchDebugger(@NotNull DebugConnector<D, R> debugConnector, @NotNull DeploymentRuntime runtime) {
            if (debugConnector == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(2);
            }
            if (runtime == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(3);
            }
            try {
                Object debugInfo = debugConnector.getConnectionData(runtime);
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        debugConnector.getLauncher().startDebugSession((DebugConnectionData)debugInfo, this.myDeploymentTask.getExecutionEnvironment(), ServerConnectionImpl.this.myServer);
                    }
                    catch (ExecutionException e) {
                        this.myLoggingHandler.print("Cannot start debugger: " + e.getMessage() + "\n");
                        LOG.info((Throwable)e);
                    }
                });
            }
            catch (DebugConnectionDataNotAvailableException e) {
                this.myLoggingHandler.print("Cannot retrieve debug connection: " + e.getMessage() + "\n");
                LOG.info((Throwable)e);
            }
        }

        @Override
        public void errorOccurred(@NotNull @Nls String errorMessage) {
            if (errorMessage == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(4);
            }
            this.myLoggingHandler.printlnSystemMessage("Failed to deploy '" + this.myDeploymentName + "': " + errorMessage);
            ServerConnectionImpl.this.myAllDeployments.updateAnyState(this.myDeployment, null, DeploymentStatus.DEPLOYING, DeploymentStatus.NOT_DEPLOYED, errorMessage);
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }

        @Override
        public void errorOccurred(@NotNull @Nls String errorMessage, @NotNull DeploymentRuntime failedDeployment) {
            if (errorMessage == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(5);
            }
            if (failedDeployment == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(6);
            }
            this.myLoggingHandler.printlnSystemMessage("Failed to deploy '" + this.myDeploymentName + "': " + errorMessage);
            this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.NOT_DEPLOYED, errorMessage, failedDeployment);
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentRuntime";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugConnector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtime";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "failedDeployment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "started";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "succeeded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "launchDebugger";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ConnectionCallbackBase<D extends DeploymentConfiguration>
    implements ServerConnector.ConnectionCallback<D> {
        private ConnectionCallbackBase() {
        }

        @Override
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ConnectionCallbackBase.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$ConnectionCallbackBase", "errorOccurred"));
        }
    }
}

