/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewImpl;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ExporterToTextFile
implements com.intellij.ide.ExporterToTextFile {
    private final UsageViewImpl myUsageView;
    @NotNull
    private final UsageViewSettings myUsageViewSettings;

    public ExporterToTextFile(@NotNull UsageViewImpl usageView, @NotNull UsageViewSettings usageViewSettings) {
        if (usageView == null) {
            ExporterToTextFile.$$$reportNull$$$0(0);
        }
        if (usageViewSettings == null) {
            ExporterToTextFile.$$$reportNull$$$0(1);
        }
        this.myUsageView = usageView;
        this.myUsageViewSettings = usageViewSettings;
    }

    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        this.appendNode(buf, this.myUsageView.getModelRoot(), System.lineSeparator(), "");
        String string = buf.toString();
        if (string == null) {
            ExporterToTextFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void appendNode(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator, String indent) {
        Object childIndent;
        buf.append(indent);
        if (node.getParent() != null) {
            childIndent = indent + "    ";
            this.appendNodeText(buf, node, lineSeparator);
        } else {
            childIndent = indent;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child, lineSeparator, (String)childIndent);
        }
    }

    private void appendNodeText(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator) {
        if (node instanceof Node && ((Node)node).isExcluded()) {
            buf.append("(").append(UsageViewBundle.message("usage.excluded", new Object[0])).append(") ");
        }
        if (node instanceof UsageNode) {
            this.appendUsageNodeText(buf, (UsageNode)node);
        } else if (node instanceof GroupNode) {
            UsageGroup group = ((GroupNode)node).getGroup();
            buf.append(group != null ? group.getPresentableGroupText() : UsageViewBundle.message("usages.title", new Object[0]));
            buf.append(" ");
            int count = ((GroupNode)node).getRecursiveUsageCount();
            buf.append(" (").append(UsageViewBundle.message("usages.n", count)).append(")");
        } else if (node instanceof UsageTargetNode) {
            buf.append(((UsageTargetNode)node).getTarget().getPresentation().getPresentableText());
        } else {
            buf.append(node.toString());
        }
        buf.append(lineSeparator);
    }

    protected void appendUsageNodeText(StringBuilder buf, UsageNode node) {
        TextChunk[] chunks = node.getUsage().getPresentation().getText();
        int chunkCount = 0;
        for (TextChunk chunk : chunks) {
            if (chunkCount == 1) {
                buf.append(" ");
            }
            buf.append(chunk.getText());
            ++chunkCount;
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        String string = this.myUsageViewSettings.getExportFileName();
        if (string == null) {
            ExporterToTextFile.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void exportedTo(@NotNull String filePath) {
        if (filePath == null) {
            ExporterToTextFile.$$$reportNull$$$0(4);
        }
        this.myUsageViewSettings.setExportFileName(filePath);
    }

    public boolean canExport() {
        return !this.myUsageView.isSearchInProgress() && this.myUsageView.areTargetsValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/ExporterToTextFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/ExporterToTextFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportedTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

