/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import org.assertj.core.util.NullSafeComparator;

public class DoubleComparator
extends NullSafeComparator<Double> {
    private double precision;

    public DoubleComparator(double epsilon) {
        this.precision = epsilon;
    }

    @Override
    protected int compareNonNull(Double x, Double y) {
        if (DoubleComparator.closeEnough(x, y, this.precision)) {
            return 0;
        }
        return x < y ? -1 : 1;
    }

    public double getEpsilon() {
        return this.precision;
    }

    private static boolean closeEnough(Double x, Double y, double epsilon) {
        return x.doubleValue() == y.doubleValue() || Math.abs(x - y) <= epsilon;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.precision);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleComparator)) {
            return false;
        }
        DoubleComparator other = (DoubleComparator)obj;
        return Double.doubleToLongBits(this.precision) == Double.doubleToLongBits(other.precision);
    }

    public String toString() {
        return "DoubleComparator[precision=%s]".formatted(this.precision);
    }
}

