/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.util.io.NettyKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\"\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/ide/StartUpMeasurementService;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.platform.builtInServer.impl"})
public final class StartUpMeasurementService
extends RestService {
    @Override
    @NotNull
    protected String getServiceName() {
        return "startUpMeasurement";
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = NettyKt.getOrigin((HttpRequest)request);
        return Intrinsics.areEqual((Object)string, (Object)"https://ij-perf.jetbrains.com") || Intrinsics.areEqual((Object)string, (Object)"https://ij-perf.labs.jb.gg") ? HttpRequestHandler.OriginCheckResult.ALLOW : super.isOriginAllowed(request);
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StartUpPerformanceService reporter = StartUpPerformanceService.Companion.getInstance();
        ByteBuffer byteBuffer = reporter.getLastReport();
        if (byteBuffer == null) {
            return "{\"error\": \"Report is not ready yet, start-up in progress\"}";
        }
        ByteBuffer lastReport = byteBuffer;
        FullHttpResponse response = Responses.response((String)"application/json", (ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)lastReport));
        RestService.Companion.sendResponse((HttpRequest)request, context, (HttpResponse)response);
        return null;
    }
}

