/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\rH$J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/io/webSocket/WebSocketProtocolHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "<init>", "()V", "channelRead", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "message", "", "textFrameReceived", "channel", "Lio/netty/channel/Channel;", "Lio/netty/handler/codec/http/websocketx/TextWebSocketFrame;", "closeFrameReceived", "Lio/netty/handler/codec/http/websocketx/CloseWebSocketFrame;", "exceptionCaught", "cause", "", "intellij.platform.builtInServer.impl"})
public abstract class WebSocketProtocolHandler
extends ChannelInboundHandlerAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = message;
        if (!(object instanceof WebSocketFrame) || object instanceof PongWebSocketFrame) {
            ReferenceCountUtil.release((Object)message);
        } else if (object instanceof PingWebSocketFrame) {
            context.channel().writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)message).content()));
        } else if (object instanceof CloseWebSocketFrame) {
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            this.closeFrameReceived(channel, (CloseWebSocketFrame)message);
        } else if (object instanceof TextWebSocketFrame) {
            try {
                Channel channel = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                this.textFrameReceived(channel, (TextWebSocketFrame)message);
            }
            finally {
                if (((TextWebSocketFrame)message).refCnt() > 0) {
                    ((TextWebSocketFrame)message).release();
                }
            }
        } else {
            throw new UnsupportedOperationException(message.getClass().getName() + " frame types not supported");
        }
    }

    protected abstract void textFrameReceived(@NotNull Channel var1, @NotNull TextWebSocketFrame var2);

    protected void closeFrameReceived(@NotNull Channel channel, @NotNull CloseWebSocketFrame message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        channel.close();
        message.release();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        NettyUtil.logAndClose((Throwable)cause, (Logger)BuiltInWebServerKt.getLOG(), (Channel)context.channel());
    }
}

