/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.InlayHintsProviderExtension;
import com.intellij.codeInsight.hints.InlayHintsProviderExtensionBean;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.Topic;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="InlayHintsSettings", storages={@Storage(value="editor.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0007\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003567B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010J\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000eJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u0010J9\u0010\u001f\u001a\u0002H \"\b\b\u0000\u0010 *\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H 0\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"\u00a2\u0006\u0002\u0010#J3\u0010$\u001a\u00020\u0012\"\b\b\u0000\u0010 *\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H 0\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u0002H \u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010(\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010'\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010)\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u001a\u0010(\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010*\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u0002H\u0016J-\u0010-\u001a\u0002H \"\b\b\u0000\u0010 *\u00020\u000b2\u0006\u0010.\u001a\u00020\u000e2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0002\u00a2\u0006\u0002\u00100J'\u00101\u001a\u0002H \"\b\b\u0000\u0010 *\u00020\u000b2\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u0002H H\u0002\u00a2\u0006\u0002\u00102J\u001c\u00103\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u00104\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/codeInsight/hints/InlayHintsSettings$State;", "<init>", "()V", "listener", "Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "getListener", "()Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "myState", "lock", "", "myCachedSettingsMap", "", "", "isEnabledByDefaultIdsCache", "", "changeHintTypeStatus", "", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "language", "Lcom/intellij/lang/Language;", "enable", "setHintsEnabledForLanguage", "enabled", "saveLastViewedProviderId", "providerId", "getLastViewedProviderId", "setEnabledGlobally", "hintsEnabledGlobally", "findSettings", "T", "createSettings", "Lkotlin/Function0;", "(Lcom/intellij/codeInsight/hints/SettingsKey;Lcom/intellij/lang/Language;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "storeSettings", "value", "(Lcom/intellij/codeInsight/hints/SettingsKey;Lcom/intellij/lang/Language;Ljava/lang/Object;)V", "hintsEnabled", "hintsShouldBeShown", "explicitlyDisabled", "getState", "loadState", "state", "getSettingCached", "id", "settings", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getSettingNotCached", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "isEnabledByDefault", "computeIsEnabledByDefault", "Companion", "State", "SettingsListener", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nInlayHintsSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsSettings.kt\ncom/intellij/codeInsight/hints/InlayHintsSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n296#2,2:263\n*S KotlinDebug\n*F\n+ 1 InlayHintsSettings.kt\ncom/intellij/codeInsight/hints/InlayHintsSettings\n*L\n237#1:263,2\n*E\n"})
public final class InlayHintsSettings
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State myState = new State();
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final Map<String, Object> myCachedSettingsMap = new HashMap();
    @NotNull
    private final Map<String, Boolean> isEnabledByDefaultIdsCache = new HashMap();
    @Topic.AppLevel
    @JvmField
    @NotNull
    public static final Topic<SettingsListener> INLAY_SETTINGS_CHANGED = new Topic(SettingsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);

    public InlayHintsSettings() {
        InlayHintsProviderExtension.INSTANCE.getInlayProviderName().addChangeListener(() -> InlayHintsSettings._init_$lambda$0(this), null);
    }

    private final SettingsListener getListener() {
        return (SettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(INLAY_SETTINGS_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changeHintTypeStatus(@NotNull SettingsKey<?> key, @NotNull Language language, boolean enable) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = false;
            String id = key.getFullId(language);
            if (enable) {
                if (!this.isEnabledByDefault(key, language)) {
                    this.myState.getEnabledHintProviderIds().add(id);
                }
                bl = this.myState.getDisabledHintProviderIds().remove(id);
            } else {
                this.myState.getEnabledHintProviderIds().remove(id);
                bl = this.myState.getDisabledHintProviderIds().add(id);
            }
            boolean bl3 = bl;
        }
        this.getListener().settingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHintsEnabledForLanguage(@NotNull Language language, boolean enabled) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            String string = language.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            String id = string;
            bl = enabled ? this.myState.getDisabledLanguages().remove(id) : this.myState.getDisabledLanguages().add(id);
        }
        boolean settingsChanged = bl;
        if (settingsChanged) {
            this.getListener().languageStatusChanged();
            this.getListener().settingsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveLastViewedProviderId(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.myState.setLastViewedProviderKeyId(providerId);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final String getLastViewedProviderId() {
        return this.myState.getLastViewedProviderKeyId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEnabledGlobally(boolean enabled) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = false;
            if (this.myState.isEnabled() != enabled) {
                this.myState.setEnabled(enabled);
                this.getListener().globalEnabledStatusChanged(enabled);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean settingsChanged = bl;
        if (settingsChanged) {
            this.getListener().settingsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsEnabledGlobally() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.myState.isEnabled();
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T findSettings(@NotNull SettingsKey<T> key, @NotNull Language language, @NotNull Function0<? extends T> createSettings) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(createSettings, (String)"createSettings");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            String fullId = key.getFullId(language);
            T t = this.getSettingCached(fullId, createSettings);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void storeSettings(@NotNull SettingsKey<T> key, @NotNull Language language, @NotNull T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            String fullId = key.getFullId(language);
            this.myCachedSettingsMap.put(fullId, value);
            Element element = this.myState.getSettingsMapElement().clone();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"clone(...)");
            Element element2 = element;
            element2.removeChild(fullId);
            Element serialized = XmlSerializer.serialize$default(value, null, (boolean)false, (int)6, null);
            if (serialized == null) {
                this.myState.setSettingsMapElement(element2);
            } else {
                Element storeElement = new Element(fullId);
                Element wrappedSettingsElement = storeElement.addContent(serialized);
                Element element3 = element2.addContent(wrappedSettingsElement);
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"addContent(...)");
                this.myState.setSettingsMapElement(element3);
                element2.sortAttributes(new Comparator(){

                    public final int compare(T a, T b) {
                        Attribute it = (Attribute)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (Attribute)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
        this.getListener().settingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsEnabled(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = !this.myState.getDisabledLanguages().contains(language.getID());
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsShouldBeShown(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (this.hintsEnabledGlobally()) break block4;
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = this.hintsEnabled(language);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsEnabled(@NotNull SettingsKey<?> key, @NotNull Language language) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = this.lock;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (!this.explicitlyDisabled(language, key)) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                if (!this.isEnabledByDefault(key, language)) break block6;
                boolean bl = true;
                return bl;
            }
            boolean bl = this.getState().getEnabledHintProviderIds().contains(key.getFullId(language));
            return bl;
        }
    }

    private final boolean explicitlyDisabled(Language language, SettingsKey<?> key) {
        for (Language lang = language; lang != null; lang = lang.getBaseLanguage()) {
            if (!this.myState.getDisabledHintProviderIds().contains(key.getFullId(lang))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsShouldBeShown(@NotNull SettingsKey<?> key, @NotNull Language language) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.hintsEnabledGlobally() && this.hintsEnabled(language) && this.hintsEnabled(key, language);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public State getState() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            State state = this.myState;
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = this.lock;
        synchronized (object) {
            boolean elementChanged;
            boolean bl = false;
            boolean bl2 = elementChanged = !Intrinsics.areEqual((Object)this.myState.getSettingsMapElement(), (Object)state.getSettingsMapElement());
            if (elementChanged) {
                this.myCachedSettingsMap.clear();
            }
            this.myState = state;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T getSettingCached(String id, Function0<? extends T> settings) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                Object cachedValue = this.myCachedSettingsMap.get(id);
                if (cachedValue == null) break block4;
                Object object2 = cachedValue;
                return (T)object2;
            }
            Object notCachedSettings = this.getSettingNotCached(id, settings.invoke());
            this.myCachedSettingsMap.put(id, notCachedSettings);
            Object object3 = notCachedSettings;
            return (T)object3;
        }
    }

    private final <T> T getSettingNotCached(String id, T settings) {
        Element state = this.myState.getSettingsMapElement();
        Element settingsElement = state.getChild(id);
        if (settingsElement == null) {
            return settings;
        }
        List settingsElementChildren = settingsElement.getChildren();
        if (settingsElementChildren.isEmpty()) {
            return settings;
        }
        Intrinsics.checkNotNull((Object)settingsElementChildren);
        Object object = CollectionsKt.first((List)settingsElementChildren);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        XmlSerializer.deserializeInto((Element)((Element)object), settings);
        return settings;
    }

    private final boolean isEnabledByDefault(SettingsKey<?> key, Language language) {
        Boolean bl = this.isEnabledByDefaultIdsCache.computeIfAbsent(key.getFullId(language), arg_0 -> InlayHintsSettings.isEnabledByDefault$lambda$1(arg_0 -> InlayHintsSettings.isEnabledByDefault$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    private final boolean computeIsEnabledByDefault(String id) {
        Object v2;
        block4: {
            Iterable $this$firstOrNull$iv = InlayHintsProviderExtension.INSTANCE.getInlayProviderName().getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                InlayHintsProviderExtensionBean it = (InlayHintsProviderExtensionBean)((Object)element$iv);
                boolean bl2 = false;
                if (it.getSettingsKeyId() == null) {
                    bl = false;
                } else {
                    String keyId;
                    String string = it.getLanguage();
                    Intrinsics.checkNotNull((Object)string);
                    bl = Intrinsics.areEqual((Object)SettingsKey.Companion.getFullId(string, keyId), (Object)id);
                }
                if (!bl) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        InlayHintsProviderExtensionBean inlayHintsProviderExtensionBean = v2;
        if (inlayHintsProviderExtensionBean == null) {
            return true;
        }
        InlayHintsProviderExtensionBean bean = inlayHintsProviderExtensionBean;
        return bean.isEnabledByDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$0(InlayHintsSettings this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.isEnabledByDefaultIdsCache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Boolean isEnabledByDefault$lambda$0(InlayHintsSettings this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.computeIsEnabledByDefault(it);
    }

    private static final Boolean isEnabledByDefault$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final InlayHintsSettings instance() {
        return Companion.instance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "INLAY_SETTINGS_CHANGED", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "intellij.platform.lang"})
    @SourceDebugExtension(value={"SMAP\nInlayHintsSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsSettings.kt\ncom/intellij/codeInsight/hints/InlayHintsSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,262:1\n30#2,2:263\n*S KotlinDebug\n*F\n+ 1 InlayHintsSettings.kt\ncom/intellij/codeInsight/hints/InlayHintsSettings$Companion\n*L\n21#1:263,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InlayHintsSettings instance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<InlayHintsSettings> serviceClass$iv = InlayHintsSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InlayHintsSettings)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "", "globalEnabledStatusChanged", "", "newEnabled", "", "languageStatusChanged", "settingsChanged", "intellij.platform.lang"})
    public static interface SettingsListener {
        default public void globalEnabledStatusChanged(boolean newEnabled) {
        }

        default public void languageStatusChanged() {
        }

        default public void settingsChanged() {
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\b\"\u0004\b \u0010\n\u00a8\u0006!"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings$State;", "", "<init>", "()V", "enabledHintProviderIds", "Ljava/util/TreeSet;", "", "getEnabledHintProviderIds", "()Ljava/util/TreeSet;", "setEnabledHintProviderIds", "(Ljava/util/TreeSet;)V", "disabledHintProviderIds", "getDisabledHintProviderIds", "setDisabledHintProviderIds", "settingsMapElement", "Lorg/jdom/Element;", "getSettingsMapElement", "()Lorg/jdom/Element;", "setSettingsMapElement", "(Lorg/jdom/Element;)V", "lastViewedProviderKeyId", "getLastViewedProviderKeyId", "()Ljava/lang/String;", "setLastViewedProviderKeyId", "(Ljava/lang/String;)V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "disabledLanguages", "getDisabledLanguages", "setDisabledLanguages", "intellij.platform.lang"})
    public static final class State {
        @NotNull
        private TreeSet<String> enabledHintProviderIds = SetsKt.sortedSetOf((Object[])new String[0]);
        @NotNull
        private TreeSet<String> disabledHintProviderIds = SetsKt.sortedSetOf((Object[])new String[0]);
        @NotNull
        private Element settingsMapElement = new Element("settingsMapElement");
        @Nullable
        private String lastViewedProviderKeyId;
        private boolean isEnabled = true;
        @NotNull
        private TreeSet<String> disabledLanguages = SetsKt.sortedSetOf((Object[])new String[0]);

        @NotNull
        public final TreeSet<String> getEnabledHintProviderIds() {
            return this.enabledHintProviderIds;
        }

        public final void setEnabledHintProviderIds(@NotNull TreeSet<String> treeSet) {
            Intrinsics.checkNotNullParameter(treeSet, (String)"<set-?>");
            this.enabledHintProviderIds = treeSet;
        }

        @NotNull
        public final TreeSet<String> getDisabledHintProviderIds() {
            return this.disabledHintProviderIds;
        }

        public final void setDisabledHintProviderIds(@NotNull TreeSet<String> treeSet) {
            Intrinsics.checkNotNullParameter(treeSet, (String)"<set-?>");
            this.disabledHintProviderIds = treeSet;
        }

        @NotNull
        public final Element getSettingsMapElement() {
            return this.settingsMapElement;
        }

        public final void setSettingsMapElement(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"<set-?>");
            this.settingsMapElement = element;
        }

        @Nullable
        public final String getLastViewedProviderKeyId() {
            return this.lastViewedProviderKeyId;
        }

        public final void setLastViewedProviderKeyId(@Nullable String string) {
            this.lastViewedProviderKeyId = string;
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        @NotNull
        public final TreeSet<String> getDisabledLanguages() {
            return this.disabledLanguages;
        }

        public final void setDisabledLanguages(@NotNull TreeSet<String> treeSet) {
            Intrinsics.checkNotNullParameter(treeSet, (String)"<set-?>");
            this.disabledLanguages = treeSet;
        }
    }
}

