/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileDownloaderImpl
implements FileDownloader {
    private static final Logger LOG = Logger.getInstance(FileDownloaderImpl.class);
    private static final String LIB_SCHEMA = "lib://";
    private final List<? extends DownloadableFileDescription> myFileDescriptions;
    private final JComponent myParentComponent;
    @Nullable
    private final Project myProject;
    private String myDirectoryForDownloadedFilesPath;
    @NlsContexts.DialogTitle
    private final String myDialogTitle;

    FileDownloaderImpl(@NotNull List<? extends DownloadableFileDescription> fileDescriptions, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull String presentableDownloadName) {
        if (fileDescriptions == null) {
            FileDownloaderImpl.$$$reportNull$$$0(0);
        }
        if (presentableDownloadName == null) {
            FileDownloaderImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFileDescriptions = fileDescriptions;
        this.myParentComponent = parentComponent;
        this.myDialogTitle = IdeCoreBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)presentableDownloadName)});
    }

    @Nullable
    public List<VirtualFile> downloadFilesWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project, @Nullable JComponent parentComponent) {
        List<Pair<VirtualFile, DownloadableFileDescription>> pairs = this.downloadWithProgress(targetDirectoryPath, project, parentComponent);
        if (pairs == null) {
            return null;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (Pair<VirtualFile, DownloadableFileDescription> pair : pairs) {
            files.add((VirtualFile)pair.getFirst());
        }
        return files;
    }

    @Nullable
    public List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project, @Nullable JComponent parentComponent) {
        File dir;
        if (targetDirectoryPath != null) {
            dir = new File(targetDirectoryPath);
        } else {
            VirtualFile virtualDir = FileDownloaderImpl.chooseDirectoryForFiles(project, parentComponent);
            if (virtualDir != null) {
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)virtualDir);
            } else {
                return null;
            }
        }
        return this.downloadWithProcess(dir, project, parentComponent);
    }

    @Nullable
    public CompletableFuture<List<Pair<VirtualFile, DownloadableFileDescription>>> downloadWithBackgroundProgress(@Nullable String targetDirectoryPath, @Nullable Project project) {
        File dir;
        if (targetDirectoryPath != null) {
            dir = new File(targetDirectoryPath);
        } else {
            VirtualFile virtualDir = FileDownloaderImpl.chooseDirectoryForFiles(project, null);
            if (virtualDir != null) {
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)virtualDir);
            } else {
                return null;
            }
        }
        return this.downloadWithBackgroundProcess(dir, project);
    }

    @Nullable
    private List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProcess(File targetDir, Project project, JComponent parentComponent) {
        Ref localFiles = Ref.create(null);
        Ref exceptionRef = Ref.create(null);
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                localFiles.set(this.download(targetDir));
            }
            catch (IOException e) {
                exceptionRef.set((Object)e);
            }
        }, this.myDialogTitle, true, project, parentComponent);
        if (!completed) {
            return null;
        }
        Exception exception = (Exception)exceptionRef.get();
        if (exception != null) {
            boolean tryAgain = IdeUiService.getInstance().showErrorDialog(this.myDialogTitle, exception.getMessage());
            if (tryAgain) {
                return this.downloadWithProcess(targetDir, project, parentComponent);
            }
            return null;
        }
        return FileDownloaderImpl.findVirtualFiles((List)localFiles.get());
    }

    private @NotNull CompletableFuture<@Nullable List<Pair<VirtualFile, DownloadableFileDescription>>> downloadWithBackgroundProcess(final File targetDir, final Project project) {
        final Ref localFiles = Ref.create(null);
        Ref exceptionRef = Ref.create(null);
        final CompletableFuture<List<Pair<VirtualFile, DownloadableFileDescription>>> result = new CompletableFuture<List<Pair<VirtualFile, DownloadableFileDescription>>>();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, this.myDialogTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    localFiles.set(FileDownloaderImpl.this.download(targetDir));
                }
                catch (IOException exception) {
                    boolean tryAgain = IdeUiService.getInstance().showErrorDialog(FileDownloaderImpl.this.myDialogTitle, exception.getMessage());
                    if (tryAgain) {
                        FileDownloaderImpl.this.downloadWithBackgroundProcess(targetDir, project).thenAccept(pairs -> result.complete(pairs));
                    }
                    result.complete(null);
                }
            }

            public void onSuccess() {
                List files = (List)localFiles.get();
                result.complete(files != null ? FileDownloaderImpl.findVirtualFiles(files) : null);
            }

            public void onCancel() {
                result.complete(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/download/impl/FileDownloaderImpl$1", "run"));
            }
        });
        CompletableFuture<List<Pair<VirtualFile, DownloadableFileDescription>>> completableFuture = result;
        if (completableFuture == null) {
            FileDownloaderImpl.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    @NotNull
    public List<Pair<File, DownloadableFileDescription>> download(@NotNull File targetDir) throws IOException {
        ArrayList<Pair<File, DownloadableFileDescription>> arrayList;
        if (targetDir == null) {
            FileDownloaderImpl.$$$reportNull$$$0(3);
        }
        List downloadedFiles = Collections.synchronizedList(new ArrayList());
        List existingFiles = Collections.synchronizedList(new ArrayList());
        ProgressIndicator parentIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (parentIndicator == null) {
            parentIndicator = new EmptyProgressIndicator();
        } else {
            parentIndicator.setIndeterminate(false);
        }
        try {
            ConcurrentTasksProgressManager progressManager = new ConcurrentTasksProgressManager(parentIndicator, this.myFileDescriptions.size());
            parentIndicator.setText(IdeCoreBundle.message((String)"progress.downloading.0.files.text", (Object[])new Object[]{this.myFileDescriptions.size()}));
            int maxParallelDownloads = Runtime.getRuntime().availableProcessors();
            LOG.debug("Downloading " + this.myFileDescriptions.size() + " files using " + maxParallelDownloads + " threads");
            long start = System.currentTimeMillis();
            ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileDownloaderImpl Pool", (int)maxParallelDownloads);
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
            AtomicLong totalSize = new AtomicLong();
            for (DownloadableFileDescription downloadableFileDescription : this.myFileDescriptions) {
                results.add(executor.submit(() -> {
                    SubTaskProgressIndicator indicator = progressManager.createSubTaskIndicator(1);
                    indicator.checkCanceled();
                    File existing = new File(targetDir, description.getDefaultFileName());
                    String url = description.getDownloadUrl();
                    if (url.startsWith(LIB_SCHEMA)) {
                        String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)LIB_SCHEMA));
                        File file = new File(PathManager.getLibPath(), path);
                        existingFiles.add(Pair.create((Object)file, (Object)description));
                    } else if (url.startsWith("file://")) {
                        String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)"file://"));
                        File file = new File(path);
                        if (file.exists()) {
                            existingFiles.add(Pair.create((Object)file, (Object)description));
                        }
                    } else {
                        File downloaded;
                        LOG.debug("Downloading `" + url + "` into `" + String.valueOf(existing) + "`");
                        try {
                            downloaded = FileDownloaderImpl.downloadFile(description, existing, (ProgressIndicator)indicator);
                        }
                        catch (IOException e) {
                            throw new IOException(IdeCoreBundle.message((String)"error.file.download.failed", (Object[])new Object[]{description.getDownloadUrl(), e.getMessage()}), e);
                        }
                        if (FileUtil.filesEqual((File)downloaded, (File)existing)) {
                            existingFiles.add(Pair.create((Object)existing, (Object)description));
                        } else {
                            totalSize.addAndGet(downloaded.length());
                            downloadedFiles.add(Pair.create((Object)downloaded, (Object)description));
                        }
                    }
                    indicator.finished();
                    return null;
                }));
            }
            for (Future future : results) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)e.getCause();
                    }
                    LOG.error((Throwable)e);
                }
            }
            long duration = System.currentTimeMillis() - start;
            LOG.debug("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration) + "(" + duration + "ms)");
            ArrayList<Pair<File, DownloadableFileDescription>> localFiles = new ArrayList<Pair<File, DownloadableFileDescription>>();
            localFiles.addAll(FileDownloaderImpl.moveToDir(downloadedFiles, targetDir));
            localFiles.addAll(existingFiles);
            arrayList = localFiles;
        }
        catch (ProcessCanceledException | IOException e) {
            FileDownloaderImpl.deleteFiles(downloadedFiles);
            throw e;
        }
        if (arrayList == null) {
            FileDownloaderImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile chooseDirectoryForFiles(Project project, JComponent parentComponent) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(IdeCoreBundle.message((String)"dialog.directory.for.downloaded.files.title", (Object[])new Object[0])).withDescription(IdeCoreBundle.message((String)"dialog.directory.for.downloaded.files.description", (Object[])new Object[0]));
        VirtualFile baseDir = project != null ? project.getBaseDir() : null;
        return IdeUiService.getInstance().chooseFile(descriptor, parentComponent, project, baseDir);
    }

    private static List<Pair<File, DownloadableFileDescription>> moveToDir(List<? extends Pair<File, DownloadableFileDescription>> downloadedFiles, File targetDir) throws IOException {
        FileUtil.createDirectory((File)targetDir);
        ArrayList<Pair<File, DownloadableFileDescription>> result = new ArrayList<Pair<File, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : downloadedFiles) {
            DownloadableFileDescription description = (DownloadableFileDescription)pair.getSecond();
            String fileName = description.generateFileName(s -> !new File(targetDir, (String)s).exists());
            File toFile = new File(targetDir, fileName);
            FileUtil.rename((File)((File)pair.getFirst()), (File)toFile);
            result.add((Pair<File, DownloadableFileDescription>)Pair.create((Object)toFile, (Object)description));
        }
        return result;
    }

    @NotNull
    private static List<Pair<VirtualFile, DownloadableFileDescription>> findVirtualFiles(@NotNull List<? extends Pair<File, DownloadableFileDescription>> ioFiles) {
        if (ioFiles == null) {
            FileDownloaderImpl.$$$reportNull$$$0(5);
        }
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> result = new ArrayList<Pair<VirtualFile, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : ioFiles) {
            File ioFile = (File)pair.getFirst();
            VirtualFile libraryRootFile = (VirtualFile)WriteAction.computeAndWait(() -> {
                String url = VfsUtil.getUrlForLibraryRoot((File)ioFile);
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
                return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
            });
            if (libraryRootFile == null) continue;
            result.add((Pair<VirtualFile, DownloadableFileDescription>)Pair.create((Object)libraryRootFile, (Object)((DownloadableFileDescription)pair.getSecond())));
        }
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> arrayList = result;
        if (arrayList == null) {
            FileDownloaderImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void deleteFiles(List<? extends Pair<File, DownloadableFileDescription>> pairs) {
        for (Pair<File, DownloadableFileDescription> pair : pairs) {
            FileUtil.delete((File)((File)pair.getFirst()));
        }
    }

    @NotNull
    private static File downloadFile(final @NotNull DownloadableFileDescription description, final @NotNull File existingFile, final @NotNull ProgressIndicator indicator) throws IOException {
        if (description == null) {
            FileDownloaderImpl.$$$reportNull$$$0(7);
        }
        if (existingFile == null) {
            FileDownloaderImpl.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            FileDownloaderImpl.$$$reportNull$$$0(9);
        }
        final String presentableUrl = description.getPresentableDownloadUrl();
        indicator.setText(IdeCoreBundle.message((String)"progress.connecting.to.download.file.text", (Object[])new Object[]{presentableUrl}));
        File file = (File)HttpRequests.request((String)description.getDownloadUrl()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    2.$$$reportNull$$$0(0);
                }
                int size = request.getConnection().getContentLength();
                if (existingFile.exists() && (long)size == existingFile.length()) {
                    return existingFile;
                }
                indicator.setText(IdeCoreBundle.message((String)"progress.download.file.text", (Object[])new Object[]{description.getPresentableFileName(), presentableUrl}));
                return request.saveToFile(FileUtil.createTempFile((String)"download.", (String)".tmp"), indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/download/impl/FileDownloaderImpl$2", "process"));
            }
        });
        if (file == null) {
            FileDownloaderImpl.$$$reportNull$$$0(10);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDescriptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableDownloadName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/download/impl/FileDownloaderImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/download/impl/FileDownloaderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadWithBackgroundProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 10 -> new IllegalStateException(string);
        };
    }
}

