/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.om.Any;
import com.thaiopensource.xml.dtd.om.Attribute;
import com.thaiopensource.xml.dtd.om.AttributeDefault;
import com.thaiopensource.xml.dtd.om.AttributeDefaultRef;
import com.thaiopensource.xml.dtd.om.AttributeGroup;
import com.thaiopensource.xml.dtd.om.AttributeGroupMember;
import com.thaiopensource.xml.dtd.om.AttributeGroupRef;
import com.thaiopensource.xml.dtd.om.CdataDatatype;
import com.thaiopensource.xml.dtd.om.Datatype;
import com.thaiopensource.xml.dtd.om.DatatypeRef;
import com.thaiopensource.xml.dtd.om.DefaultValue;
import com.thaiopensource.xml.dtd.om.EnumDatatype;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.EnumGroupMember;
import com.thaiopensource.xml.dtd.om.EnumGroupRef;
import com.thaiopensource.xml.dtd.om.FixedValue;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.FlagRef;
import com.thaiopensource.xml.dtd.om.Ignore;
import com.thaiopensource.xml.dtd.om.ImpliedValue;
import com.thaiopensource.xml.dtd.om.Include;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.ModelGroupRef;
import com.thaiopensource.xml.dtd.om.Name;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.NameSpecRef;
import com.thaiopensource.xml.dtd.om.NotationDatatype;
import com.thaiopensource.xml.dtd.om.RequiredValue;
import com.thaiopensource.xml.dtd.om.Sequence;
import com.thaiopensource.xml.dtd.om.TokenizedDatatype;
import com.thaiopensource.xml.dtd.parse.DtdBuilder;
import com.thaiopensource.xml.dtd.parse.Entity;
import com.thaiopensource.xml.dtd.parse.ParamStream;
import com.thaiopensource.xml.dtd.parse.Particle;
import java.util.Enumeration;
import java.util.Vector;

class Param {
    static final int REFERENCE = 0;
    static final int REFERENCE_END = 1;
    static final int LITERAL = 2;
    static final int MODEL_GROUP = 3;
    static final int PERCENT = 4;
    static final int IMPLIED = 5;
    static final int REQUIRED = 6;
    static final int FIXED = 7;
    static final int EMPTY = 8;
    static final int ANY = 9;
    static final int ELEMENT_NAME = 10;
    static final int ATTRIBUTE_NAME = 11;
    static final int ATTRIBUTE_TYPE = 12;
    static final int ATTRIBUTE_TYPE_NOTATION = 13;
    static final int DEFAULT_ATTRIBUTE_VALUE = 14;
    static final int ATTRIBUTE_VALUE_GROUP = 15;
    static final int EMPTY_ATTRIBUTE_GROUP = 16;
    static final int NOTATION_GROUP = 17;
    static final int IGNORE = 18;
    static final int INCLUDE = 19;
    static final int OTHER = 30;
    final int type;
    Entity entity;
    Particle group;
    String value;

    Param(int n) {
        this.type = n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Param)) {
            return false;
        }
        Param param = (Param)object;
        if (this.type != param.type) {
            return false;
        }
        if (this.entity != param.entity) {
            return false;
        }
        if (this.value != null && !this.value.equals(param.value)) {
            return false;
        }
        return this.group == null || this.group.equals(param.group);
    }

    static AttributeGroup paramsToAttributeGroup(Vector vector) {
        return Param.paramsToAttributeGroup(new ParamStream(vector, true));
    }

    static AttributeGroup paramsToAttributeGroup(ParamStream paramStream) {
        Object object;
        Vector<AttributeGroupMember[]> vector = new Vector<AttributeGroupMember[]>();
        while (paramStream.advance()) {
            object = null;
            switch (paramStream.type) {
                case 16: {
                    break;
                }
                case 0: {
                    if (paramStream.entity.semantic == 2) {
                        object = new AttributeGroupRef(paramStream.entity.name, paramStream.entity.attributeGroup);
                        break;
                    }
                }
                case 11: {
                    NameSpec nameSpec = Param.currentParamToNameSpec(paramStream);
                    Datatype datatype = Param.paramsToDatatype(paramStream);
                    AttributeDefault attributeDefault = Param.paramsToAttributeDefault(paramStream);
                    object = new Attribute(nameSpec, datatype, attributeDefault);
                }
            }
            if (object == null) continue;
            vector.addElement((AttributeGroupMember[])object);
        }
        object = new AttributeGroupMember[vector.size()];
        int n = 0;
        while (n < ((AttributeGroupMember[])object).length) {
            object[n] = (AttributeGroupMember)vector.elementAt(n);
            ++n;
        }
        return new AttributeGroup((AttributeGroupMember[])object);
    }

    static Datatype paramsToDatatype(Vector vector) {
        return Param.paramsToDatatype(new ParamStream(vector, true));
    }

    static Datatype paramsToDatatype(ParamStream paramStream) {
        paramStream.advance();
        switch (paramStream.type) {
            case 0: {
                return new DatatypeRef(paramStream.entity.name, paramStream.entity.datatype);
            }
            case 15: {
                return new EnumDatatype(Particle.particlesToEnumGroup(paramStream.group.particles));
            }
            case 13: {
                paramStream.advance();
                return new NotationDatatype(Param.paramToEnumGroup(paramStream));
            }
            case 12: {
                if (paramStream.value.equals("CDATA")) {
                    return new CdataDatatype();
                }
                return new TokenizedDatatype(paramStream.value);
            }
        }
        throw new Error();
    }

    static EnumGroup paramToEnumGroup(ParamStream paramStream) {
        if (paramStream.type == 0) {
            return new EnumGroup(new EnumGroupMember[]{new EnumGroupRef(paramStream.entity.name, paramStream.entity.enumGroup)});
        }
        return Particle.particlesToEnumGroup(paramStream.group.particles);
    }

    static AttributeDefault paramsToAttributeDefault(Vector vector) {
        return Param.paramsToAttributeDefault(new ParamStream(vector, true));
    }

    static AttributeDefault paramsToAttributeDefault(ParamStream paramStream) {
        paramStream.advance();
        switch (paramStream.type) {
            case 0: {
                return new AttributeDefaultRef(paramStream.entity.name, paramStream.entity.attributeDefault);
            }
            case 6: {
                return new RequiredValue();
            }
            case 7: {
                paramStream.advance();
                return new FixedValue(paramStream.value);
            }
            case 14: {
                return new DefaultValue(paramStream.value);
            }
            case 5: {
                return new ImpliedValue();
            }
        }
        throw new Error();
    }

    static ModelGroup paramsToModelGroup(Vector vector) {
        return Param.paramsToModelGroup(new ParamStream(vector, true));
    }

    static ModelGroup paramsToModelGroup(ParamStream paramStream) {
        paramStream.advance();
        switch (paramStream.type) {
            case 0: {
                return new ModelGroupRef(paramStream.entity.name, paramStream.entity.modelGroup);
            }
            case 9: {
                return new Any();
            }
            case 8: {
                return new Sequence(new ModelGroup[0]);
            }
            case 3: {
                return paramStream.group.createModelGroup();
            }
        }
        throw new Error();
    }

    static Flag paramsToFlag(Vector vector) {
        return Param.paramsToFlag(new ParamStream(vector, true));
    }

    static Flag paramsToFlag(ParamStream paramStream) {
        paramStream.advance();
        switch (paramStream.type) {
            case 0: {
                return new FlagRef(paramStream.entity.name, paramStream.entity.flag);
            }
            case 18: {
                return new Ignore();
            }
            case 19: {
                return new Include();
            }
        }
        throw new Error();
    }

    static NameSpec paramsToNameSpec(Vector vector) {
        return Param.paramsToNameSpec(new ParamStream(vector, true));
    }

    static NameSpec paramsToNameSpec(ParamStream paramStream) {
        paramStream.advance();
        return Param.currentParamToNameSpec(paramStream);
    }

    private static NameSpec currentParamToNameSpec(ParamStream paramStream) {
        switch (paramStream.type) {
            case 0: {
                return new NameSpecRef(paramStream.entity.name, paramStream.entity.nameSpec);
            }
            case 10: 
            case 11: {
                return new Name(paramStream.value);
            }
        }
        throw new Error();
    }

    static void examineElementNames(DtdBuilder dtdBuilder, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Param param = (Param)enumeration.nextElement();
            switch (param.type) {
                case 10: {
                    dtdBuilder.noteElementName(param.value, null);
                    break;
                }
                case 3: {
                    Particle.examineElementNames(dtdBuilder, param.group.particles.elements());
                }
            }
        }
    }
}

