/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.tcp;

import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.impl.fs.telemetry.TracingFileSystemProvider;
import com.intellij.platform.eel.provider.MultiRoutingFileSystemBackend;
import com.intellij.platform.eel.tcp.TcpEelDescriptor;
import com.intellij.platform.eel.tcp.TcpEelPathParser;
import com.intellij.platform.ijent.community.impl.IjentFailSafeFileSystemPosixApiKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u000b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/tcp/TcpEelMrfsBackend;", "Lcom/intellij/platform/eel/provider/MultiRoutingFileSystemBackend;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/nio/file/FileSystem;", "compute", "localFS", "sanitizedPath", "createFilesystem", "internalName", "descriptor", "Lcom/intellij/platform/eel/tcp/TcpEelDescriptor;", "getCustomRoots", "", "getCustomFileStores", "Ljava/nio/file/FileStore;", "Companion", "intellij.platform.eel.tcp"})
@SourceDebugExtension(value={"SMAP\nTcpEelMrfsBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TcpEelMrfsBackend.kt\ncom/intellij/platform/eel/tcp/TcpEelMrfsBackend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n1586#2:67\n1661#2,3:68\n1391#2:71\n1480#2,5:72\n13#3:77\n*S KotlinDebug\n*F\n+ 1 TcpEelMrfsBackend.kt\ncom/intellij/platform/eel/tcp/TcpEelMrfsBackend\n*L\n60#1:67\n60#1:68,3\n64#1:71\n64#1:72,5\n22#1:77\n*E\n"})
public final class TcpEelMrfsBackend
implements MultiRoutingFileSystemBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<String, FileSystem> cache;
    @NotNull
    private static final Logger LOG;

    public TcpEelMrfsBackend(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.cache = new ConcurrentHashMap();
    }

    @Nullable
    public FileSystem compute(@NotNull FileSystem localFS, @NotNull String sanitizedPath) {
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Intrinsics.checkNotNullParameter((Object)sanitizedPath, (String)"sanitizedPath");
        String string = TcpEelPathParser.Companion.extractInternalMachineId(sanitizedPath);
        if (string == null) {
            return null;
        }
        String internalName = string;
        TcpEelDescriptor tcpEelDescriptor = TcpEelPathParser.Companion.toDescriptor(internalName);
        if (tcpEelDescriptor == null) {
            return null;
        }
        TcpEelDescriptor descriptor = tcpEelDescriptor;
        return this.cache.computeIfAbsent(internalName, arg_0 -> TcpEelMrfsBackend.compute$lambda$1(arg_0 -> TcpEelMrfsBackend.compute$lambda$0(this, internalName, localFS, descriptor, arg_0), arg_0));
    }

    private final FileSystem createFilesystem(String internalName, FileSystem localFS, TcpEelDescriptor descriptor) {
        Path localPath = localFS.getPath(descriptor.getRootPathString(), new String[0]);
        if (Files.exists(localPath, new LinkOption[0])) {
            LOG.warn("Cannot create TCP filesystem: local path already exists: " + localPath);
        }
        URI ijentUri = new URI("ijent", "tcp", "/" + internalName, null, null);
        TracingFileSystemProvider ijentDefaultProvider = new TracingFileSystemProvider((FileSystemProvider)IjentNioFileSystemProvider.Companion.getInstance(), null, 2, null);
        try {
            IjentFileSystemApi ijentFs = IjentFailSafeFileSystemPosixApiKt.IjentFailSafeFileSystemPosixApi((CoroutineScope)this.scope, (EelDescriptor)((EelDescriptor)descriptor), null);
            ijentDefaultProvider.newFileSystem(ijentUri, IjentNioFileSystemProvider.Companion.newFileSystemMap(ijentFs));
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        LOG.info("New FileSystem initialized for " + internalName + " at " + localPath + " and URI=" + ijentUri);
        Intrinsics.checkNotNull((Object)localPath);
        FileSystemProvider fileSystemProvider = (FileSystemProvider)ijentDefaultProvider;
        FileSystemProvider fileSystemProvider2 = localFS.provider();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystemProvider2, (String)"provider(...)");
        DelegatingFileSystem delegatingFileSystem = new IjentEphemeralRootAwareFileSystemProvider(localPath, fileSystemProvider, (FileSystemProvider)new TracingFileSystemProvider(fileSystemProvider2, null, 2, null), false).getFileSystem(ijentUri);
        Intrinsics.checkNotNullExpressionValue((Object)delegatingFileSystem, (String)"getFileSystem(...)");
        return (FileSystem)delegatingFileSystem;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getCustomRoots() {
        void $this$mapTo$iv$iv;
        Set set = this.cache.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("/tcp-" + (String)it);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<FileStore> getCustomFileStores(@NotNull FileSystem localFS) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Collection<FileSystem> collection = this.cache.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable<FileStore> list$iv$iv;
            FileSystem it = (FileSystem)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it.getFileStores(), (String)"getFileStores(...)");
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final FileSystem compute$lambda$0(TcpEelMrfsBackend this$0, String $internalName, FileSystem $localFS, TcpEelDescriptor $descriptor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createFilesystem($internalName, $localFS, $descriptor);
    }

    private static final FileSystem compute$lambda$1(Function1 $tmp0, Object p0) {
        return (FileSystem)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TcpEelMrfsBackend.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/eel/tcp/TcpEelMrfsBackend$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.eel.tcp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

