/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001f\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SwapColumnsAction;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction;", "swapWithLeftColumn", "", "<init>", "(Z)V", "performAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "columnIndex", "", "findOtherColumnIndex", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;I)Ljava/lang/Integer;", "update", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;Ljava/lang/Integer;)V", "SwapWithLeftColumn", "SwapWithRightColumn", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nSwapColumnsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwapColumnsAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/column/SwapColumnsAction\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,52:1\n7#2,6:53\n*S KotlinDebug\n*F\n+ 1 SwapColumnsAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/column/SwapColumnsAction\n*L\n21#1:53,6\n*E\n"})
public abstract class SwapColumnsAction
extends ColumnBasedTableAction {
    private final boolean swapWithLeftColumn;

    public SwapColumnsAction(boolean swapWithLeftColumn) {
        this.swapWithLeftColumn = swapWithLeftColumn;
    }

    @Override
    protected void performAction(@NotNull Editor editor2, @NotNull MarkdownTable table, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        ActionsKt.runWriteAction(() -> SwapColumnsAction.performAction$lambda$0(this, table, columnIndex));
    }

    private final Integer findOtherColumnIndex(MarkdownTable table, int columnIndex) {
        IntRange indices = TableUtils.INSTANCE.getColumnsIndices(table);
        return this.swapWithLeftColumn && columnIndex - 1 >= 0 ? Integer.valueOf(columnIndex - 1) : (!this.swapWithLeftColumn && columnIndex + 1 <= indices.getLast() ? Integer.valueOf(columnIndex + 1) : null);
    }

    @Override
    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable Integer columnIndex) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event, table, columnIndex);
        if (table != null && columnIndex != null) {
            event.getPresentation().setEnabled(this.findOtherColumnIndex(table, columnIndex) != null);
        }
    }

    private static final Unit performAction$lambda$0(SwapColumnsAction this$0, MarkdownTable $table, int $columnIndex) {
        Integer otherColumnIndex = this$0.findOtherColumnIndex($table, $columnIndex);
        if (otherColumnIndex == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        List<MarkdownTableCell> currentColumn = TableUtils.INSTANCE.getColumnCells($table, $columnIndex, true);
        List<MarkdownTableCell> otherColumn = TableUtils.INSTANCE.getColumnCells($table, otherColumnIndex, true);
        Project project$iv = $table.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(currentColumn, otherColumn, $table, $columnIndex, otherColumnIndex){
            final /* synthetic */ List $currentColumn$inlined;
            final /* synthetic */ List $otherColumn$inlined;
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ int $columnIndex$inlined;
            final /* synthetic */ Integer $otherColumnIndex$inlined;
            {
                this.$currentColumn$inlined = list2;
                this.$otherColumn$inlined = list3;
                this.$table$inlined = markdownTable;
                this.$columnIndex$inlined = n;
                this.$otherColumnIndex$inlined = n2;
            }

            public final void run() {
                block1: {
                    boolean bl = false;
                    for (Pair pair : CollectionsKt.zip((Iterable)this.$currentColumn$inlined, (Iterable)this.$otherColumn$inlined)) {
                        MarkdownTableCell current = (MarkdownTableCell)pair.component1();
                        MarkdownTableCell other = (MarkdownTableCell)pair.component2();
                        PsiElement currentCopy = current.copy();
                        current.replace((PsiElement)other);
                        other.replace(currentCopy);
                    }
                    MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(this.$table$inlined);
                    if (markdownTableSeparatorRow == null) break block1;
                    TableModificationUtils.INSTANCE.swapCells(markdownTableSeparatorRow, this.$columnIndex$inlined, this.$otherColumnIndex$inlined);
                }
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SwapColumnsAction$SwapWithLeftColumn;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SwapColumnsAction;", "<init>", "()V", "intellij.markdown"})
    public static final class SwapWithLeftColumn
    extends SwapColumnsAction {
        public SwapWithLeftColumn() {
            super(true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SwapColumnsAction$SwapWithRightColumn;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SwapColumnsAction;", "<init>", "()V", "intellij.markdown"})
    public static final class SwapWithRightColumn
    extends SwapColumnsAction {
        public SwapWithRightColumn() {
            super(false);
        }
    }
}

