/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.inspections.IntentionOnElementAtCaretWrapper;
import org.intellij.plugins.markdown.editor.tables.intentions.FixCellAlignmentIntention;
import org.intellij.plugins.markdown.editor.tables.intentions.ReformatTableIntention;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/inspections/MarkdownIncorrectTableFormattingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReformatTableFix", "FixCellAlignmentFix", "intellij.markdown"})
@ApiStatus.Internal
public final class MarkdownIncorrectTableFormattingInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MarkdownElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitTable(MarkdownTable table) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                super.visitTable(table);
                if (!TableModificationUtils.INSTANCE.isCorrectlyFormatted(table, false)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReformatTableFix()};
                    this.$holder.registerProblem((PsiElement)table, MarkdownBundle.message("markdown.incorrect.table.formatting.inspection.description", new Object[0]), localQuickFixArray);
                }
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                super.visitElement(element2);
                MarkdownTableCell markdownTableCell = element2 instanceof MarkdownTableCell ? (MarkdownTableCell)element2 : null;
                if (markdownTableCell == null) {
                    return;
                }
                MarkdownTableCell cell = markdownTableCell;
                MarkdownTable markdownTable = cell.getParentTable();
                if (markdownTable == null) {
                    return;
                }
                MarkdownTable table = markdownTable;
                MarkdownTableSeparatorRow.CellAlignment alignment = TableUtils.INSTANCE.getColumnAlignment(table, cell.getColumnIndex());
                if (alignment != MarkdownTableSeparatorRow.CellAlignment.NONE && !TableModificationUtils.INSTANCE.hasValidAlignment(cell)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new FixCellAlignmentFix()};
                    this.$holder.registerProblem(element2, MarkdownBundle.message("markdown.incorrect.table.formatting.inspection.local.cell.description", new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/inspections/MarkdownIncorrectTableFormattingInspection$FixCellAlignmentFix;", "Lorg/intellij/plugins/markdown/editor/tables/inspections/IntentionOnElementAtCaretWrapper;", "<init>", "()V", "intellij.markdown"})
    private static final class FixCellAlignmentFix
    extends IntentionOnElementAtCaretWrapper {
        public FixCellAlignmentFix() {
            super(new FixCellAlignmentIntention());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/inspections/MarkdownIncorrectTableFormattingInspection$ReformatTableFix;", "Lorg/intellij/plugins/markdown/editor/tables/inspections/IntentionOnElementAtCaretWrapper;", "<init>", "()V", "intellij.markdown"})
    private static final class ReformatTableFix
    extends IntentionOnElementAtCaretWrapper {
        public ReformatTableFix() {
            super(new ReformatTableIntention());
        }
    }
}

