/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.images.MarkdownImagesBundle;
import org.intellij.plugins.markdown.images.editor.ConfigureImageDialog;
import org.intellij.plugins.markdown.images.editor.ConfigureImageLineMarkerProviderBase;
import org.intellij.plugins.markdown.images.editor.ImagePsiElementFactory;
import org.intellij.plugins.markdown.images.editor.ImageUtils;
import org.intellij.plugins.markdown.images.editor.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ConfigureTextHtmlImageLineMarkerProvider;", "Lorg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "obtainLeafElement", "element", "obtainOuterElement", "obtainPathText", "", "createDialog", "Lorg/intellij/plugins/markdown/images/editor/ConfigureImageDialog;", "applyChanges", "", "imageData", "Lorg/intellij/plugins/markdown/images/editor/MarkdownImageData;", "updateAttributes", "convertToMarkdown", "intellij.markdown.images"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConfigureTextHtmlImageLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureTextHtmlImageLineMarkerProvider.kt\norg/intellij/plugins/markdown/images/editor/ConfigureTextHtmlImageLineMarkerProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class ConfigureTextHtmlImageLineMarkerProvider
extends ConfigureImageLineMarkerProviderBase<PsiElement> {
    @Override
    @Nullable
    public PsiElement obtainLeafElement(@NotNull PsiElement element2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element2), (Object)MarkdownTokenTypes.HTML_TAG)) {
            return null;
        }
        PsiElement it = psiElement = element2;
        boolean bl = false;
        return ImageUtils.createImageTagFromText(element2) != null ? psiElement : null;
    }

    @Override
    @Nullable
    public PsiElement obtainOuterElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.obtainLeafElement(element2);
    }

    @Override
    @Nullable
    public String obtainPathText(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        XmlTag xmlTag = ImageUtils.createImageTagFromText(element2);
        return xmlTag != null ? xmlTag.getAttributeValue("src") : null;
    }

    @Override
    @Nullable
    public ConfigureImageDialog createDialog(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        XmlTag xmlTag = ImageUtils.createImageTagFromText(element2);
        if (xmlTag == null) {
            return null;
        }
        XmlTag image = xmlTag;
        return new ConfigureImageDialog(image.getProject(), MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.title.text", new Object[0]), this.obtainPathText(element2), image.getAttributeValue("width"), image.getAttributeValue("height"), image.getAttributeValue("title"), image.getAttributeValue("alt"), true);
    }

    @Override
    public void applyChanges(@NotNull PsiElement element2, @NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        if (imageData.getShouldConvertToHtml()) {
            this.updateAttributes(element2, imageData);
        } else {
            this.convertToMarkdown(element2, imageData);
        }
    }

    private final void updateAttributes(PsiElement element2, MarkdownImageData imageData) {
        Runnable action = () -> ConfigureTextHtmlImageLineMarkerProvider.updateAttributes$lambda$0(element2, imageData);
        WriteCommandAction.runWriteCommandAction((Project)element2.getProject(), (String)MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.line.marker.update.html.image.attributes.command.name", new Object[0]), null, (Runnable)action, (PsiFile[])new PsiFile[0]);
    }

    private final void convertToMarkdown(PsiElement element2, MarkdownImageData imageData) {
        Runnable action = () -> ConfigureTextHtmlImageLineMarkerProvider.convertToMarkdown$lambda$0(element2, imageData);
        WriteCommandAction.runWriteCommandAction((Project)element2.getProject(), (String)MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.line.marker.convert.html.to.markdown.command.name", new Object[0]), null, (Runnable)action, (PsiFile[])new PsiFile[0]);
    }

    private static final void updateAttributes$lambda$0(PsiElement $element, MarkdownImageData $imageData) {
        Project project = $element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement replacement = ImagePsiElementFactory.INSTANCE.createHtmlImageTag(project, $imageData);
        $element.replace(replacement);
    }

    private static final void convertToMarkdown$lambda$0(PsiElement $element, MarkdownImageData $imageData) {
        Project project = $element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        $element.replace(ImagePsiElementFactory.INSTANCE.createImage(project, $imageData.getDescription(), $imageData.getPath(), $imageData.getTitle()));
    }
}

