/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogRootStoredRefs;
import com.intellij.vcs.log.graph.GraphCommit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\t\u001a6\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\u0005j\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/data/RefreshSessionData;", "", "<init>", "()V", "refsByRoot", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogRootStoredRefs;", "Lkotlin/collections/HashMap;", "commitsByRoot", "", "Lcom/intellij/vcs/log/graph/GraphCommit;", "", "put", "", "other", "root", "commits", "refs", "", "getCommits", "()Ljava/util/Collection;", "", "getRefs", "()Ljava/util/Map;", "intellij.platform.vcs.log.impl"})
final class RefreshSessionData {
    @NotNull
    private final HashMap<VirtualFile, VcsLogRootStoredRefs> refsByRoot = new HashMap();
    @NotNull
    private final HashMap<VirtualFile, List<GraphCommit<Integer>>> commitsByRoot = new HashMap();

    public final void put(@NotNull RefreshSessionData other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.commitsByRoot.putAll((Map<VirtualFile, List<GraphCommit<Integer>>>)other.commitsByRoot);
        this.refsByRoot.putAll((Map<VirtualFile, VcsLogRootStoredRefs>)other.refsByRoot);
    }

    public final void put(@NotNull VirtualFile root, @NotNull List<? extends GraphCommit<Integer>> commits, @NotNull VcsLogRootStoredRefs refs) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
        ((Map)this.commitsByRoot).put(root, commits);
        ((Map)this.refsByRoot).put(root, refs);
    }

    @NotNull
    public final Collection<List<GraphCommit<Integer>>> getCommits() {
        Collection<List<GraphCommit<Integer>>> collection = this.commitsByRoot.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @NotNull
    public final Map<VirtualFile, VcsLogRootStoredRefs> getRefs() {
        return MapsKt.toMap((Map)this.refsByRoot);
    }

    @Nullable
    public final VcsLogRootStoredRefs getRefs(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.refsByRoot.get(root);
    }
}

