/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.FileHistoryKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00032\n\u0010\u0017\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u001e\u001a\u00020\u0006H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR)\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014 \u0013*\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00070\u0006j\u0002`\u00070\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/history/Rename;", "", "parentPath", "Lcom/intellij/openapi/vcs/FilePath;", "childPath", "parentCommit", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "childCommit", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/FilePath;II)V", "getParentPath", "()Lcom/intellij/openapi/vcs/FilePath;", "getChildPath", "getParentCommit", "()I", "getChildCommit", "commits", "Lcom/intellij/openapi/util/UnorderedPair;", "kotlin.jvm.PlatformType", "getCommits", "()Lcom/intellij/openapi/util/UnorderedPair;", "getOtherPath", "commit", "filePath", "ad", "Lcom/intellij/vcs/log/history/AdditionDeletion;", "equals", "", "other", "hashCode", "intellij.platform.vcs.log.impl"})
public final class Rename {
    @NotNull
    private final FilePath parentPath;
    @NotNull
    private final FilePath childPath;
    private final int parentCommit;
    private final int childCommit;

    public Rename(@NotNull FilePath parentPath, @NotNull FilePath childPath, int parentCommit, int childCommit) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)childPath, (String)"childPath");
        this.parentPath = parentPath;
        this.childPath = childPath;
        this.parentCommit = parentCommit;
        this.childCommit = childCommit;
    }

    @NotNull
    public final FilePath getParentPath() {
        return this.parentPath;
    }

    @NotNull
    public final FilePath getChildPath() {
        return this.childPath;
    }

    public final int getParentCommit() {
        return this.parentCommit;
    }

    public final int getChildCommit() {
        return this.childCommit;
    }

    @NotNull
    public final UnorderedPair<Integer> getCommits() {
        return new UnorderedPair((Object)this.parentCommit, (Object)this.childCommit);
    }

    @Nullable
    public final FilePath getOtherPath(int commit, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (commit == this.parentCommit && FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)filePath, (Object)this.parentPath)) {
            return this.childPath;
        }
        if (commit == this.childCommit && FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)filePath, (Object)this.childPath)) {
            return this.parentPath;
        }
        return null;
    }

    @Nullable
    public final FilePath getOtherPath(@NotNull AdditionDeletion ad) {
        Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
        return this.getOtherPath(ad.isAddition() ? ad.getChild() : ad.getParent(), ad.getFilePath());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.vcs.log.history.Rename");
        Rename cfr_ignored_0 = (Rename)object2;
        if (!FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)this.parentPath, (Object)((Rename)other).parentPath)) {
            return false;
        }
        if (!FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)this.childPath, (Object)((Rename)other).childPath)) {
            return false;
        }
        if (this.parentCommit != ((Rename)other).parentCommit) {
            return false;
        }
        return this.childCommit == ((Rename)other).childCommit;
    }

    public int hashCode() {
        int result = FileHistoryKt.FILE_PATH_HASHING_STRATEGY.hashCode((Object)this.parentPath);
        result = 31 * result + FileHistoryKt.FILE_PATH_HASHING_STRATEGY.hashCode((Object)this.childPath);
        result = 31 * result + this.parentCommit;
        result = 31 * result + this.childCommit;
        return result;
    }
}

