/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vcs.VcsRefNamesInterner;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class VcsRefImpl
implements VcsRef {
    @NotNull
    private final Hash myCommitHash;
    @NotNull
    private final String myName;
    @NotNull
    private final VcsRefType myType;
    @NotNull
    private final VirtualFile myRoot;

    public VcsRefImpl(@NotNull Hash commitHash, @NotNull String name, @NotNull VcsRefType type, @NotNull VirtualFile root) {
        if (commitHash == null) {
            VcsRefImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            VcsRefImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            VcsRefImpl.$$$reportNull$$$0(2);
        }
        if (root == null) {
            VcsRefImpl.$$$reportNull$$$0(3);
        }
        this.myCommitHash = commitHash;
        this.myType = type;
        this.myRoot = root;
        this.myName = VcsRefNamesInterner.get((String)name);
    }

    @NotNull
    public VcsRefType getType() {
        VcsRefType vcsRefType = this.myType;
        if (vcsRefType == null) {
            VcsRefImpl.$$$reportNull$$$0(4);
        }
        return vcsRefType;
    }

    @NotNull
    public Hash getCommitHash() {
        Hash hash = this.myCommitHash;
        if (hash == null) {
            VcsRefImpl.$$$reportNull$$$0(5);
        }
        return hash;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            VcsRefImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            VcsRefImpl.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    public String toString() {
        return String.format("%s:%s(%s|%s)", this.myRoot.getName(), this.myName, this.myCommitHash, this.myType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRefImpl ref = (VcsRefImpl)o;
        if (!this.myCommitHash.equals((Object)ref.myCommitHash)) {
            return false;
        }
        if (!this.myName.equals(ref.myName)) {
            return false;
        }
        if (!this.myRoot.equals(ref.myRoot)) {
            return false;
        }
        return this.myType == ref.myType;
    }

    public int hashCode() {
        int result = this.myCommitHash.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsRefImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsRefImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitHash";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

