/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.feedback.FeedbackSurvey;
import com.intellij.platform.feedback.impl.OnDemandFeedbackResolver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.feedback.TerminalFeedbackMoment;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000eJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/feedback/TerminalFeedbackUtils;", "", "<init>", "()V", "TERMINAL_FEEDBACK_MOMENT", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/terminal/block/feedback/TerminalFeedbackMoment;", "showFeedbackNotificationOnDemand", "", "T", "Lcom/intellij/platform/feedback/FeedbackSurvey;", "project", "Lcom/intellij/openapi/project/Project;", "surveyClass", "Lkotlin/reflect/KClass;", "getFeedbackMoment", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalFeedbackUtils {
    @NotNull
    public static final TerminalFeedbackUtils INSTANCE = new TerminalFeedbackUtils();
    @NotNull
    private static final Key<TerminalFeedbackMoment> TERMINAL_FEEDBACK_MOMENT;

    private TerminalFeedbackUtils() {
    }

    public final <T extends FeedbackSurvey> void showFeedbackNotificationOnDemand(@NotNull Project project, @NotNull KClass<T> surveyClass) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(surveyClass, (String)"surveyClass");
        project.putUserData(TERMINAL_FEEDBACK_MOMENT, (Object)TerminalFeedbackMoment.ON_DEMAND);
        OnDemandFeedbackResolver.Companion.getInstance().showFeedbackNotification(surveyClass, project, arg_0 -> TerminalFeedbackUtils.showFeedbackNotificationOnDemand$lambda$0(project, arg_0));
    }

    @NotNull
    public final TerminalFeedbackMoment getFeedbackMoment(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalFeedbackMoment terminalFeedbackMoment = (TerminalFeedbackMoment)((Object)project.getUserData(TERMINAL_FEEDBACK_MOMENT));
        if (terminalFeedbackMoment == null) {
            terminalFeedbackMoment = TerminalFeedbackMoment.AFTER_USAGE;
        }
        return terminalFeedbackMoment;
    }

    private static final Unit showFeedbackNotificationOnDemand$lambda$0(Project $project, boolean isNotificationShown) {
        if (!isNotificationShown) {
            $project.putUserData(TERMINAL_FEEDBACK_MOMENT, null);
        }
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"TerminalFeedbackMoment");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TERMINAL_FEEDBACK_MOMENT = key;
    }
}

