/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.terminal.TerminalColorPalette;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.ui.TerminalContrastRatio;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0082\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TextStyleAdapter;", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "style", "Lcom/jediterm/terminal/TextStyle;", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "ignoreContrastAdjustment", "", "<init>", "(Lcom/jediterm/terminal/TextStyle;Lcom/intellij/terminal/TerminalColorPalette;Z)V", "getStyle", "()Lcom/jediterm/terminal/TextStyle;", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "equals", "other", "", "hashCode", "", "toString", "", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalTextHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTextHighlighter.kt\norg/jetbrains/plugins/terminal/block/output/TextStyleAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n777#2:168\n873#2,2:169\n*S KotlinDebug\n*F\n+ 1 TerminalTextHighlighter.kt\norg/jetbrains/plugins/terminal/block/output/TextStyleAdapter\n*L\n80#1:168\n80#1:169,2\n*E\n"})
public final class TextStyleAdapter
implements TextAttributesProvider {
    @NotNull
    private final TextStyle style;
    @NotNull
    private final TerminalColorPalette colorPalette;
    private final boolean ignoreContrastAdjustment;

    public TextStyleAdapter(@NotNull TextStyle style, @NotNull TerminalColorPalette colorPalette, boolean ignoreContrastAdjustment) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        this.style = style;
        this.colorPalette = colorPalette;
        this.ignoreContrastAdjustment = ignoreContrastAdjustment;
    }

    public /* synthetic */ TextStyleAdapter(TextStyle textStyle, TerminalColorPalette terminalColorPalette, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(textStyle, terminalColorPalette, bl);
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    @Override
    @NotNull
    public TextAttributes getTextAttributes() {
        TerminalOptionsProvider options;
        TerminalContrastRatio requiredContrast = this.ignoreContrastAdjustment ? TerminalContrastRatio.Companion.getMIN_VALUE() : ((options = TerminalOptionsProvider.Companion.getInstance()).getEnforceMinContrastRatio() ? options.getMinContrastRatio() : TerminalContrastRatio.Companion.getMIN_VALUE());
        return TerminalUiUtils.INSTANCE.toTextAttributes(this.style, this.colorPalette, requiredContrast);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.block.output.TextStyleAdapter");
        TextStyleAdapter cfr_ignored_0 = (TextStyleAdapter)object2;
        if (this.ignoreContrastAdjustment != ((TextStyleAdapter)other).ignoreContrastAdjustment) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.style, (Object)((TextStyleAdapter)other).style);
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.ignoreContrastAdjustment);
        result2 = 31 * result2 + this.style.hashCode();
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = (Iterable)EntriesMappings.entries$0;
        TerminalColor terminalColor = this.style.getBackground();
        TerminalColor terminalColor2 = this.style.getForeground();
        boolean $i$f$filter = false;
        void var3_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextStyle.Option it = (TextStyle.Option)element$iv$iv;
            boolean bl = false;
            if (!this.style.hasOption(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return "TextStyleAdapter(style=TextStyle(fg=" + terminalColor2 + ", bg=" + terminalColor + ", op=" + list + "), ignoreContrastAdjustment=" + this.ignoreContrastAdjustment + ")";
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<TextStyle.Option> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])TextStyle.Option.values()));
        }
    }
}

